/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonfox.swagger2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import java.util.LinkedHashMap;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.RouteTable;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solonfox.swagger2.EnableSwagger2;
import org.noear.solonfox.swagger2.SwaggerController;

public class XPluginImp
implements Plugin {
    protected static Swagger swagger = new Swagger();

    public void start(SolonApp app) {
        if (app.source().getAnnotation(EnableSwagger2.class) == null) {
            return;
        }
        Aop.context().beanBuilderAdd(ApiModel.class, (clz, wrap, anno) -> {
            ModelImpl model = new ModelImpl();
            model.type(clz.getName());
            swagger.addDefinition(clz.getName(), (Model)model);
        });
        Aop.context().beanBuilderAdd(Api.class, (clz, wrap, anno) -> {
            Tag tag = new Tag();
            tag.name(clz.getName());
            swagger.addTag(tag);
        });
        app.beanScan(SwaggerController.class);
        Aop.beanOnloaded(this::onAppLoadEnd);
    }

    private void onAppLoadEnd() {
        Info info = (Info)Aop.get(Info.class);
        if (info != null) {
            swagger.info(info);
        }
        swagger.host("localhost:" + Solon.global().port());
        swagger.basePath("/");
        this.buildTags();
        this.buildPaths();
    }

    private void buildTags() {
        Aop.context().beanForeach(bw -> {
            if (bw.annotationGet(Controller.class) != null) {
                Tag tag = new Tag();
                tag.name(bw.clz().getName());
                swagger.addTag(tag);
            }
        });
    }

    private void buildPaths() {
        LinkedHashMap<String, Path> pathMap = new LinkedHashMap<String, Path>();
        for (RouteTable.Route route : Solon.global().router().main()) {
            if (!(route.target instanceof Action)) continue;
            Action action = (Action)route.target;
            Path path = new Path();
            switch (route.method) {
                case GET: {
                    path.get(this.buildPathPperation((RouteTable.Route<Handler>)route, true));
                    break;
                }
                case POST: {
                    path.post(this.buildPathPperation((RouteTable.Route<Handler>)route, false));
                    break;
                }
                case PUT: {
                    path.put(this.buildPathPperation((RouteTable.Route<Handler>)route, false));
                    break;
                }
                case DELETE: {
                    path.delete(this.buildPathPperation((RouteTable.Route<Handler>)route, false));
                    break;
                }
                case PATCH: {
                    path.patch(this.buildPathPperation((RouteTable.Route<Handler>)route, false));
                    break;
                }
                case HTTP: {
                    if (action.method().getParamWraps().length == 0) {
                        path.get(this.buildPathPperation((RouteTable.Route<Handler>)route, true));
                        break;
                    }
                    path.post(this.buildPathPperation((RouteTable.Route<Handler>)route, false));
                    break;
                }
                default: {
                    path.post(this.buildPathPperation((RouteTable.Route<Handler>)route, false));
                }
            }
            pathMap.put(route.path, path);
        }
        swagger.setPaths(pathMap);
    }

    private Operation buildPathPperation(RouteTable.Route<Handler> route, boolean isGet) {
        Action action = (Action)route.target;
        Operation operation = new Operation();
        operation.addTag(action.bean().clz().getName());
        if (Utils.isNotEmpty((String)action.produces())) {
            operation.addProduces(action.produces());
        } else {
            operation.addProduces("*/*");
        }
        if (Utils.isNotEmpty((String)action.consumes())) {
            operation.addConsumes(action.consumes());
        }
        for (ParamWrap p0 : action.method().getParamWraps()) {
            if (p0.getType() == Context.class) continue;
            ApiParam apiParam = p0.getParameter().getAnnotation(ApiParam.class);
            String n1 = "{" + p0.getName() + "}";
            Object p1 = null;
            p1 = route.path.indexOf(n1) > 0 ? new PathParameter() : (isGet ? new QueryParameter() : new FormParameter());
            p1.setRequired(p1.getRequired());
            p1.setName(p0.getName());
            p1.setType(p0.getType().getSimpleName());
            if (apiParam != null) {
                p1.setRequired(apiParam.required());
                p1.setName(apiParam.name());
                p1.setAccess(apiParam.access());
            }
            operation.addParameter((Parameter)p1);
        }
        return operation;
    }
}

