/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonhat.smartdoc;

import com.power.common.util.JsonFormatUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.common.util.ValidateUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.Methods;
import com.power.doc.constants.SpringMvcRequestAnnotationsEnum;
import com.power.doc.handler.SpringMVCRequestHeaderHandler;
import com.power.doc.helper.FormDataBuildHelper;
import com.power.doc.helper.JsonBuildHelper;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.model.FormData;
import com.power.doc.model.request.ApiRequestExample;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.ApiParamTreeUtil;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.noear.solonhat.smartdoc.ChangeBodyFormat;
import org.noear.solonhat.smartdoc.SolonRequestMappingHandler;

public class SolonDocBuildTemplate
implements IDocBuildTemplate<ApiDoc> {
    private List<ApiReqHeader> headers;
    private final AtomicInteger atomicInteger = new AtomicInteger(1);

    public List<ApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        this.headers = apiConfig.getRequestHeaders();
        ArrayList<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        int order = 0;
        Collection classes = projectBuilder.getJavaProjectBuilder().getClasses();
        boolean setCustomOrder = false;
        for (JavaClass cls : classes) {
            String ignoreTag = JavaClassUtil.getClassTagsValue((JavaClass)cls, (String)"ignore", (boolean)Boolean.FALSE);
            if (!this.checkController(cls) || StringUtil.isNotEmpty((String)ignoreTag) || StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch((String)apiConfig.getPackageFilters(), (String)cls.getCanonicalName())) continue;
            String strOrder = JavaClassUtil.getClassTagsValue((JavaClass)cls, (String)"order", (boolean)Boolean.TRUE);
            ++order;
            if (ValidateUtil.isNonnegativeInteger((String)strOrder)) {
                setCustomOrder = true;
                order = Integer.parseInt(strOrder);
            }
            List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls, apiConfig, projectBuilder);
            this.handleApiDoc(cls, apiDocList, apiMethodDocs, order, apiConfig.isMd5EncryptedHtmlName());
        }
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        } else if (setCustomOrder) {
            return apiDocList.stream().sorted(Comparator.comparing(ApiDoc::getOrder)).peek(p -> p.setOrder(this.atomicInteger.getAndAdd(1))).collect(Collectors.toList());
        }
        return apiDocList;
    }

    public ApiDoc getSingleApiData(ProjectDocConfigBuilder projectBuilder, String apiClassName) {
        return null;
    }

    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        if (JavaClassValidateUtil.isMvcIgnoreParams((String)typeName, ignoreParams)) {
            return "org.springframework.web.servlet.ModelAndView".equals(typeName);
        }
        return false;
    }

    private List<ApiMethodDoc> buildControllerMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder) {
        String clazName = cls.getCanonicalName();
        boolean paramsDataToTree = projectBuilder.getApiConfig().isParamsDataToTree();
        String classAuthor = JavaClassUtil.getClassTagsValue((JavaClass)cls, (String)"author", (boolean)Boolean.TRUE);
        List classAnnotations = cls.getAnnotations();
        Map constantsMap = projectBuilder.getConstantsMap();
        String baseUrl = "";
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getValue();
            if (!"Mapping".equals(annotationName) && !"org.noear.solon.annotation.Mapping".equals(annotationName) || annotation.getNamedParameter("value") == null) continue;
            baseUrl = StringUtil.removeQuotes((String)annotation.getNamedParameter("value").toString());
        }
        List methods = cls.getMethods();
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (JavaMethod method : methods) {
            if (method.isPrivate()) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            apiMethodDoc.setOrder(++methodOrder);
            apiMethodDoc.setName(method.getName());
            apiMethodDoc.setDesc(method.getComment());
            String methodUid = DocUtil.generateId((String)(clazName + method.getName()));
            apiMethodDoc.setMethodId(methodUid);
            String apiNoteValue = DocUtil.getNormalTagComments((JavaMethod)method, (String)"apiNote", (String)cls.getName());
            if (StringUtil.isEmpty((String)apiNoteValue)) {
                apiNoteValue = method.getComment();
            }
            Map authorMap = DocUtil.getParamsComments((JavaMethod)method, (String)"author", (String)cls.getName());
            String authorValue = String.join((CharSequence)", ", new ArrayList(authorMap.keySet()));
            if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(authorValue);
            }
            if (apiConfig.isShowAuthor() && StringUtil.isEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(classAuthor);
            }
            apiMethodDoc.setDetail(apiNoteValue);
            RequestMapping requestMapping = new SolonRequestMappingHandler().handle(projectBuilder.getServerUrl(), baseUrl, method, constantsMap);
            List apiReqHeaders = new SpringMVCRequestHeaderHandler().handle(method);
            apiMethodDoc.setRequestHeaders(apiReqHeaders);
            if (!Objects.nonNull(requestMapping) || null != method.getTagByName("ignore")) continue;
            apiMethodDoc.setType(requestMapping.getMethodType());
            apiMethodDoc.setUrl(requestMapping.getUrl());
            apiMethodDoc.setServerUrl(projectBuilder.getServerUrl());
            apiMethodDoc.setPath(requestMapping.getShortUrl());
            apiMethodDoc.setDeprecated(requestMapping.isDeprecated());
            List requestParams = this.requestParams(method, projectBuilder);
            if (paramsDataToTree) {
                requestParams = ApiParamTreeUtil.apiParamToTree(requestParams);
            }
            apiMethodDoc.setRequestParams(requestParams);
            List allApiReqHeaders = this.headers != null ? Stream.of(this.headers, apiReqHeaders).flatMap(Collection::stream).distinct().collect(Collectors.toList()) : apiReqHeaders;
            apiMethodDoc.setHeaders(this.createDocRenderHeaders(allApiReqHeaders, apiConfig.isAdoc()));
            apiMethodDoc.setRequestHeaders(allApiReqHeaders);
            ApiRequestExample requestExample = this.buildReqJson(method, apiMethodDoc, requestMapping.getMethodType(), projectBuilder);
            String requestJson = requestExample.getExampleBody();
            apiMethodDoc.setRequestExample(requestExample);
            apiMethodDoc.setRequestUsage(requestJson == null ? requestExample.getUrl() : requestJson);
            apiMethodDoc.setResponseUsage(JsonBuildHelper.buildReturnJson((JavaMethod)method, (ProjectDocConfigBuilder)projectBuilder));
            List responseParams = this.buildReturnApiParams(method, projectBuilder);
            if (paramsDataToTree) {
                responseParams = ApiParamTreeUtil.apiParamToTree((List)responseParams);
            }
            apiMethodDoc.setResponseParams(responseParams);
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    private ApiRequestExample buildReqJson(JavaMethod method, ApiMethodDoc apiMethodDoc, String methodType, ProjectDocConfigBuilder configBuilder) {
        String exampleBody;
        String url;
        List parameterList = method.getParameters();
        List reqHeaderList = apiMethodDoc.getRequestHeaders();
        StringBuilder header = new StringBuilder(reqHeaderList.size());
        for (ApiReqHeader reqHeader : reqHeaderList) {
            header.append(" -H ").append("'").append(reqHeader.getName()).append(":").append(reqHeader.getValue()).append("'");
        }
        if (parameterList.size() < 1) {
            String format = String.format("curl -X %s %s -i %s", methodType, header.toString(), apiMethodDoc.getUrl());
            return ApiRequestExample.builder().setUrl(apiMethodDoc.getUrl()).setExampleBody(format);
        }
        Map constantsMap = configBuilder.getConstantsMap();
        boolean requestFieldToUnderline = configBuilder.getApiConfig().isRequestFieldToUnderline();
        Map replacementMap = configBuilder.getReplaceClassMap();
        LinkedHashMap<String, String> pathParamsMap = new LinkedHashMap<String, String>();
        Map paramsComments = DocUtil.getParamsComments((JavaMethod)method, (String)"param", null);
        List springMvcRequestAnnotations = SpringMvcRequestAnnotationsEnum.listSpringMvcRequestAnnotations();
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        ApiRequestExample requestExample = ApiRequestExample.builder();
        block1: for (JavaParameter parameter : parameterList) {
            FormData formData;
            JavaType javaType = parameter.getType();
            String paramName = parameter.getName();
            String typeName = javaType.getFullyQualifiedName();
            String gicTypeName = javaType.getGenericCanonicalName();
            String commentClass = (String)paramsComments.get(paramName);
            if (Objects.nonNull(commentClass) && commentClass.contains("ignore")) continue;
            String rewriteClassName = this.getRewriteClassName(replacementMap, typeName, commentClass);
            if (DocUtil.isClassName((String)rewriteClassName)) {
                gicTypeName = rewriteClassName;
                typeName = DocClassUtil.getSimpleName((String)rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams((String)typeName, (List)configBuilder.getApiConfig().getIgnoreRequestParams())) continue;
            String simpleTypeName = javaType.getValue().toLowerCase();
            typeName = DocClassUtil.rewriteRequestParam((String)typeName);
            gicTypeName = DocClassUtil.rewriteRequestParam((String)gicTypeName);
            JavaClass javaClass = configBuilder.getJavaProjectBuilder().getClassByName(typeName);
            String[] globGicName = DocClassUtil.getSimpleGicName((String)gicTypeName);
            String comment = this.paramCommentResolve((String)paramsComments.get(paramName));
            String mockValue = "";
            if ("POST".equals(methodType) || "PUT".equals(methodType)) {
                apiMethodDoc.setContentType("application/json; charset=utf-8");
            }
            if (JavaClassValidateUtil.isPrimitive((String)typeName)) {
                mockValue = (String)paramsComments.get(paramName);
                mockValue = Objects.nonNull(mockValue) && mockValue.contains("|") ? mockValue.substring(mockValue.lastIndexOf("|") + 1) : "";
                if (StringUtil.isEmpty((String)mockValue)) {
                    mockValue = DocUtil.getValByTypeAndFieldName((String)simpleTypeName, (String)paramName, (boolean)Boolean.TRUE);
                }
                if ("POST".equals(methodType) || "PUT".equals(methodType)) {
                    StringBuilder builder;
                    apiMethodDoc.setContentType("application/json; charset=utf-8");
                    if (requestExample.getJsonBody() == null) {
                        builder = new StringBuilder();
                        builder.append("{");
                    } else {
                        builder = new StringBuilder(requestExample.getJsonBody());
                        builder.delete(builder.length() - 1, builder.length());
                        builder.append(",");
                    }
                    builder.append("\"").append(paramName).append("\":").append(DocUtil.handleJsonStr((String)mockValue)).append("}");
                    requestExample.setJsonBody(JsonFormatUtil.formatJson((String)builder.toString())).setJson(true);
                }
            }
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            List annotations = parameter.getAnnotations();
            boolean paramAdded = false;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                String fullName = annotation.getType().getSimpleName();
                if (!springMvcRequestAnnotations.contains(fullName) || paramAdded) continue;
                if ("RequestHeader".equals(annotationName)) continue block1;
                AnnotationValue annotationDefaultVal = annotation.getProperty("defaultValue");
                if (null != annotationDefaultVal) {
                    mockValue = StringUtil.removeQuotes((String)annotationDefaultVal.toString());
                }
                paramName = this.getParamName(paramName, annotation);
                for (Map.Entry entry : constantsMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (paramName.contains(key)) {
                        paramName = paramName.replace(key, value);
                    }
                    if (!mockValue.contains((CharSequence)entry.getKey())) continue;
                    mockValue = mockValue.replace(key, value);
                }
                if ("Post".equals(annotationName) || "Post".equals(annotationName)) {
                    apiMethodDoc.setContentType("application/json; charset=utf-8");
                    if (JavaClassValidateUtil.isPrimitive((String)simpleTypeName)) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("{\"").append(paramName).append("\":").append(DocUtil.handleJsonStr((String)mockValue)).append("}");
                        requestExample.setJsonBody(JsonFormatUtil.formatJson((String)builder.toString())).setJson(true);
                    } else {
                        String json = JsonBuildHelper.buildJson((String)typeName, (String)gicTypeName, (boolean)Boolean.FALSE, (int)0, new HashMap(), (ProjectDocConfigBuilder)configBuilder);
                        requestExample.setJsonBody(JsonFormatUtil.formatJson((String)json)).setJson(true);
                    }
                    paramAdded = true;
                    continue;
                }
                if (!"Get".contains(annotationName)) continue;
                if (javaClass.isEnum()) {
                    Object value = JavaClassUtil.getEnumValue((JavaClass)javaClass, (boolean)Boolean.TRUE);
                    mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                }
                pathParamsMap.put(paramName, mockValue);
                paramAdded = true;
            }
            if (paramAdded) continue;
            if (gicTypeName.contains("org.springframework.web.multipart.MultipartFile")) {
                apiMethodDoc.setContentType("multipart/form-data");
                formData = new FormData();
                formData.setKey(paramName);
                formData.setType("file");
                formData.setDesc(comment);
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive((String)typeName)) {
                formData = new FormData();
                formData.setKey(paramName);
                formData.setDesc(comment);
                formData.setType("text");
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isArray((String)typeName) || JavaClassValidateUtil.isCollection((String)typeName)) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray((String)gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (!JavaClassValidateUtil.isPrimitive((String)gicName)) {
                    throw new RuntimeException("Spring MVC can't support binding Collection on method " + method.getName() + "Check it in " + method.getDeclaringClass().getCanonicalName());
                }
                FormData formData2 = new FormData();
                formData2.setKey(paramName);
                if (!paramName.contains("[]")) {
                    formData2.setKey(paramName + "[]");
                }
                formData2.setDesc(comment);
                formData2.setType("text");
                formData2.setValue(RandomUtil.randomValueByType((String)gicName));
                formDataList.add(formData2);
                continue;
            }
            if (javaClass.isEnum()) {
                Object value = JavaClassUtil.getEnumValue((JavaClass)javaClass, (boolean)Boolean.TRUE);
                String strVal = StringUtil.removeQuotes((String)String.valueOf(value));
                FormData formData3 = new FormData();
                formData3.setKey(paramName);
                formData3.setType("text");
                formData3.setDesc(comment);
                formData3.setValue(strVal);
                formDataList.add(formData3);
                continue;
            }
            formDataList.addAll(FormDataBuildHelper.getFormData((String)gicTypeName, new HashMap(), (int)0, (ProjectDocConfigBuilder)configBuilder, (String)""));
        }
        requestExample.setFormDataList(formDataList);
        String[] paths = apiMethodDoc.getPath().split(";");
        String path = paths[0];
        if (Methods.POST.getValue().equals(methodType) || Methods.PUT.getValue().equals(methodType)) {
            path = DocUtil.formatAndRemove((String)path, pathParamsMap);
            String body = UrlUtil.urlJoin((String)"", (Map)DocUtil.formDataToMap(formDataList)).replace("?", "");
            body = StringUtil.removeQuotes((String)body);
            url = apiMethodDoc.getServerUrl() + "/" + path;
            url = UrlUtil.simplifyUrl((String)url);
            String format = String.format("curl -X %s %s -i %s", methodType, header.toString(), url);
            format = format.replace("-X ANY", "");
            exampleBody = requestExample.isJson() ? (StringUtil.isNotEmpty((String)requestExample.getJsonBody()) ? String.format("curl -X %s -H 'Content-Type: application/json; charset=utf-8' %s -i %s --data '%s'", methodType, header.toString(), url, requestExample.getJsonBody()) : format) : (StringUtil.isNotEmpty((String)body) ? String.format("curl -X %s -H 'Content-Type: application/json; charset=utf-8' %s -i %s --data '%s'", methodType, header.toString(), url, ChangeBodyFormat.urlParamToJson(body)) : format);
            requestExample.setExampleBody(exampleBody).setUrl(url);
        } else {
            pathParamsMap.putAll(DocUtil.formDataToMap(formDataList));
            path = DocUtil.formatAndRemove((String)path, pathParamsMap);
            url = UrlUtil.urlJoin((String)path, pathParamsMap);
            url = StringUtil.removeQuotes((String)url);
            url = apiMethodDoc.getServerUrl() + "/" + url;
            url = UrlUtil.simplifyUrl((String)url);
            exampleBody = String.format("curl -X %s %s -i %s", methodType, header.toString(), url);
            exampleBody = exampleBody.replace("-X ANY", "");
            requestExample.setExampleBody(exampleBody).setJsonBody("").setUrl(url);
        }
        return requestExample;
    }

    private List<ApiParam> requestParams(JavaMethod javaMethod, ProjectDocConfigBuilder builder) {
        boolean isStrict = builder.getApiConfig().isStrict();
        HashMap responseFieldMap = new HashMap();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map replacementMap = builder.getReplaceClassMap();
        Map paramTagMap = DocUtil.getParamsComments((JavaMethod)javaMethod, (String)"param", (String)className);
        List parameterList = javaMethod.getParameters();
        if (parameterList.size() < 1) {
            return null;
        }
        Map constantsMap = builder.getConstantsMap();
        boolean requestFieldToUnderline = builder.getApiConfig().isRequestFieldToUnderline();
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        int requestBodyCounter = 0;
        block0: for (JavaParameter parameter : parameterList) {
            String[] gicNameArr;
            String commentClass;
            String paramName = parameter.getName();
            String typeName = parameter.getType().getGenericCanonicalName();
            String simpleName = parameter.getType().getValue().toLowerCase();
            String fullTypeName = parameter.getType().getFullyQualifiedName();
            String rewriteClassName = this.getRewriteClassName(replacementMap, fullTypeName, commentClass = (String)paramTagMap.get(paramName));
            if (DocUtil.isClassName((String)rewriteClassName)) {
                typeName = rewriteClassName;
                fullTypeName = DocClassUtil.getSimpleName((String)rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams((String)typeName, (List)builder.getApiConfig().getIgnoreRequestParams())) continue;
            fullTypeName = DocClassUtil.rewriteRequestParam((String)fullTypeName);
            typeName = DocClassUtil.rewriteRequestParam((String)typeName);
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive((String)fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            String comment = this.paramCommentResolve((String)paramTagMap.get(paramName));
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            if (typeName.contains("org.springframework.web.multipart.MultipartFile")) {
                ApiParam param = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setDesc(comment).setRequired(true).setVersion("-");
                paramList.add(param);
                continue;
            }
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            List annotations = parameter.getAnnotations();
            List groupClasses = JavaClassUtil.getParamGroupJavaClass((List)annotations);
            String strRequired = "true";
            boolean isPathVariable = false;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                if ("RequestHeader".equals(annotationName)) continue block0;
                if ("RequestParam".equals(annotationName) || "PathVariable".equals(annotationName)) {
                    if ("PathVariable".equals(annotationName)) {
                        isPathVariable = true;
                    }
                    paramName = this.getParamName(paramName, annotation);
                    for (Map.Entry entry : constantsMap.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (!paramName.contains(key)) continue;
                        paramName = paramName.replace(key, value);
                    }
                    AnnotationValue annotationRequired = annotation.getProperty("required");
                    if (null != annotationRequired) {
                        strRequired = annotationRequired.toString();
                    }
                }
                if (!"RequestBody".equals(annotationName)) continue;
                if (requestBodyCounter > 0) {
                    throw new RuntimeException("You have use @RequestBody Passing multiple variables  for method " + javaMethod.getName() + " in " + className + ",@RequestBody annotation could only bind one variables.");
                }
                ++requestBodyCounter;
            }
            boolean required = Boolean.parseBoolean(strRequired);
            if (isPathVariable) {
                comment = comment + " (This is path param)";
            }
            if (JavaClassValidateUtil.isCollection((String)fullTypeName) || JavaClassValidateUtil.isArray((String)fullTypeName)) {
                gicNameArr = DocClassUtil.getSimpleGicName((String)typeName);
                String gicName = gicNameArr[0];
                if (JavaClassValidateUtil.isArray((String)gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (JavaClassValidateUtil.isPrimitive((String)gicName)) {
                    String shortSimple = DocClassUtil.processTypeNameForParams((String)gicName);
                    ApiParam param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of " + shortSimple + "]").setRequired(required).setPathParams(isPathVariable).setId(paramList.size() + 1).setType("array");
                    paramList.add(param);
                    continue;
                }
                if (requestBodyCounter > 0) {
                    paramList.addAll(ParamsBuildHelper.buildParams((String)gicNameArr[0], (String)"", (int)0, (String)"true", responseFieldMap, (boolean)Boolean.FALSE, new HashMap(), (ProjectDocConfigBuilder)builder, (List)groupClasses, (int)0));
                    continue;
                }
                throw new RuntimeException("Spring MVC can't support binding Collection on method " + javaMethod.getName() + "Check it in " + javaMethod.getDeclaringClass().getCanonicalName());
            }
            if (JavaClassValidateUtil.isPrimitive((String)fullTypeName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams((String)simpleName)).setId(paramList.size() + 1).setPathParams(isPathVariable).setDesc(comment).setRequired(required).setVersion("-");
                paramList.add(param);
                continue;
            }
            if (JavaClassValidateUtil.isMap((String)fullTypeName)) {
                if ("java.util.Map".equals(typeName)) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParams(isPathVariable).setDesc(comment).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName((String)typeName);
                paramList.addAll(ParamsBuildHelper.buildParams((String)gicNameArr[1], (String)"", (int)0, (String)"true", responseFieldMap, (boolean)Boolean.FALSE, new HashMap(), (ProjectDocConfigBuilder)builder, (List)groupClasses, (int)0));
                continue;
            }
            if (javaClass.isEnum()) {
                String o = JavaClassUtil.getEnumParams((JavaClass)javaClass);
                ApiParam param = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setPathParams(isPathVariable).setType("enum").setDesc(StringUtil.removeQuotes((String)o)).setRequired(required).setVersion("-");
                paramList.add(param);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams((String)typeName, (String)"", (int)0, (String)"true", responseFieldMap, (boolean)Boolean.FALSE, new HashMap(), (ProjectDocConfigBuilder)builder, (List)groupClasses, (int)0));
        }
        return paramList;
    }

    private String getParamName(String paramName, JavaAnnotation annotation) {
        AnnotationValue annotationOfName;
        AnnotationValue annotationValue = annotation.getProperty("value");
        if (null != annotationValue) {
            paramName = StringUtil.removeQuotes((String)annotationValue.toString());
        }
        if (null != (annotationOfName = annotation.getProperty("name"))) {
            paramName = StringUtil.removeQuotes((String)annotationOfName.toString());
        }
        return paramName;
    }

    private boolean checkController(JavaClass cls) {
        List classAnnotations = cls.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String name = annotation.getType().getValue();
            if (!"Controller".equals(name) && !"RestController".equals(name)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"restApi".equals(value)) continue;
            return true;
        }
        return false;
    }

    private String getRewriteClassName(Map<String, String> replacementMap, String fullTypeName, String commentClass) {
        String rewriteClassName;
        if (Objects.nonNull(commentClass) && !"No comments found.".equals(commentClass)) {
            String[] comments = commentClass.split("\\|");
            rewriteClassName = comments[comments.length - 1];
        } else {
            rewriteClassName = replacementMap.get(fullTypeName);
        }
        return rewriteClassName;
    }
}

