/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonhat.smartdoc;

import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.constants.Methods;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.utils.DocUrlUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SolonRequestMappingHandler {
    public RequestMapping handle(String serverUrl, String controllerBaseUrl, JavaMethod method, Map<String, String> constantsMap) {
        List annotations = method.getAnnotations();
        String methodType = "ANY";
        String shortUrl = null;
        String mediaType = null;
        boolean deprecated = false;
        for (JavaAnnotation annotation : annotations) {
            String annotationName = annotation.getType().getName();
            Object produces = annotation.getNamedParameter("produces");
            if (produces != null) {
                mediaType = produces.toString();
            }
            if ("Deprecated".equals(annotationName)) {
                deprecated = true;
            }
            if ("Mapping".equals(annotationName) || "org.noear.solon.annotation.Mapping".equals(annotationName)) {
                shortUrl = DocUtil.handleMappingValue((JavaAnnotation)annotation);
            }
            if ("Get".equals(annotationName) || "org.noear.solon.annotation.Get".equals(annotationName)) {
                methodType = Methods.GET.getValue();
                continue;
            }
            if ("Post".equals(annotationName) || "org.noear.solon.annotation.Post".equals(annotationName)) {
                methodType = Methods.POST.getValue();
                mediaType = "application/json;charset=UTF-8";
                continue;
            }
            if ("Put".equals(annotationName) || "org.noear.solon.annotation.Put".equals(annotationName)) {
                mediaType = "application/json;charset=UTF-8";
                methodType = Methods.PUT.getValue();
                continue;
            }
            if ("Patch".equals(annotationName) || "org.noear.solon.annotation.Patch".equals(annotationName)) {
                methodType = Methods.PATCH.getValue();
                continue;
            }
            if (!"Delete".equals(annotationName) && !"org.noear.solon.annotation.Delete".equals(annotationName)) continue;
            methodType = Methods.DELETE.getValue();
        }
        if (shortUrl != null) {
            String url;
            if (null != method.getTagByName("ignore")) {
                return null;
            }
            String[] urls = (shortUrl = StringUtil.removeQuotes(shortUrl)).split(",");
            if (urls.length > 1) {
                url = DocUrlUtil.getMvcUrls((String)serverUrl, (String)controllerBaseUrl, Arrays.asList(urls));
                shortUrl = DocUrlUtil.getMvcUrls((String)"", (String)controllerBaseUrl, Arrays.asList(urls));
            } else {
                url = UrlUtil.simplifyUrl((String)(serverUrl + "/" + controllerBaseUrl + "/" + shortUrl));
                shortUrl = UrlUtil.simplifyUrl((String)("/" + controllerBaseUrl + "/" + shortUrl));
            }
            for (Map.Entry<String, String> entry : constantsMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (url.contains(key)) {
                    url = url.replace(key, value);
                    url = url.replace("+", "");
                }
                if (!shortUrl.contains(key)) continue;
                shortUrl = shortUrl.replace(key, value);
                shortUrl = shortUrl.replace("+", "");
            }
            return RequestMapping.builder().setMediaType(mediaType).setMethodType(methodType).setUrl(StringUtil.trim((String)url)).setShortUrl(StringUtil.trim((String)shortUrl)).setDeprecated(deprecated);
        }
        return null;
    }
}

