/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.actuator.m.freemarker;

import freemarker.cache.MruCacheStorage;
import freemarker.cache.StringTemplateLoaderEx;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.noear.solon.XApp;
import org.noear.solon.core.XContext;
import org.noear.solonjt.actuator.IJtActuator;
import org.noear.solonjt.model.AFileModel;
import org.noear.solonjt.utils.TextUtils;

public class FreemarkerJtActuator
implements IJtActuator {
    private static final String _lock = "";
    private static FreemarkerJtActuator _g;
    Configuration _engine = new Configuration(Configuration.VERSION_2_3_28);
    StringTemplateLoaderEx _loader = new StringTemplateLoaderEx();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FreemarkerJtActuator singleton() {
        if (_g != null) return _g;
        String string = _lock;
        synchronized (_lock) {
            if (_g != null) return _g;
            _g = new FreemarkerJtActuator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _g;
        }
    }

    private FreemarkerJtActuator() {
        this._engine.setLocale(Locale.CHINESE);
        this._engine.setNumberFormat("#");
        this._engine.setDefaultEncoding("utf-8");
        this._engine.setTemplateLoader(this._loader);
        this._engine.setCacheStorage(new MruCacheStorage(20, 250));
        try {
            this._engine.setSharedVaribles(XApp.global().shared());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        XApp.global().onSharedAdd((k, v) -> this.sharedSet((String)k, v));
    }

    public void sharedSet(String name, Object obj) {
        try {
            this._engine.setSharedVariable(name, obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean put(String name, AFileModel file) {
        if (TextUtils.isEmpty((String)file.content)) {
            return false;
        }
        this._loader.putTemplate(name, file.content);
        return true;
    }

    public Template get(String name) throws Exception {
        return this._engine.getTemplate(name, "utf-8");
    }

    public String language() {
        return "freemarker";
    }

    public boolean isLoaded(String name) {
        return this._loader.contains(name);
    }

    public boolean preLoad(String name, AFileModel file) throws Exception {
        if (this.isLoaded(name)) {
            return true;
        }
        return this.put(name, file);
    }

    public void del(String name) {
        this._loader.removeTemplate(name);
    }

    public void delAll() {
        this._loader.removeTemplateAll();
    }

    public Object exec(String name, AFileModel file, XContext ctx, Map<String, Object> model, boolean outString) throws Exception {
        if (this.preLoad(name, file)) {
            if (model == null) {
                model = new HashMap<String, Object>();
            }
            if (ctx == null) {
                model.put("ctx", XContext.current());
            } else {
                model.put("ctx", ctx);
            }
            Template tmpl = this._engine.getTemplate(name, "utf-8");
            StringWriter writer = new StringWriter();
            tmpl.process(model, writer);
            return writer.toString().trim();
        }
        return _lock;
    }
}

