/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.task;

import java.util.concurrent.ThreadPoolExecutor;
import org.noear.snack.ONode;
import org.noear.solon.XUtil;
import org.noear.solonjt.dso.CfgUtil;
import org.noear.solonjt.dso.JtBridge;
import org.noear.solonjt.task.IJtTask;
import org.noear.solonjt.utils.TextUtils;

public abstract class JtTaskBase
implements IJtTask {
    protected String _name;
    protected int _interval;
    protected int _interval_bak;
    private String _node_id;
    protected ThreadPoolExecutor _pool;

    protected JtTaskBase(String name, int interval) {
        this._name = name;
        this._interval = interval;
        this._interval_bak = interval;
        this.poolInit();
    }

    protected String node_id() {
        if (this._node_id == null) {
            this._node_id = JtBridge.nodeId();
        }
        return this._node_id;
    }

    private void poolInit() {
    }

    public void poolExecute(Runnable runnable) {
        new Thread(runnable).start();
    }

    protected ONode node_cfg() {
        ONode _node_cfg = null;
        if (!TextUtils.isEmpty((String)this.node_id())) {
            try {
                String cfg_str = CfgUtil.cfgGetValue((String)this.node_id());
                if (!XUtil.isEmpty((String)cfg_str) && (cfg_str = cfg_str.trim()).startsWith("{")) {
                    _node_cfg = ONode.load((Object)cfg_str);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return _node_cfg;
    }

    protected boolean node_current_can_run() {
        ONode cfg = this.node_cfg();
        if (cfg == null) {
            this._interval = 60000;
            System.out.println(this.getName() + "::is not enabled");
            return false;
        }
        if (cfg.contains("task") && cfg.get("task").getString().indexOf(this.getName()) < 0) {
            this._interval = 60000;
            System.out.println(this.getName() + "::is not enabled");
            return false;
        }
        if (cfg.contains("event") && cfg.get("event").getString().indexOf(this.getName()) < 0) {
            this._interval = 60000;
            System.out.println(this.getName() + "::is not enabled");
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getInterval() {
        return this._interval;
    }
}

