/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.event.message.dso;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.noear.solonjt.dso.LogUtil;
import org.noear.solonjt.event.message.Config;
import org.noear.solonjt.event.message.dso.AMessageDistributionModel;
import org.noear.solonjt.event.message.dso.AMessageModel;
import org.noear.solonjt.event.message.dso.DisttimeUtil;
import org.noear.solonjt.model.AFileModel;
import org.noear.solonjt.utils.Datetime;
import org.noear.solonjt.utils.ExceptionUtils;
import org.noear.weed.DataItem;
import org.noear.weed.DataList;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;
import org.noear.weed.IQuery;
import org.noear.weed.cache.ICacheService;

public class DbMsgApi {
    private static DbContext db() {
        return Config.db;
    }

    public static AFileModel fileGet(String path) throws Exception {
        return (AFileModel)((DbTableQuery)DbMsgApi.db().table("a_file").where("`path`=?", new Object[]{path})).select("*").getItem(AFileModel.class);
    }

    public static List<AFileModel> msgGetSubs(String topic) throws Exception {
        return ((DbTableQuery)DbMsgApi.db().table("a_file").where("label=? AND is_disabled=0", new Object[]{topic})).select("file_id,tag,label,path,is_disabled").getList(AFileModel.class);
    }

    public static AMessageModel msgGet(long msg_id) throws Exception {
        AMessageModel m = (AMessageModel)((DbTableQuery)DbMsgApi.db().table("a_message").where("msg_id=? AND state=0", new Object[]{msg_id})).select("*").getItem(AMessageModel.class);
        if (m.state != 0) {
            return null;
        }
        return m;
    }

    public static List<Long> msgGetList(int rows, int ntime) throws SQLException {
        return ((DbTableQuery)((DbTableQuery)((DbTableQuery)DbMsgApi.db().table("a_message").where("state=0 AND dist_ntime<?", new Object[]{ntime})).orderBy("msg_id ASC")).limit(rows)).select("msg_id").getArray("msg_id");
    }

    public static boolean msgSetState(long msg_id, int state) {
        return DbMsgApi.msgSetState(msg_id, state, 0);
    }

    public static boolean msgSetState(long msg_id, int state, int nexttime) {
        try {
            ((DbTableQuery)((DbTableQuery)DbMsgApi.db().table("a_message").set("state", (Object)state).expre(tb -> {
                if (state == 0) {
                    int ntime = DisttimeUtil.nextTime(1);
                    tb.set("dist_ntime", (Object)ntime);
                }
                if (nexttime > 0) {
                    tb.set("dist_ntime", (Object)nexttime);
                }
            })).where("msg_id=? AND (state=0 OR state=1)", new Object[]{msg_id})).update();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogUtil.log((String)"msg", (String)"setMessageState", (String)(msg_id + ""), (int)0, (String)"", (String)ExceptionUtils.getString((Throwable)ex));
            return false;
        }
    }

    public static boolean msgSetRepet(AMessageModel msg, int state) {
        try {
            ++msg.dist_count;
            int ntime = DisttimeUtil.nextTime(msg.dist_count);
            ((DbTableQuery)((DbTableQuery)DbMsgApi.db().table("a_message").usingExpr(true)).set("state", (Object)state).set("dist_ntime", (Object)ntime).set("dist_count", (Object)"$dist_count+1").where("msg_id=? AND (state=0 OR state=1)", new Object[]{msg.msg_id})).update();
            return true;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            LogUtil.log((String)"msg", (String)"setMessageRepet", (String)(msg.msg_id + ""), (int)0, (String)"", (String)ExceptionUtils.getString((Throwable)ex));
            return false;
        }
    }

    public static void msgAddDistribution(long msg_id, AFileModel subs) throws SQLException {
        boolean isExists = ((DbTableQuery)((DbTableQuery)DbMsgApi.db().table("a_message_distribution").where("msg_id=?", new Object[]{msg_id})).and("file_id=?", new Object[]{subs.file_id})).exists();
        if (!isExists) {
            ((DbTableQuery)DbMsgApi.db().table("a_message_distribution").usingExpr(true)).set("msg_id", (Object)msg_id).set("file_id", (Object)subs.file_id).set("receive_url", (Object)subs.path).set("receive_way", (Object)0).set("log_date", (Object)"$DATE(NOW())").set("log_fulltime", (Object)"$NOW()").insert();
        }
    }

    public static List<AMessageDistributionModel> msgGetDistributionList(long msg_id) throws Exception {
        return ((DbTableQuery)DbMsgApi.db().table("a_message_distribution").where("msg_id=? AND (state=0 OR state=1)", new Object[]{msg_id})).select("*").getList(AMessageDistributionModel.class);
    }

    public static boolean msgSetDistributionState(long msg_id, AMessageDistributionModel dist, int state) {
        try {
            ((DbTableQuery)DbMsgApi.db().table("a_message_distribution").set("state", (Object)state).set("duration", (Object)dist._duration).where("msg_id=? and file_id=? and state<>2", new Object[]{msg_id, dist.file_id})).update();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogUtil.log((String)"msg", (String)"setDistributionState", (String)(msg_id + ""), (int)0, (String)"", (String)ExceptionUtils.getString((Throwable)ex));
            return false;
        }
    }

    public static Object msgPublish(Map<String, Object> data) throws Exception {
        return DbMsgApi.msgAppend(data.get("topic"), data.get("content"), null, data.get("delay"));
    }

    public static Object msgRorward(Map<String, Object> data) throws Exception {
        if (!data.containsKey("topic_source")) {
            return 0;
        }
        String topic = data.get("topic").toString();
        String content = data.get("content").toString();
        String topic_source = data.get("topic_source").toString();
        DataList list = ((IQuery)((IQuery)((DbTableQuery)((DbTableQuery)DbMsgApi.db().table("a_file").where("label LIKE ? AND is_disabled=0", new Object[]{topic_source + "-%"})).orderBy("rank ASC")).select("label").caching((ICacheService)Config.cache)).cacheTag("msg_topic_" + topic_source)).getDataList();
        if (list.getRowCount() == 0) {
            return 0;
        }
        if (topic.equals(topic_source)) {
            DataItem item = list.getRow(0);
            String ntopic = item.getString("label");
            DbMsgApi.msgAppend(ntopic, content, topic_source, data.get("delay"));
        } else {
            boolean is_do = false;
            for (DataItem item : list) {
                String ntopic = item.getString("label");
                if (is_do) {
                    if (topic.equals(ntopic)) continue;
                    DbMsgApi.msgAppend(ntopic, content, topic_source, data.get("delay"));
                    break;
                }
                if (!topic.equals(ntopic)) continue;
                is_do = true;
            }
        }
        return 0;
    }

    private static Object msgAppend(Object topic, Object content, String topic_source, Object delay) throws Exception {
        int delay2;
        DbTableQuery qr = DbMsgApi.db().table("a_message").set("topic", topic).set("content", content).set("log_date", (Object)Datetime.Now().getDate()).set("log_fulltime", (Object)"$NOW()");
        if (topic_source != null) {
            qr.set("topic_source", (Object)topic_source);
        }
        if (delay != null && (delay2 = Integer.parseInt(delay.toString())) > 0) {
            int ntime2 = DisttimeUtil.nextTime(delay2);
            qr.set("dist_ntime", (Object)ntime2);
        }
        return qr.insert();
    }
}

