/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.event.schedule.controller;

import java.util.Date;
import java.util.List;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XContextEmpty;
import org.noear.solon.core.XContextUtil;
import org.noear.solonjt.dso.JtLock;
import org.noear.solonjt.dso.LogUtil;
import org.noear.solonjt.event.schedule.dso.DbApi;
import org.noear.solonjt.executor.ExecutorFactory;
import org.noear.solonjt.model.AFileModel;
import org.noear.solonjt.task.JtTaskBase;
import org.noear.solonjt.utils.Datetime;
import org.noear.solonjt.utils.ExceptionUtils;
import org.noear.solonjt.utils.Timecount;
import org.noear.solonjt.utils.Timespan;

public class ScheduleTask
extends JtTaskBase {
    private boolean _init = false;

    public ScheduleTask() {
        super("_schedule", 60000);
    }

    public void exec() throws Exception {
        if (!this.node_current_can_run()) {
            return;
        }
        this._interval = this._interval_bak;
        if (!this._init) {
            this._init = true;
            DbApi.taskResetState();
        }
        List<AFileModel> list = DbApi.taskGetList();
        for (AFileModel task : list) {
            if (!JtLock.g.tryLock("solonjt.event", this.getName() + "_" + task.file_id)) continue;
            this.poolExecute(() -> this.doExec(task));
        }
    }

    private void doExec(AFileModel task) {
        try {
            this.runTask(task);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            try {
                String err = ExceptionUtils.getString((Throwable)ex);
                LogUtil.log((String)this.getName(), (String)task.tag, (String)task.path, (String)(task.file_id + ""), (int)0, (String)"", (String)err);
            }
            catch (Throwable ee) {
                ee.printStackTrace();
            }
            try {
                DbApi.taskSetState(task, 8);
            }
            catch (Throwable ee) {
                ee.printStackTrace();
            }
        }
    }

    private void runTask(AFileModel task) throws Exception {
        String s2;
        if (task == null || task.file_id == 0) {
            return;
        }
        if (task.plan_max > 0 && task.plan_count >= task.plan_max) {
            return;
        }
        if (task.plan_interval == null || task.plan_interval.length() < 2) {
            return;
        }
        if (task.plan_state == 2) {
            return;
        }
        Date temp = task.plan_last_time;
        if (temp == null) {
            temp = task.plan_begin_time;
        }
        if (temp == null) {
            return;
        }
        Datetime last_time = new Datetime(temp);
        String s1 = task.plan_interval.substring(0, task.plan_interval.length() - 1);
        switch (s2 = task.plan_interval.substring(task.plan_interval.length() - 1)) {
            case "m": {
                last_time.addMinute(Integer.parseInt(s1));
                break;
            }
            case "h": {
                last_time.addHour(Integer.parseInt(s1));
                break;
            }
            case "d": {
                task._is_day_task = true;
                last_time.addDay(Integer.parseInt(s1));
                break;
            }
            case "M": {
                task._is_day_task = true;
                last_time.addMonth(Integer.parseInt(s1));
                break;
            }
            default: {
                last_time.addDay(1);
            }
        }
        if (new Timespan(last_time.getFulltime()).seconds() < 0L) {
            return;
        }
        this.do_runTask(task);
    }

    private void do_runTask(AFileModel task) throws Exception {
        Timecount timecount = new Timecount().start();
        task.plan_last_time = new Date();
        DbApi.taskSetState(task, 2);
        XContext ctx = XContextEmpty.create();
        XContextUtil.currentSet((XContext)ctx);
        ExecutorFactory.execOnly((AFileModel)task, (XContext)ctx);
        XContextUtil.currentRemove();
        ++task.plan_count;
        task.plan_last_timespan = timecount.stop().milliseconds();
        DbApi.taskSetState(task, 9);
        LogUtil.log((String)this.getName(), (String)task.tag, (String)task.path, (String)(task.file_id + ""), (int)0, (String)"", (String)"\u6267\u884c\u6210\u529f");
    }
}

