/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.beetl.core.BlockEnvContext;
import org.beetl.core.VarDescrption;
import org.beetl.core.statement.ASTNode;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IVarIndex;

public class ProgramBuilderContext {
    BlockEnvContext root;
    BlockEnvContext current;
    boolean isSafeOutput;
    List<Object> listNodeEval;
    Map<String, VarDescrption> globalVar;
    int varIndexSize;
    public Map<String, Integer> globalIndexMap;
    public Map<String, Integer> rootIndexMap;

    public ProgramBuilderContext() {
        this.current = this.root = new BlockEnvContext();
        this.isSafeOutput = false;
        this.listNodeEval = new LinkedList<Object>();
        this.globalVar = new HashMap<String, VarDescrption>();
        this.varIndexSize = 0;
        this.globalIndexMap = new HashMap<String, Integer>();
        this.rootIndexMap = new HashMap<String, Integer>();
    }

    public void enterBlock() {
        BlockEnvContext blockVar = new BlockEnvContext();
        blockVar.setParent(this.current);
        this.current = blockVar;
    }

    public void exitBlock() {
        this.current = this.current.parent;
    }

    public void addVarAndPostion(ASTNode first) {
        this.addVar(first.token.text);
        this.setVarPosition(first.token.text, first);
    }

    public void addVar(String varName) {
        VarDescrption varDesc = new VarDescrption();
        varDesc.setVarName(varName);
        this.current.getVars().put(varName, varDesc);
    }

    public void setVarAttr(String varName, String attrName) {
        VarDescrption varDesc = this.findVar(varName);
        varDesc.attrList.add(attrName);
    }

    public void setVarPosition(String varName, ASTNode where) {
        VarDescrption varDesc = this.findVar(varName);
        varDesc.where.add(where);
    }

    protected GrammarToken hasDefined(String varName) {
        BlockEnvContext scope = this.current;
        while (scope != null) {
            VarDescrption varDesc = scope.getVarDescrption(varName);
            if (varDesc != null) {
                return varDesc.where.get((int)0).token;
            }
            scope = scope.parent;
        }
        return null;
    }

    protected VarDescrption findVar(String varName) {
        BlockEnvContext scope = this.current;
        while (scope != null) {
            VarDescrption varDesc = scope.getVarDescrption(varName);
            if (varDesc != null) {
                return varDesc;
            }
            scope = scope.parent;
        }
        VarDescrption desc = this.globalVar.get(varName);
        if (desc == null) {
            desc = new VarDescrption();
            this.globalVar.put(varName, desc);
        }
        return desc;
    }

    public int setNodeEvalObject(Object o) {
        this.listNodeEval.add(o);
        return this.listNodeEval.size() - 1;
    }

    public void anzlyszeGlobal() {
        int index = 0;
        for (Map.Entry<String, VarDescrption> entry : this.globalVar.entrySet()) {
            this.globalIndexMap.put(entry.getKey(), index);
            VarDescrption vd = entry.getValue();
            String[] attrs = vd.attrList.toArray(new String[0]);
            for (ASTNode node : vd.where) {
                ((IVarIndex)((Object)node)).setVarIndex(index);
            }
            ++index;
        }
    }

    public void anzlyszeLocal() {
        this.anzlysze(this.root, this.globalVar.size(), true);
    }

    private void anzlysze(BlockEnvContext block, int nextIndex, boolean isRoot) {
        for (Map.Entry<String, VarDescrption> entry : block.vars.entrySet()) {
            VarDescrption vd = entry.getValue();
            for (ASTNode node : vd.where) {
                ((IVarIndex)((Object)node)).setVarIndex(nextIndex);
                if (!isRoot) continue;
                this.rootIndexMap.put(vd.getVarName(), nextIndex);
            }
            ++nextIndex;
        }
        this.varIndexSize = Math.max(this.varIndexSize, nextIndex);
        for (BlockEnvContext subBlock : block.blockList) {
            this.anzlysze(subBlock, nextIndex, false);
            int inc = subBlock.vars.size();
            this.varIndexSize = Math.max(this.varIndexSize, nextIndex + inc);
        }
    }
}

