/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om.asm;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.asm.ClassDescription;
import org.beetl.core.om.asm.FieldDescription;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

final class BeanEnhanceUtils {
    private static Set<String> ignoreSet = new HashSet<String>();

    private BeanEnhanceUtils() {
    }

    static ClassDescription getClassDescription(Class<?> beanClass, boolean usePropertyDescriptor) {
        ClassDescription classDescription = new ClassDescription();
        InputStream in = null;
        try {
            BeanEnhanceUtils.setPropertyDescriptors(classDescription, beanClass);
            if (usePropertyDescriptor) {
                BeanEnhanceUtils.buildFieldDescMapByProperty(classDescription);
            } else {
                in = beanClass.getClassLoader().getResourceAsStream(BeanEnhanceUtils.getInternalName(beanClass.getName()) + ".class");
                ClassReader reader = new ClassReader(in);
                ClassNode cn = new ClassNode();
                reader.accept(cn, 0);
                BeanEnhanceUtils.buildFieldDescMapByAsm(classDescription, cn);
            }
            classDescription.target = beanClass;
            classDescription.generalGetType = BeanEnhanceUtils.checkGenreal(beanClass);
            classDescription.hasField = !classDescription.fieldDescMap.isEmpty();
        }
        catch (IntrospectionException | IOException e) {
            throw new BeetlException("ERROR", "ASM\u589e\u5f3a\u529f\u80fd\uff0c\u751f\u6210\u7c7b:" + beanClass.getName() + "\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return classDescription;
    }

    private static void setPropertyDescriptors(ClassDescription classDescription, Class<?> beanClass) throws IntrospectionException {
        PropertyDescriptor[] propDescriptors = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
        ArrayList<PropertyDescriptor> propList = new ArrayList<PropertyDescriptor>(propDescriptors.length);
        propList.addAll(Arrays.asList(propDescriptors));
        propList.sort((p1, p2) -> Integer.compare(p1.getName().hashCode(), p2.getName().hashCode()));
        classDescription.propertyDescriptors = propList;
    }

    private static void buildFieldDescMapByProperty(ClassDescription classDescription) {
        List<PropertyDescriptor> propList = classDescription.propertyDescriptors;
        LinkedHashMap<Integer, List<FieldDescription>> filedDescMap = new LinkedHashMap<Integer, List<FieldDescription>>();
        int hashCode = 0;
        ArrayList<FieldDescription> filedDescs = null;
        FieldDescription filedDesc = null;
        Method curPropReadMethod = null;
        for (PropertyDescriptor prop : propList) {
            curPropReadMethod = prop.getReadMethod();
            if (curPropReadMethod == null || ignoreSet.contains(curPropReadMethod.getName())) continue;
            hashCode = prop.getName().hashCode();
            filedDescs = (ArrayList<FieldDescription>)filedDescMap.get(hashCode);
            if (filedDescs == null) {
                filedDescs = new ArrayList<FieldDescription>();
            }
            filedDesc = new FieldDescription();
            filedDesc.name = prop.getName();
            filedDesc.desc = Type.getType(curPropReadMethod.getReturnType()).toString();
            filedDesc.readMethodName = curPropReadMethod.getName();
            filedDesc.readMethodDesc = BeanEnhanceUtils.getMethodDesc(curPropReadMethod);
            filedDescs.add(filedDesc);
            filedDescMap.put(hashCode, filedDescs);
        }
        classDescription.fieldDescMap = filedDescMap;
    }

    private static String getMethodDesc(Method readMethod) {
        String descriptor = Type.getMethodDescriptor(readMethod);
        return descriptor.substring(descriptor.indexOf(40));
    }

    private static void buildFieldDescMapByAsm(ClassDescription classDescription, ClassNode cn) {
        List fieldList = cn.fields;
        fieldList.sort((f1, f2) -> Integer.compare(f1.name.hashCode(), f2.name.hashCode()));
        LinkedHashMap<Integer, List<FieldDescription>> filedDescMap = new LinkedHashMap<Integer, List<FieldDescription>>();
        int hashCode = 0;
        ArrayList<FieldDescription> filedDescs = null;
        FieldDescription filedDesc = null;
        for (FieldNode fieldNode : fieldList) {
            hashCode = fieldNode.name.hashCode();
            filedDescs = (ArrayList<FieldDescription>)filedDescMap.get(hashCode);
            if (filedDescs == null) {
                filedDescs = new ArrayList<FieldDescription>();
            }
            filedDesc = new FieldDescription(fieldNode.name, fieldNode.desc, BeanEnhanceUtils.createGetterMethodName(classDescription, fieldNode.name), "()" + fieldNode.desc);
            filedDescs.add(filedDesc);
            filedDescMap.put(hashCode, filedDescs);
        }
        classDescription.fieldDescMap = filedDescMap;
    }

    private static int checkGenreal(Class<?> target) {
        try {
            Method m = target.getMethod("get", Object.class);
            return 1;
        }
        catch (Exception m) {
            try {
                Method m2 = target.getMethod("get", String.class);
                return 2;
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    private static String createGetterMethodName(ClassDescription classDescription, String propertyName) {
        for (PropertyDescriptor ps : classDescription.propertyDescriptors) {
            if (!ps.getName().equals(propertyName)) continue;
            return ps.getReadMethod().getName();
        }
        throw new IllegalStateException("\u627e\u4e0d\u5230Getter\u65b9\u6cd5 " + propertyName);
    }

    static String getSimpleClassName(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    static String getInternalName(String className) {
        return className.replace('.', '/');
    }

    static int[] convertIntegerToPrimitiveType(Integer[] source) {
        int[] target = new int[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
        return target;
    }

    static {
        ignoreSet.add("getClass");
    }
}

