/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.lock.redis;

import java.util.Properties;
import org.noear.solonjt.dso.CfgUtil;
import org.noear.solonjt.dso.IJtLock;
import org.noear.solonjt.dso.JtBridge;
import org.noear.solonjt.dso.LogUtil;
import org.noear.solonjt.lock.redis.RedisX;
import org.noear.solonjt.utils.ConfigUtils;

public class RedisJtLock
implements IJtLock {
    private RedisX _redisX;

    public RedisJtLock(Properties prop) {
        this._redisX = new RedisX(prop);
    }

    public static void init(String cfg) throws Exception {
        Properties prop;
        if (cfg == null) {
            return;
        }
        String prop_str = cfg;
        if (cfg.startsWith("@")) {
            prop_str = CfgUtil.cfgGetValue((String)cfg.substring(1));
        }
        if ((prop = ConfigUtils.getProp((String)prop_str)) != null && prop.size() >= 5) {
            JtBridge.lockSet((IJtLock)new RedisJtLock(prop));
        } else {
            LogUtil.log((String)"RedisJtLock", (int)0, (String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u53c2\u6570\u6709\u95ee\u9898", (String)prop_str);
        }
    }

    public boolean tryLock(String group, String key, int inSeconds, String inMaster) {
        String key2 = group + ".lk." + key;
        return this._redisX.open1(ru -> ru.key(key2).expire(inSeconds).lock(inMaster));
    }

    public boolean tryLock(String group, String key, int inSeconds) {
        String key2 = group + ".lk." + key;
        return this._redisX.open1(ru -> ru.key(key2).expire(inSeconds).lock("_"));
    }

    public boolean tryLock(String group, String key) {
        return this.tryLock(group, key, 3);
    }

    public boolean isLocked(String group, String key) {
        String key2 = group + ".lk." + key;
        return this._redisX.open1(ru -> ru.key(key2).exists());
    }

    public void unLock(String group, String key) {
        String key2 = group + ".lk." + key;
        this._redisX.open0(ru -> ru.key(key2).delete());
    }
}

