/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.controller;

import java.util.Date;
import java.util.List;
import org.noear.solonjt.actuator.ActuatorFactory;
import org.noear.solonjt.dso.DbApi;
import org.noear.solonjt.dso.LogUtil;
import org.noear.solonjt.dso.TaskUtil;
import org.noear.solonjt.model.AFileModel;
import org.noear.solonjt.utils.Datetime;
import org.noear.solonjt.utils.ExceptionUtils;
import org.noear.solonjt.utils.Timecount;
import org.noear.solonjt.utils.Timespan;

public class TaskProcessor
implements TaskUtil.ITask {
    private boolean _init = false;

    @Override
    public String getName() {
        return "_task";
    }

    @Override
    public int getInterval() {
        return 60000;
    }

    @Override
    public void exec() throws Exception {
        if (!this._init) {
            this._init = true;
            DbApi.taskResetState();
        }
        List<AFileModel> list = DbApi.taskGetList();
        for (AFileModel task : list) {
            new Thread(() -> this.doExec(task)).start();
        }
    }

    private void doExec(AFileModel task) {
        try {
            this.runTask(task);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                String err = ExceptionUtils.getString((Exception)ex);
                LogUtil.log("_task", task.tag, task.path, 0, null, err);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            try {
                DbApi.taskSetState(task, 8);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void runTask(AFileModel task) throws Exception {
        String s2;
        if (task.plan_max > 0 && task.plan_count >= task.plan_max) {
            return;
        }
        if (task.plan_interval == null || task.plan_interval.length() < 2) {
            return;
        }
        if (task.plan_state == 2) {
            return;
        }
        Date temp = task.plan_last_time;
        if (temp == null) {
            temp = task.plan_begin_time;
        }
        if (temp == null) {
            return;
        }
        Datetime last_time = new Datetime(temp);
        String s1 = task.plan_interval.substring(0, task.plan_interval.length() - 1);
        switch (s2 = task.plan_interval.substring(task.plan_interval.length() - 1)) {
            case "m": {
                last_time.addMinute(Integer.parseInt(s1));
                break;
            }
            case "h": {
                last_time.addHour(Integer.parseInt(s1));
                break;
            }
            case "d": {
                task._is_day_task = true;
                last_time.addDay(Integer.parseInt(s1));
                break;
            }
            case "M": {
                task._is_day_task = true;
                last_time.addMonth(Integer.parseInt(s1));
                break;
            }
            default: {
                last_time.addDay(1);
            }
        }
        if (new Timespan(last_time.getFulltime()).seconds() < 0L) {
            return;
        }
        this.do_runTask(task);
    }

    private void do_runTask(AFileModel task) throws Exception {
        Timecount timecount = new Timecount().start();
        task.plan_last_time = new Date();
        DbApi.taskSetState(task, 2);
        ActuatorFactory.execOnly((AFileModel)task, null);
        ++task.plan_count;
        task.plan_last_timespan = timecount.stop().milliseconds();
        DbApi.taskSetState(task, 9);
    }
}

