/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.dso;

import java.io.InputStream;
import java.net.URL;
import org.noear.solon.XApp;
import org.noear.solon.XProperties;
import org.noear.solon.XUtil;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerLink;
import org.noear.solon.core.XMap;
import org.noear.solonjt.Config;
import org.noear.solonjt.controller.AppHandler;
import org.noear.solonjt.controller.FrmInterceptor;
import org.noear.solonjt.controller.ImgHandler;
import org.noear.solonjt.controller.SufHandler;
import org.noear.solonjt.controller.TaskProcessor;
import org.noear.solonjt.dso.CallUtil;
import org.noear.solonjt.dso.DbApi;
import org.noear.solonjt.dso.DbUtil;
import org.noear.solonjt.dso.InitUtil;
import org.noear.solonjt.dso.RouteHelper;
import org.noear.solonjt.dso.TaskUtil;
import org.noear.solonjt.utils.IOUtils;
import org.noear.solonjt.utils.TextUtils;

public class AppUtil {
    public static void init(XMap xarg, boolean initDb) {
        if (initDb) {
            XProperties prop = new XProperties();
            xarg.forEach((k, v) -> prop.setProperty(k, v));
            DbUtil.setDefDb(prop.getXmap("solonjt.db"));
        }
        InitUtil.tryInitDb();
        InitUtil.tryInitCore(xarg);
        InitUtil.tryInitNode(xarg);
    }

    public static void runAsInit(XApp app, String extend) {
        URL temp = XUtil.getResource((String)"setup.htm");
        String html = null;
        try {
            html = IOUtils.toString((InputStream)temp.openStream(), (String)"utf-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String html2 = html.trim();
        app.post("/setup.jsx", ctx -> {
            ctx.paramMap().put((Object)"node", (Object)org.noear.solonjt.dso.XUtil.g.guid());
            DbUtil.setDefDb(ctx.paramMap());
            try {
                DbUtil.db().sql("SHOW TABLES", new Object[0]).execute();
                InitUtil.trySaveConfig(extend, ctx.paramMap());
                AppUtil.init(ctx.paramMap(), false);
                ctx.outputAsJson("{\"code\":1}");
                new Thread(() -> {
                    XApp.global().router().clear();
                    AppUtil.runAsWork(XApp.global());
                }).start();
            }
            catch (Exception ex) {
                ctx.outputAsJson("{\"code\":0}");
            }
        });
        app.get("/", ctx -> ctx.outputAsHtml(html2));
        app.get("/**", ctx -> ctx.redirect("/"));
    }

    public static void runAsWork(XApp app) {
        String max_post_size = DbApi.cfgGet("http_max_post_size");
        if (!TextUtils.isEmpty((String)max_post_size)) {
            app.prop().setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", max_post_size);
        }
        String sss = (String)app.prop().argx().get((Object)"sss");
        app.sharedAdd("db", (Object)DbUtil.db());
        app.sharedAdd("cache", (Object)DbUtil.cache);
        if (TextUtils.isEmpty((String)sss) || sss.indexOf("web") >= 0) {
            RouteHelper.reset();
            AppUtil.do_runWeb(app);
        }
        if (TextUtils.isEmpty((String)sss) || sss.indexOf("sev") >= 0) {
            AppUtil.do_runSev(app);
        }
        CallUtil.callHook(null, "hook.start", false);
    }

    private static void do_runWeb(XApp app) {
        app.before("/**", "GET", (XHandler)FrmInterceptor.g());
        app.before("/**", "POST", (XHandler)FrmInterceptor.g());
        app.get(Config.frm_root_img + "**", (XHandler)new ImgHandler());
        app.all("/", (XHandler)AppHandler.g());
        app.all("/**", (XHandler)AppHandler.g());
        XHandler h1 = app.handlerGet();
        XHandlerLink hx = new XHandlerLink();
        hx.node = SufHandler.g();
        hx.nextNode = h1;
        app.handlerSet((XHandler)hx);
    }

    private static void do_runSev(XApp app) {
        TaskUtil.run(new TaskProcessor());
    }
}

