/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.dso;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.core.XMap;
import org.noear.solonjt.dso.DbApi;
import org.noear.solonjt.dso.DbUtil;
import org.noear.solonjt.dso.XUtil;
import org.noear.solonjt.utils.Base64Utils;
import org.noear.solonjt.utils.HttpUtils;
import org.noear.solonjt.utils.TextUtils;
import org.noear.solonjt.utils.ThreadUtils;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;

public class InitUtil {
    public static DbContext db() {
        return DbUtil.db();
    }

    public static void tryInitDb() {
        try {
            InitUtil.do_initDb();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void do_initDb() throws Exception {
        int num = InitUtil.db().sql("SHOW TABLES LIKE 'a\\_%';", new Object[0]).getDataList().getRowCount();
        if (num >= 6) {
            return;
        }
        InitUtil.db().exec("CREATE TABLE IF NOT EXISTS `a_config` (\n  `cfg_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '\u914d\u7f6eID',\n  `tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '\u5206\u7ec4\u6807\u7b7e',\n  `label` varchar(40) NOT NULL DEFAULT '' COMMENT '\u6807\u8bb0',\n  `name` varchar(99) NOT NULL COMMENT '\u540d\u79f0',\n  `value` varchar(999) NOT NULL DEFAULT '' COMMENT '\u503c',\n  `note` varchar(99) NOT NULL DEFAULT '' COMMENT '\u5907\u6ce8',\n  `edit_mode` varchar(40) DEFAULT NULL COMMENT '\u7f16\u8f91\u6a21\u5f0f',\n  `is_disabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u7981\u6b62\u4f7f\u7528',\n  `is_exclude` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u6392\u9664\u5bfc\u5165',\n  `is_modified` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u53ef\u4fee\u6539\u7684\uff08\u7ec8\u7aef\u7528\u6237\uff09',\n  `create_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u6700\u540e\u66f4\u65b0\u65f6\u95f4',\n  PRIMARY KEY (`cfg_id`),\n  UNIQUE KEY `IX_key` (`name`) USING BTREE,\n  KEY `IX_tag` (`tag`) USING BTREE,\n  KEY `IX_label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u914d\u7f6e\u8868';", new Object[0]);
        InitUtil.db().exec("CREATE TABLE IF NOT EXISTS `a_file` (\n  `file_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '\u6587\u4ef6ID',\n  `tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '\u5206\u7ec4\u6751\u7b7e',\n  `label` varchar(40) NOT NULL DEFAULT '' COMMENT '\u6807\u8bb0',\n  `path` varchar(60) NOT NULL COMMENT '\u6587\u4ef6\u8def\u5f84',\n  `is_staticize` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u9759\u6001',\n  `is_editable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '\u662f\u5426\u53ef\u7f16\u8f91',\n  `is_disabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u7981\u7528',\n  `is_exclude` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u6392\u9664\u5bfc\u5165',\n  `link_to` varchar(100) DEFAULT NULL COMMENT '\u8fde\u63a5\u5230',\n  `edit_mode` varchar(40) NOT NULL DEFAULT '' COMMENT '\u7f16\u8f91\u6a21\u5f0f',\n  `content_type` varchar(60) NOT NULL DEFAULT '' COMMENT '\u5185\u5bb9\u7c7b\u578b',\n  `content` longtext COMMENT '\u5185\u5bb9',\n  `note` varchar(99) DEFAULT '' COMMENT '\u5907\u6ce8',\n  `plan_state` int(11) NOT NULL DEFAULT '0' COMMENT '\u8ba1\u5212\u72b6\u6001',\n  `plan_begin_time` datetime DEFAULT NULL COMMENT '\u8ba1\u5212\u5f00\u59cb\u6267\u884c\u65f6\u95f4',\n  `plan_last_time` datetime DEFAULT NULL COMMENT '\u8ba1\u5212\u6700\u540e\u6267\u884c\u65f6\u95f4',\n  `plan_last_timespan` bigint(20) NOT NULL DEFAULT '0' COMMENT '\u8ba1\u5212\u6700\u540e\u6267\u884c\u65f6\u95f4\u957f\u5ea6',\n  `plan_interval` varchar(10) NOT NULL DEFAULT '' COMMENT '\u8ba1\u5212\u6267\u884c\u95f4\u9694',\n  `plan_max` int(11) NOT NULL DEFAULT '0' COMMENT '\u8ba1\u5212\u6267\u884c\u6700\u591a\u6b21\u6570',\n  `plan_count` int(11) NOT NULL DEFAULT '0' COMMENT '\u8ba1\u5212\u6267\u884c\u7d2f\u8ba1\u6b21\u6570',\n  `create_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u66f4\u65b0\u65f6\u95f4',\n  PRIMARY KEY (`file_id`),\n  UNIQUE KEY `IX_key` (`path`) USING HASH,\n  KEY `IX_tag` (`tag`) USING BTREE,\n  KEY `IX_label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u6587\u4ef6\u8868';", new Object[0]);
        InitUtil.db().exec("CREATE TABLE IF NOT EXISTS `a_image` (\n  `img_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '\u56fe\u7247ID',\n  `tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '\u5206\u7ec4\u6807\u7b7e',\n  `label` varchar(40) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e',\n  `path` varchar(99) NOT NULL COMMENT '\u6587\u4ef6\u8def\u5f84',\n  `content_type` varchar(99) NOT NULL COMMENT '\u5185\u5bb9\u7c7b\u578b',\n  `data` longtext COMMENT '\u6570\u636e',\n  `data_size` int(11) NOT NULL DEFAULT '0' COMMENT '\u6570\u636e\u957f\u5ea6',\n  `note` varchar(99) DEFAULT NULL COMMENT '\u5907\u6ce8',\n  `create_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u6700\u540e\u66f4\u65b0\u65f6\u95f4',\n  PRIMARY KEY (`img_id`),\n  UNIQUE KEY `IX_key` (`path`) USING BTREE,\n  KEY `IX_tag` (`tag`) USING BTREE,\n  KEY `IX_label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u56fe\u7247\u8868';", new Object[0]);
        InitUtil.db().exec("CREATE TABLE IF NOT EXISTS `a_log` (\n  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,\n  `level` int(11) NOT NULL DEFAULT '0' COMMENT '\u7b49\u7ea7',\n  `tag` varchar(99) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e',\n  `tag1` varchar(99) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e1',\n  `tag2` varchar(99) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e2',\n  `tag3` varchar(99) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e3',\n  `tag4` varchar(99) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e4',\n  `summary` varchar(1000) NOT NULL DEFAULT '' COMMENT '\u6458\u8981',\n  `content` longtext COMMENT '\u5185\u5bb9',\n  `log_date` int(11) NOT NULL DEFAULT '0' COMMENT '\u8bb0\u5f55\u65e5\u671f',\n  `log_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u8bb0\u5f55\u5b8c\u6574\u65f6\u95f4',\n  PRIMARY KEY (`log_id`),\n  KEY `IX_date` (`log_date`) USING BTREE,\n  KEY `IX_tag` (`tag`) USING BTREE,\n  KEY `IX_tag1` (`tag1`) USING BTREE,\n  KEY `IX_tag2` (`tag2`) USING BTREE,\n  KEY `IX_tag3` (`tag3`) USING BTREE,\n  KEY `IX_tag4` (`tag4`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u65e5\u5fd7\u8868';", new Object[0]);
        InitUtil.db().exec("CREATE TABLE IF NOT EXISTS `a_menu` (\n  `menu_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '\u83dc\u5355ID',\n  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '\u7236\u7ea7ID',\n  `tag` varchar(40) NOT NULL DEFAULT '' COMMENT '\u5206\u7ec4\u6807\u7b7e',\n  `label` varchar(100) DEFAULT '' COMMENT '\u5206\u7c7b\uff1a\u4e3b\u83dc\u5355\u3001\u9876\u90e8\u83dc\u5355\u3001\u5e95\u90e8\u83dc\u5355\u7b49',\n  `txt` varchar(100) DEFAULT NULL COMMENT '\u6587\u672c\u5185\u5bb9',\n  `url` varchar(512) DEFAULT NULL COMMENT '\u94fe\u63a5\u7684url',\n  `target` varchar(32) DEFAULT NULL COMMENT '\u6253\u5f00\u7684\u65b9\u5f0f',\n  `level` int(11) NOT NULL DEFAULT '0' COMMENT '\u7ea7\u522b',\n  `icon` varchar(64) DEFAULT NULL COMMENT '\u83dc\u5355\u7684icon',\n  `flag` varchar(32) DEFAULT NULL COMMENT '\u83dc\u5355\u6807\u8bc6',\n  `order_number` int(11) DEFAULT '0' COMMENT '\u6392\u5e8f\u5b57\u6bb5',\n  `rel_table` varchar(32) DEFAULT NULL COMMENT '\u8be5\u83dc\u5355\u662f\u5426\u548c\u5176\u4ed6\u8868\u5173\u8054',\n  `rel_id` bigint(20) unsigned DEFAULT NULL COMMENT '\u5173\u8054\u7684\u5177\u4f53\u6570\u636eid',\n  `is_disabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u7981\u7528',\n  `create_fulltime` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '\u4fee\u6539\u65f6\u95f4',\n  PRIMARY KEY (`menu_id`),\n  KEY `IX_order_number` (`order_number`) USING BTREE,\n  KEY `IX_tag` (`tag`) USING BTREE,\n  KEY `IX_label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u83dc\u5355\u8868';", new Object[0]);
        InitUtil.db().exec("CREATE TABLE IF NOT EXISTS `a_plugin` (\n  `plugin_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '\u63d2\u4ef6ID',\n  `plugin_tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '\u63d2\u4ef6\u6807\u7b7e',\n  `tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',\n  `label` varchar(40) NOT NULL DEFAULT '' COMMENT '\u6807\u8bb0',\n  `category` varchar(40) NOT NULL DEFAULT '' COMMENT '\u5206\u7c7b\uff08\u9884\u7559\uff09',\n  `name` varchar(40) NOT NULL COMMENT '\u540d\u79f0',\n  `author` varchar(40) NOT NULL COMMENT '\u4f5c\u8005',\n  `contacts` varchar(99) DEFAULT NULL COMMENT '\u8054\u7cfb\u65b9\u5f0f',\n  `ver_code` int(11) NOT NULL DEFAULT '0' COMMENT '\u7248\u672c\u4ee3\u53f7',\n  `ver_name` varchar(40) NOT NULL COMMENT '\u7248\u672c\u540d\u79f0',\n  `description` varchar(255) DEFAULT NULL COMMENT '\u63cf\u8ff0',\n  `thumbnail` varchar(255) DEFAULT NULL COMMENT '\u7f29\u7565\u56fe',\n  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '\u5730\u5740',\n  `is_installed` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u5df2\u5b89\u88c5\uff08\u76f8\u5bf9\u4e8e\u81ea\u5df1\uff09',\n  `is_approved` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u5ba1\u6838\u901a\u8fc7',\n  `num_downloads` int(11) NOT NULL DEFAULT '0' COMMENT '\u4e0b\u8f7d\u91cf',\n  `create_fulltime` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '\u6700\u540e\u66f4\u65b0\u65f6\u95f4',\n  PRIMARY KEY (`plugin_id`),\n  UNIQUE KEY `IX_key` (`plugin_tag`) USING HASH,\n  KEY `IX_tag` (`tag`) USING BTREE,\n  KEY `IX_category` (`category`) USING BTREE,\n  KEY `IX_label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u63d2\u4ef6\u8868';", new Object[0]);
        System.out.println("Complete table structure");
    }

    public static void tryInitNode(XMap map) {
        String node = (String)map.get((Object)"solonjt.node");
        if (TextUtils.isEmpty((String)node)) {
            node = (String)map.get((Object)"node");
        }
        if (!TextUtils.isEmpty((String)node)) {
            try {
                String addr = XUtil.g.localAddr();
                DbApi.cfgSet(node, addr, "cluster.node");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void tryInitCore(XMap map) {
        try {
            InitUtil.do_initCore(map);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void do_initCore(XMap map) throws Exception {
        List d_menu;
        String center = (String)map.get((Object)"solonjt.center");
        if (TextUtils.isEmpty((String)center)) {
            center = (String)map.get((Object)"center");
        }
        if (TextUtils.isEmpty((String)center)) {
            return;
        }
        if (InitUtil.db().table("a_plugin").exists()) {
            return;
        }
        String url = null;
        url = center.indexOf("://") > 0 ? center + "/.plugin/pull.jsx?plugin_tag=_core.noear" : "http://" + center + "/.plugin/pull.jsx?plugin_tag=_core.noear";
        String json = new HttpUtils(url).get();
        ONode data = ONode.map((Object)json);
        if (data.get("code").getInt() != 1) {
            return;
        }
        ONode body = data.get("data").get("body");
        ONode meta = data.get("data").get("meta");
        String tag = meta.get("tag").getString();
        String j_config = Base64Utils.decode((String)body.get("config").getString());
        String j_file = Base64Utils.decode((String)body.get("file").getString());
        String j_img = Base64Utils.decode((String)body.get("image").getString());
        String j_menu = Base64Utils.decode((String)body.get("menu").getString());
        List d_config = (List)ONode.deserialize((String)j_config, List.class);
        for (Object m : d_config) {
            m.remove("cfg_id");
            InitUtil.db().table("a_config").setMap((Map)m).insert();
        }
        List d_file = (List)ONode.deserialize((String)j_file, List.class);
        for (Object m : d_file) {
            m.remove("file_id");
            if (m.get("content") != null) {
                String c2 = Base64Utils.decode((String)m.get("content").toString());
                m.put("content", c2);
            }
            InitUtil.db().table("a_file").setMap((Map)m).insert();
        }
        List d_img = (List)ONode.deserialize((String)j_img, List.class);
        if (d_img != null) {
            for (Map m : d_img) {
                m.remove("img_id");
                InitUtil.db().table("a_image").setMap(m).insert();
            }
        }
        if ((d_menu = (List)ONode.deserialize((String)j_menu, List.class)) != null) {
            for (Map m : d_menu) {
                m.remove("menu_id");
                InitUtil.db().table("a_menu").setMap(m).insert();
            }
        }
        InitUtil.db().table("a_plugin").set("plugin_tag", (Object)meta.get("plugin_tag").getString()).set("tag", (Object)meta.get("tag").getString()).set("name", (Object)meta.get("name").getString()).set("author", (Object)meta.get("author").getString()).set("contacts", (Object)meta.get("contacts").getString()).set("ver_name", (Object)meta.get("ver_name").getString()).set("ver_code", (Object)meta.get("ver_code").getString()).set("description", (Object)meta.get("description").getString()).set("thumbnail", (Object)meta.get("thumbnail").getString()).set("is_installed", (Object)1).updateExt("plugin_tag");
        ((DbTableQuery)InitUtil.db().table("a_config").set("value", (Object)"Iv1H81dI2ZNzDS2n").where("name=?", new Object[]{"_frm_admin_pwd"})).update();
        ((DbTableQuery)InitUtil.db().table("a_config").set("value", (Object)"0").where("name=?", new Object[]{"_frm_enable_dev"})).update();
        ((DbTableQuery)InitUtil.db().table("a_file").set("link_to", (Object)"").where("path='/'", new Object[0])).update();
        System.out.println("Complete _core loading");
    }

    public static String tryInitExtend(XMap xarg) {
        String extend = (String)xarg.get((Object)"extend");
        if (extend == null) {
            extend = InitUtil.do_buildRoot();
        }
        return extend;
    }

    private static String do_buildRoot() {
        String fileName = "application.properties";
        URL temp = org.noear.solon.XUtil.getResource((String)fileName);
        if (temp == null) {
            return null;
        }
        String uri = temp.toString();
        if (uri.startsWith("file:/")) {
            uri = uri.substring(5, uri.length() - 30);
        } else {
            int idx = uri.indexOf("jar!/");
            idx = uri.lastIndexOf("/", idx) + 1;
            uri = uri.substring(9, idx);
        }
        uri = uri + "jt_ext" + "/";
        File dir = new File(uri);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return uri;
    }

    public static void trySaveConfig(String extend, XMap map) throws Exception {
        File file = new File(extend + "_db.properties");
        file.delete();
        file.createNewFile();
        StringBuilder sb = ThreadUtils.getStringBuilder();
        map.forEach((k, v) -> {
            if ("center".equals(k) || "node".equals(k)) {
                sb.append("solonjt").append(".");
            } else {
                sb.append("solonjt.db").append(".");
            }
            sb.append((String)k).append("=").append((String)v).append("\r\n");
        });
        FileWriter fw = new FileWriter(file);
        fw.write(sb.toString());
        fw.flush();
        fw.close();
    }
}

