/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.dso;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.coobird.thumbnailator.Thumbnails;
import org.noear.snack.ONode;
import org.noear.solon.XApp;
import org.noear.solon.annotation.XNote;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XFile;
import org.noear.solon.core.XMap;
import org.noear.solonjt.actuator.ActuatorFactory;
import org.noear.solonjt.controller.FrmInterceptor;
import org.noear.solonjt.controller.SufHandler;
import org.noear.solonjt.dso.AFileUtil;
import org.noear.solonjt.dso.AImageUtil;
import org.noear.solonjt.dso.CallUtil;
import org.noear.solonjt.dso.DbApi;
import org.noear.solonjt.dso.DbUtil;
import org.noear.solonjt.dso.ExtendUtil;
import org.noear.solonjt.dso.LogUtil;
import org.noear.solonjt.dso.PagingModel;
import org.noear.solonjt.dso.RouteHelper;
import org.noear.solonjt.dso.XFun;
import org.noear.solonjt.model.AImageModel;
import org.noear.solonjt.utils.Base64Utils;
import org.noear.solonjt.utils.Datetime;
import org.noear.solonjt.utils.EncryptUtils;
import org.noear.solonjt.utils.HttpUtils;
import org.noear.solonjt.utils.IOUtils;
import org.noear.solonjt.utils.IPUtils;
import org.noear.solonjt.utils.ImageUtils;
import org.noear.solonjt.utils.JarUtils;
import org.noear.solonjt.utils.LocalUtil;
import org.noear.solonjt.utils.MethodUtils;
import org.noear.solonjt.utils.TextUtils;
import org.noear.solonjt.utils.ThreadUtils;
import org.noear.solonjt.utils.TimeUtils;
import org.noear.solonjt.utils.Timecount;
import org.noear.solonjt.utils.Timespan;
import org.noear.weed.DbContext;

public class XUtil {
    public static final XUtil g = new XUtil();
    private final Map<String, DbContext> _db_cache = new HashMap<String, DbContext>();
    private final Map<String, Object> _empMap = Collections.unmodifiableMap(new HashMap());
    private List<Object> _empList = Collections.unmodifiableList(new ArrayList());
    private Set<Object> _empSet = Collections.unmodifiableSet(new HashSet());
    private String _localAddr;

    @XNote(value="\u751f\u6210GUID")
    public String guid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    @XNote(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237IP")
    public String ip() {
        return IPUtils.getIP((XContext)XContext.current());
    }

    @XNote(value="\u751f\u6210\u6570\u636e\u5e93\u4e0a\u4e0b\u6587")
    public DbContext db(String cfg) {
        return this.db(cfg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XNote(value="\u751f\u6210\u6570\u636e\u5e93\u4e0a\u4e0b\u6587")
    public DbContext db(String cfg, DbContext def) {
        if (TextUtils.isEmpty((String)cfg)) {
            return def;
        }
        DbContext tmp = this._db_cache.get(cfg);
        if (tmp == null) {
            String string = cfg;
            synchronized (string) {
                tmp = this._db_cache.get(cfg);
                if (tmp == null) {
                    ArrayList<String> args = new ArrayList<String>();
                    String[] strs = cfg.split(" |\n|\r|\t");
                    int len = strs.length;
                    for (int i = 0; i < len; ++i) {
                        if (strs[i].length() <= 0) continue;
                        args.add(strs[i]);
                    }
                    tmp = DbUtil.getDb((Map<String, String>)XMap.from(args));
                    if (tmp != null) {
                        this._db_cache.put(cfg, tmp);
                    }
                }
            }
        }
        return tmp;
    }

    @XNote(value="\u7a7a\u7684Map<String,Object>\u96c6\u5408")
    public Map<String, Object> empMap() {
        return this._empMap;
    }

    @XNote(value="\u7a7a\u7684List<Object>\u96c6\u5408")
    public List<Object> empList() {
        return this._empList;
    }

    @XNote(value="\u521b\u5efa\u4e00\u4e2aSet<Object>\u96c6\u5408")
    public Set<Object> empSet() {
        return this._empSet;
    }

    @XNote(value="\u521b\u5efa\u4e00\u4e2aMap<String,Object>\u96c6\u5408")
    public Map<String, Object> newMap() {
        return new HashMap<String, Object>();
    }

    @XNote(value="\u521b\u5efa\u4e00\u4e2aList<Object>\u96c6\u5408")
    public List<Object> newList() {
        return new ArrayList<Object>();
    }

    @XNote(value="\u521b\u5efa\u4e00\u4e2aList<Object>\u96c6\u5408")
    public List<Object> newList(Object[] ary) {
        return Arrays.asList(ary);
    }

    @XNote(value="\u521b\u5efa\u4e00\u4e2aSet<Object>\u96c6\u5408")
    public Set<Object> newSet() {
        return new HashSet<Object>();
    }

    @XNote(value="\u521b\u5efa\u4e00\u4e2aByteArrayOutputStream")
    public OutputStream newOutputStream() {
        return new ByteArrayOutputStream();
    }

    @XNote(value="\u6267\u884c HTTP \u8bf7\u6c42")
    public HttpUtils http(String url) {
        return new HttpUtils(url);
    }

    @XNote(value="\u7f16\u7801html")
    public String htmlEncode(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    @XNote(value="\u7f16\u7801url")
    public String urlEncode(String str) throws Exception {
        if (str == null) {
            return str;
        }
        return URLEncoder.encode(str, "utf-8");
    }

    @XNote(value="\u89e3\u7801url")
    public String urlDecode(String str) throws Exception {
        if (str == null) {
            return str;
        }
        return URLDecoder.decode(str, "utf-8");
    }

    @XNote(value="\u914d\u7f6e\u83b7\u53d6")
    public String cfgGet(String name) throws Exception {
        return DbApi.cfgGet(name);
    }

    @XNote(value="\u914d\u7f6e\u83b7\u53d6")
    public String cfgGet(String name, String def) throws Exception {
        return DbApi.cfgGet(name, def);
    }

    @XNote(value="\u914d\u7f6e\u8bbe\u7f6e")
    public boolean cfgSet(String name, String value) throws Exception {
        return DbApi.cfgSet(name, value, null);
    }

    public List<Map<String, Object>> menuGet(String label, int pid) throws Exception {
        return DbApi.menuGet(label, pid);
    }

    @XNote(value="\u4fdd\u5b58\u56fe\u7247")
    public String imgSet(XFile file) throws Exception {
        return this.imgSet(file, file.extension);
    }

    @XNote(value="\u4fdd\u5b58\u56fe\u7247")
    public String imgSet(XFile file, String tag, String dir, int name_mod) throws Exception {
        String extension = file.extension;
        byte[] data_byte = IOUtils.toBytes((InputStream)file.content);
        String data = Base64Utils.encodeByte((byte[])data_byte);
        StringBuilder path = ThreadUtils.getStringBuilder();
        if (name_mod == 0) {
            tag = null;
            path.append("/img/");
            path.append(this.guid());
            path.append(".");
            path.append(extension);
        } else {
            path.append("/img/");
            if (!TextUtils.isEmpty((String)tag)) {
                path.append(tag).append("/");
            }
            if (!TextUtils.isEmpty((String)dir)) {
                path.append(dir).append("/");
            }
            path.append(file.name);
        }
        String path2 = path.toString().replace("//", "/");
        DbApi.imgSet(tag, path2, file.contentType, data, "");
        return path2;
    }

    @XNote(value="\u4fdd\u5b58\u56fe\u7247\uff08\u540e\u7f00\u540d\u53ef\u81ea\u5b9a\u4e49\uff09")
    public String imgSet(XFile file, String extension) throws Exception {
        byte[] data_byte = IOUtils.toBytes((InputStream)file.content);
        String data = Base64Utils.encodeByte((byte[])data_byte);
        String path = "/img/" + this.guid() + "." + extension;
        DbApi.imgSet(null, path, file.contentType, data, "");
        return path;
    }

    @XNote(value="\u4fdd\u5b58\u56fe\u7247\uff08\u5185\u5bb9\uff0c\u7c7b\u578b\uff0c\u540e\u7f00\u540d\u53ef\u81ea\u5b9a\u4e49\uff09")
    public String imgSet(String content, String contentType, String extension) throws Exception {
        String data = Base64Utils.encode((String)content);
        String path = "/img/" + this.guid() + "." + extension;
        DbApi.imgSet(null, path, contentType, data, "");
        return path;
    }

    @XNote(value="\u4fdd\u5b58\u56fe\u7247\uff08\u5185\u5bb9\uff0c\u7c7b\u578b\uff0c\u540d\u5b57\uff0c\u540e\u7f00\u540d\u53ef\u81ea\u5b9a\u4e49\uff09")
    public String imgSet(String content, String contentType, String extension, String name) throws Exception {
        String data = Base64Utils.encode((String)content);
        String path = "/img/" + name + "." + extension;
        DbApi.imgSet(null, path, contentType, data, "");
        return path;
    }

    @XNote(value="\u4fdd\u5b58\u56fe\u7247\uff08\u5185\u5bb9\uff0c\u7c7b\u578b\uff0c\u540d\u5b57\uff0c\u540e\u7f00\u540d\uff0c\u6807\u7b7e\u53ef\u81ea\u5b9a\u4e49\uff09")
    public String imgSet(String content, String contentType, String extension, String name, String label) throws Exception {
        String data = Base64Utils.encode((String)content);
        String path = "/img/" + name + "." + extension;
        DbApi.imgSet(null, path, contentType, data, label);
        return path;
    }

    @XNote(value="\u8bbe\u5b9a\u56fe\u7247\u8f93\u51fa\u540d\u79f0")
    public String imgOutName(XContext ctx, String filename) throws Exception {
        String filename2 = URLEncoder.encode(filename, "utf-8");
        ctx.headerSet("Content-Disposition", "attachment; filename=\"" + filename2 + "\"");
        return filename;
    }

    @XNote(value="\u4fee\u6539\u56fe\u7247")
    public String imgUpd(String path, String content) throws Exception {
        String data = Base64Utils.encode((String)content);
        DbApi.imgUpd(path, data);
        return path;
    }

    @XNote(value="\u83b7\u53d6\u56fe\u7247\u5185\u5bb9")
    public String imgGet(String path) throws Exception {
        AImageModel img = DbApi.imgGet(path);
        return this.img2String(img.data);
    }

    @XNote(value="\u56fe\u7247\u5185\u5bb9\u8f6c\u4e3a\u5b57\u7b26\u4e32")
    public String img2String(String data) {
        if (TextUtils.isEmpty((String)data)) {
            return "";
        }
        return Base64Utils.decode((String)data);
    }

    @XNote(value="\u6587\u4ef6\u65b0\u5efa")
    public boolean fileNew(int fid, XContext ctx) throws Exception {
        return DbApi.fileNew(fid, ctx);
    }

    @XNote(value="\u6587\u4ef6\u8bbe\u7f6e\u5185\u5bb9")
    public boolean fileSet(int fid, String fcontent) throws Exception {
        return DbApi.fileSet(fid, fcontent);
    }

    @XNote(value="\u6587\u4ef6\u5237\u65b0\u7f13\u5b58")
    public boolean fileFlush(String path, boolean is_del) {
        if (TextUtils.isEmpty((String)path)) {
            return false;
        }
        String name = path.replace("/", "__");
        if (is_del) {
            RouteHelper.del(path);
        } else {
            RouteHelper.add(path);
        }
        AFileUtil.remove(path);
        ActuatorFactory.del((String)name);
        return true;
    }

    @XNote(value="\u6587\u4ef6\u5237\u65b0\u7f13\u5b58")
    public boolean fileFlush(String path, boolean is_del, String label, String note) {
        if (TextUtils.isEmpty((String)path)) {
            return false;
        }
        String path2 = path;
        String name = path2.replace("/", "__");
        AFileUtil.remove(path2);
        ActuatorFactory.del((String)name);
        if (is_del) {
            RouteHelper.del(path);
        } else {
            RouteHelper.add(path);
        }
        if ("filter.file".equals(label)) {
            if (is_del) {
                SufHandler.g().del(note);
            } else {
                SufHandler.g().add(path, note);
            }
        }
        if ("filter.path".equals(label)) {
            if (is_del) {
                FrmInterceptor.g().del(path);
            } else {
                FrmInterceptor.g().add(path, note);
            }
        }
        return true;
    }

    @XNote(value="\u91cd\u542f\u7f13\u5b58")
    public boolean restart() {
        AFileUtil.removeAll();
        AImageUtil.removeAll();
        ActuatorFactory.delAll();
        DbUtil.cache.clear();
        SufHandler.g().reset();
        FrmInterceptor.g().reset();
        RouteHelper.reset();
        return true;
    }

    @XNote(value="\u83b7\u53d6\u63a5\u53e3\u5f00\u653e\u6e05\u5355")
    public List<Map<String, Object>> interfaceList() {
        HashMap<String, Class<Timespan>> tmp = new HashMap<String, Class<Timespan>>();
        tmp.putAll(XApp.global().shared());
        tmp.put("XUtil.http(url)", HttpUtils.class);
        tmp.put("XUtil.db(cfg)", DbContext.class);
        tmp.put("XUtil.paging(ctx,pageSize)", PagingModel.class);
        tmp.put("XUtil.thumbnail(file)", Thumbnails.Builder.class);
        tmp.put("ctx", XContext.class);
        tmp.put("XFile", XFile.class);
        tmp.put("new Datetime()", Datetime.class);
        tmp.put("new Timecount()", Timecount.class);
        tmp.put("new Timespan(date)", Timespan.class);
        List list = MethodUtils.getMethods(tmp);
        XFun.g.openList(list);
        Collections.sort(list, Comparator.comparing(m -> m.get("name").toString().toLowerCase()));
        return list;
    }

    @XNote(value="\u83b7\u53d6\u6267\u884c\u5668\u6e05\u5355")
    public Set<String> actuatorList() {
        return ActuatorFactory.list();
    }

    @XNote(value="\u6dfb\u52a0\u5171\u4eab\u5bf9\u8c61\uff08key, \u4ee5 _ \u5f00\u5934\uff09")
    public boolean sharedAdd(String key, Object obj) {
        if (TextUtils.isEmpty((String)key)) {
            return false;
        }
        if (key.startsWith("_")) {
            XApp.global().sharedAdd(key, obj);
            return true;
        }
        return false;
    }

    @XNote(value="\u68c0\u67e5\u5171\u4eab\u5bf9\u8c61")
    public boolean sharedHas(String key) {
        if (TextUtils.isEmpty((String)key)) {
            return false;
        }
        return XApp.global().shared().containsKey(key);
    }

    @XNote(value="\u83b7\u53d6\u6269\u5c55\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6")
    public List<Map<String, Object>> extendList() {
        return ExtendUtil.scan();
    }

    @XNote(value="\u5220\u9664\u6269\u5c55\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6")
    public boolean extendDel(String name) {
        return ExtendUtil.del(name);
    }

    @XNote(value="\u751f\u6210md5\u7801")
    public String md5(String str) {
        return EncryptUtils.md5((String)str, (String)"UTF-16LE");
    }

    @XNote(value="\u751f\u6210md5\u7801")
    public String md5(String str, String charset) {
        return EncryptUtils.md5((String)str, (String)charset);
    }

    @XNote(value="\u751f\u6210sha1\u7801")
    public String sha1(String str) {
        return EncryptUtils.sha1((String)str, (String)"UTF-16LE");
    }

    @XNote(value="\u751f\u6210sha1\u7801")
    public String sha1(String str, String charset) {
        return EncryptUtils.sha1((String)str, (String)charset);
    }

    @XNote(value="BASE64\u7f16\u7801")
    public String base64Encode(String text) {
        return Base64Utils.encode((String)text);
    }

    @XNote(value="BASE64\u89e3\u7801")
    public String base64Decode(String text) {
        return Base64Utils.decode((String)text);
    }

    @XNote(value="\u751f\u6210\u968f\u673a\u7801")
    public String codeByRandom(int len) {
        return TextUtils.codeByRandom((int)len);
    }

    @XNote(value="\u5b57\u7b26\u7801\u8f6c\u4e3a\u56fe\u7247")
    public BufferedImage codeToImage(String code) throws Exception {
        return ImageUtils.getValidationImage((String)code);
    }

    @XNote(value="InputStream\u8f6c\u4e3aString")
    public String streamToString(InputStream inStream) throws Exception {
        return IOUtils.toString((InputStream)inStream, (String)"utf-8");
    }

    @XNote(value="OutStream\u8f6c\u4e3aInputStream")
    public InputStream streamOutToIn(OutputStream outStream) throws Exception {
        return IOUtils.outToIn((OutputStream)outStream);
    }

    @XNote(value="String\u8f6c\u4e3aInputStream")
    public InputStream stringToStream(String str) throws Exception {
        return new ByteArrayInputStream(str.getBytes("UTF-8"));
    }

    @XNote(value="Object\u8f6c\u4e3aONode")
    public ONode oNode(Object obj) throws Exception {
        if (obj == null) {
            return new ONode();
        }
        return ONode.map((Object)obj);
    }

    @XNote(value="\u751f\u6210\u5206\u9875\u6570\u636e\u6a21\u578b")
    public PagingModel paging(XContext ctx, int pageSize) {
        return new PagingModel(ctx, pageSize, false);
    }

    @XNote(value="\u751f\u6210\u5206\u9875\u6570\u636e\u6a21\u578b")
    public PagingModel paging(XContext ctx, int pageSize, boolean fixedSize) {
        return new PagingModel(ctx, pageSize, fixedSize);
    }

    @XNote(value="\u683c\u5f0f\u5316\u6d3b\u52a8\u65f6\u95f4")
    public String liveTime(Date date) {
        return TimeUtils.liveTime((Date)date);
    }

    @XNote(value="\u521b\u5efa\u7f29\u7565\u56fe\u5de5\u5177")
    public Object thumbnail(XFile file) {
        return Thumbnails.of((InputStream[])new InputStream[]{file.content});
    }

    @XNote(value="\u662f\u5426\u4e3a\u6570\u5b57")
    public boolean isNumber(String str) {
        return TextUtils.isNumber((String)str);
    }

    @XNote(value="\u52a0\u8f7d\u63d2\u4ef6\u91cc\u7684jar\u5305")
    public boolean loadJar(String path, String data64, String plugin) throws Exception {
        return JarUtils.loadJar((String)path, (String)data64, (String)plugin);
    }

    @XNote(value="\u8c03\u7528\u4e00\u4e2a\u6587\u4ef6")
    public Object callFile(String path) throws Exception {
        return CallUtil.callFile(path);
    }

    @XNote(value="\u8c03\u7528\u4e00\u4e2a\u6587\u4ef6")
    public Object callFile(String path, Map<String, Object> attrs) throws Exception {
        XContext.current().attrSet(attrs);
        return CallUtil.callFile(path);
    }

    @XNote(value="\u8c03\u7528\u4e00\u7ec4\u52fe\u5b50")
    public String callHook(String tag, String label, boolean useCache) throws Exception {
        return CallUtil.callHook(tag, label, useCache);
    }

    @XNote(value="\u8c03\u7528\u4e00\u7ec4\u52fe\u5b50")
    public String callHook(String tag, String label, boolean useCache, Map<String, Object> attrs) throws Exception {
        XContext.current().attrSet(attrs);
        return CallUtil.callHook(tag, label, useCache);
    }

    @XNote(value="\u65e5\u5fd7")
    public boolean log(Map<String, Object> data) throws Exception {
        return LogUtil.log(data);
    }

    @XNote(value="\u670d\u52a1\u5730\u5740")
    public String localAddr() throws Exception {
        if (this._localAddr == null) {
            this._localAddr = LocalUtil.getLocalAddress((int)XApp.global().port());
        }
        return this._localAddr;
    }

    @XNote(value="\u8bbe\u7f6e\u4e0a\u4e0b\u6587\u72b6\u6001\uff08\u7528\u4e8e\u5728\u6a21\u677f\u4e2d\u505c\u6b62\u8bf7\u6c42\uff09")
    public int statusSet(int status) throws Exception {
        XContext.current().status(status);
        throw new RuntimeException(status + " status");
    }
}

