/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.dso;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.annotation.XNote;
import org.noear.solon.core.XContext;

public class PagingModel
implements Serializable {
    private final long _page_begin = 1L;
    private long _page;
    private long _pageSize;
    private long _pageSize_def;
    private long _total;
    private long _pages = -1L;

    public PagingModel(XContext ctx, long pageSize, boolean fixedSize) {
        this._page = ctx.paramAsLong("_page", 1L);
        this._pageSize_def = pageSize;
        if (this._page < 1L) {
            this._page = 1L;
        }
        if (fixedSize) {
            this._pageSize = pageSize;
        } else {
            this._pageSize = ctx.paramAsInt("_pageSize", 0);
            if (this._pageSize < 1L) {
                this._pageSize = Integer.parseInt(ctx.cookie("_pageSize", "0"));
            }
            if (this._pageSize > 99L) {
                this._pageSize = 99L;
            }
            if (this._pageSize < 1L) {
                this._pageSize = pageSize;
            } else {
                ctx.cookieSet("_pageSize", this._pageSize + "", "", ctx.path(), Integer.MAX_VALUE);
            }
        }
    }

    @XNote(value="\u8bbe\u7f6e\u603b\u8bb0\u5f55\u6570")
    public PagingModel totalSet(int total) {
        this._total = total;
        return this;
    }

    @XNote(value="\u8d77\u59cb\u8bb0\u5f55\u6570")
    public long start() {
        return (int)(this._pageSize * (this._page - 1L));
    }

    @XNote(value="\u5206\u9875\u957f\u5ea6")
    public long pageSize() {
        return this._pageSize;
    }

    @XNote(value="\u9ed8\u8ba4\u5206\u9875\u957f\u5ea6")
    public long pageSizeDef() {
        return this._pageSize_def;
    }

    @XNote(value="\u5f53\u524d\u9875\u7801")
    public long page() {
        return this._page;
    }

    @XNote(value="\u9875\u7801\u533a\u95f4\u7684\u8d77\u59cb\u9875")
    public List<Long> pageRange(int size) {
        ArrayList<Long> list = new ArrayList<Long>();
        boolean isleft = this.pages() - this.page() > this.page();
        long _bef = 0L;
        if (isleft) {
            _bef = this.page() - (long)((size - 1) / 2);
        } else {
            long _aft = this.page() + (long)((size - 1) / 2);
            if (_aft > this.pages()) {
                _aft = this.pages();
            }
            _bef = _aft - (long)size;
        }
        if (_bef < 1L) {
            _bef = 1L;
        }
        long len = _bef + (long)size;
        for (long i = _bef; i < len && i <= this.pages(); ++i) {
            list.add(i);
        }
        if (size > 7 && this.pages() > (long)size) {
            if (isleft) {
                if (this.pages() - (Long)list.get(list.size() - 1) > 3L) {
                    list.remove(list.size() - 1);
                    list.remove(list.size() - 1);
                    list.remove(list.size() - 1);
                    list.add(-1L);
                    list.add(this.pages() - 1L);
                    list.add(this.pages());
                }
            } else if ((Long)list.get(0) - 1L > 3L) {
                list.remove(0);
                list.remove(0);
                list.remove(0);
                list.add(0, -1L);
                list.add(0, 2L);
                list.add(0, 1L);
            }
        }
        return list;
    }

    @XNote(value="\u4e0a\u4e00\u9875\u7801")
    public long pagePrev() {
        if (this._page > 1L) {
            return this._page - 1L;
        }
        return this._page;
    }

    @XNote(value="\u4e0b\u4e00\u9875\u7801")
    public long pageNext() {
        return this._page + 1L;
    }

    @XNote(value="\u662f\u5426\u6709\u4e0a\u4e00\u9875")
    public boolean hasPrev() {
        return this.page() > 1L;
    }

    @XNote(value="\u662f\u5426\u6709\u4e0b\u4e00\u9875")
    public boolean hasNext() {
        return this.pages() >= this.pageNext();
    }

    @XNote(value="\u603b\u9875\u6570")
    public long pages() {
        if (this._pages < 0L) {
            this._pages = this._total % this._pageSize > 0L ? this._total / this._pageSize + 1L : this._total / this._pageSize;
        }
        return this._pages;
    }

    @XNote(value="\u603b\u8bb0\u5f55\u6570")
    public long total() {
        return this._total;
    }
}

