/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.dso;

import java.util.Date;
import org.noear.solon.core.XContext;
import org.noear.solonjt.model.AFileModel;

public class AFileStaticHandler {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final Date app_runtime = new Date();

    public static void handle(XContext context, String path, AFileModel file) throws Exception {
        String mime;
        context.charset("utf-8");
        context.setHandled(true);
        if (file.update_fulltime == null) {
            file.update_fulltime = app_runtime;
        }
        String modified_since = context.header("If-Modified-Since");
        String modified_now = file.update_fulltime.toString();
        if (modified_since != null && modified_since.equals(modified_now)) {
            context.headerSet(CACHE_CONTROL, "max-age=6000");
            context.headerSet(LAST_MODIFIED, modified_now);
            context.charset("utf-8");
            context.status(304);
            return;
        }
        int idx = path.lastIndexOf(".");
        if (idx > 0 && (mime = file.content_type) != null) {
            context.headerSet(CACHE_CONTROL, "max-age=6000");
            context.headerSet(LAST_MODIFIED, file.update_fulltime.toString());
            context.contentType(mime);
            context.charset("utf-8");
        }
        context.status(200);
        context.output(file.content);
    }
}

