/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.dso;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMap;
import org.noear.solonjt.utils.StringUtils;
import org.noear.solonjt.utils.TextUtils;
import org.noear.weed.DbContext;
import org.noear.weed.cache.LocalCache;

public class DbUtil {
    public static final LocalCache cache = new LocalCache("data", 300);
    private static DbContext _db = null;

    public static DbContext db() {
        return _db;
    }

    public static void setDefDb(XMap map) {
        _db = DbUtil.getDb((Map<String, String>)map);
    }

    public static DbContext getDb(Map<String, String> map) {
        String password;
        String username;
        String url = map.get("url");
        String server = map.get("server");
        String schema = map.get("schema");
        if (TextUtils.isEmpty((String)schema)) {
            schema = map.get("name");
        }
        if (TextUtils.isEmpty((String)(username = map.get("username")))) {
            username = map.get("usr");
        }
        if (TextUtils.isEmpty((String)(password = map.get("password")))) {
            password = map.get("pwd");
        }
        String type = map.get("type");
        String driverClassName = map.get("driverClassName");
        if (TextUtils.isEmpty((String)driverClassName)) {
            driverClassName = map.get("driver");
        }
        if (XUtil.isEmpty((String)url) && XUtil.isEmpty((String)server) || XUtil.isEmpty((String)schema) || XUtil.isEmpty((String)username) || XUtil.isEmpty((String)password)) {
            throw new RuntimeException("please enter a normal database config");
        }
        return DbUtil.getDb(schema, driverClassName, type, url, server, username, password);
    }

    private static DbContext getDb(String schema, String driverClassName, String type, String url, String server, String username, String password) {
        type = TextUtils.isEmpty((String)type) ? "mysql" : type.trim();
        if (schema != null) {
            schema = schema.trim();
        }
        if (driverClassName != null) {
            driverClassName = driverClassName.trim();
        }
        if (schema != null) {
            schema = schema.trim();
        }
        if (url != null) {
            url = url.trim();
        }
        if (server != null) {
            server = server.trim();
        }
        if (schema != null) {
            schema = schema.trim();
        }
        if (username != null) {
            username = username.trim();
        }
        if (password != null) {
            password = password.trim();
        }
        if (TextUtils.isEmpty((String)url)) {
            StringBuilder sb = StringUtils.borrowBuilder();
            sb.append("jdbc:").append(type).append("://").append(server.trim()).append("/").append(schema.trim());
            if ("mysql".equals(type)) {
                sb.append("?useSSL=false&allowMultiQueries=true&useUnicode=true&characterEncoding=utf8&autoReconnect=true&rewriteBatchedStatements=true");
            }
            url = StringUtils.releaseBuilder((StringBuilder)sb);
        }
        if (!TextUtils.isEmpty((String)driverClassName)) {
            try {
                Class.forName(driverClassName);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if ("mysql".equals(type)) {
            HikariDataSource source = new HikariDataSource();
            source.setJdbcUrl(url);
            source.setUsername(username);
            source.setPassword(password);
            source.setSchema(schema);
            if (!TextUtils.isEmpty((String)driverClassName)) {
                source.setDriverClassName(driverClassName);
            }
            return new DbContext(schema, (DataSource)source).fieldFormatSet("`%`").objectFormatSet("`%`");
        }
        return new DbContext(schema, url, username, password);
    }
}

