/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.dso;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerLink;
import org.noear.solon.core.XMethod;
import org.noear.solonjt.Config;
import org.noear.solonjt.SolonJT;
import org.noear.solonjt.dso.CallUtil;
import org.noear.solonjt.dso.DbUtil;
import org.noear.solonjt.dso.InitUtil;
import org.noear.solonjt.dso.JtUtil;
import org.noear.solonjt.dso.LogUtil;
import org.noear.solonjt.dso.RouteHelper;
import org.noear.solonjt.dso.TaskRunner;
import org.noear.solonjt.event.http.AppHandler;
import org.noear.solonjt.event.http.FrmInterceptor;
import org.noear.solonjt.event.http.ImgHandler;
import org.noear.solonjt.event.http.SufHandler;
import org.noear.solonjt.task.IJtTaskRunner;
import org.noear.solonjt.task.TaskFactory;
import org.noear.solonjt.utils.ExceptionUtils;
import org.noear.solonjt.utils.IOUtils;
import org.noear.solonjt.utils.TextUtils;
import org.noear.weed.WeedConfig;

public class AppUtil {
    public static void init(XApp app, boolean initDb) {
        if (initDb) {
            DbUtil.setDefDb(app.prop().getXmap("solonjt.db"));
        }
        InitUtil.tryInitDb();
        InitUtil.tryInitCore(app);
        InitUtil.tryInitNode(app);
    }

    public static void runAsInit(XApp app, String extend) {
        URL temp = XUtil.getResource((String)"setup.htm");
        String html = null;
        try {
            html = IOUtils.toString((InputStream)temp.openStream(), (String)"utf-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String node2 = (String)app.prop().argx().get((Object)"node");
        String html2 = html.trim();
        app.post("/setup.jsx", ctx -> {
            if (node2 != null && node2.length() > 30) {
                ctx.paramMap().put("node", (Object)node2);
            } else {
                ctx.paramMap().put("node", (Object)JtUtil.g.guid());
            }
            DbUtil.setDefDb(ctx.paramMap());
            try {
                DbUtil.db().sql("SHOW TABLES", new Object[0]).execute();
                InitUtil.trySaveConfig(extend, ctx.paramMap());
                app.prop().argx().putAll((Map)ctx.paramMap());
                AppUtil.init(app, false);
                String _usr = JtUtil.g.cfgGet("_frm_admin_user");
                String _pwd = JtUtil.g.cfgGet("_frm_admin_pwd");
                String _token = JtUtil.g.sha1(_usr + '#' + _pwd, "UTF-16LE").toUpperCase();
                ONode rst = new ONode();
                rst.set("code", (Object)1);
                rst.set("token", (Object)_token);
                ctx.outputAsJson(rst.toJson());
                new Thread(() -> {
                    XApp.global().router().clear();
                    AppUtil.runAsWork(XApp.global());
                }).start();
            }
            catch (Throwable ex) {
                ctx.outputAsJson(new ONode().set("code", (Object)0).set("msg", (Object)ExceptionUtils.getString((Throwable)ex)).toJson());
            }
        });
        app.get("/", ctx -> ctx.outputAsHtml(html2));
        app.get("/**", ctx -> ctx.redirect("/"));
    }

    public static void runAsWork(XApp app) {
        String sss = (String)app.prop().argx().get((Object)"sss");
        app.sharedAdd("db", (Object)DbUtil.db());
        app.sharedAdd("cache", (Object)DbUtil.cache);
        app.sharedAdd("localCache", (Object)DbUtil.cache);
        if (TextUtils.isEmpty((String)sss) || sss.indexOf("web") >= 0) {
            RouteHelper.reset();
            AppUtil.do_runWeb(app);
        }
        if (TextUtils.isEmpty((String)sss) || sss.indexOf("sev") >= 0) {
            AppUtil.do_runSev(app);
        }
        AppUtil.do_weedTrack();
        CallUtil.callLabel(null, (String)"hook.start", (boolean)false, null);
        SolonJT.onLoad();
    }

    private static void do_runWeb(XApp app) {
        app.before("**", XMethod.HTTP, (XHandler)FrmInterceptor.g());
        app.get(Config.frm_root_img + "**", (XHandler)new ImgHandler());
        app.all("**", (XHandler)AppHandler.g());
        XHandler h1 = app.handlerGet();
        XHandlerLink hx = new XHandlerLink();
        hx.node = SufHandler.g();
        hx.nextNode = h1;
        app.handlerSet((XHandler)hx);
    }

    private static void do_runSev(XApp app) {
        TaskFactory.run((IJtTaskRunner)TaskRunner.g);
    }

    private static void do_weedTrack() {
        WeedConfig.onException((cmd, ex) -> {
            if (cmd.text.indexOf("a_log") < 0 && cmd.isLog >= 0) {
                System.out.println(cmd.text);
                LogUtil.log((String)"weed", (String)"err_log", (int)0, (String)"\u51fa\u9519", (String)(cmd.text + "<br/><br/>" + ExceptionUtils.getString((Throwable)ex)));
            }
        });
        WeedConfig.onExecuteAft(cmd -> {
            if (cmd.isLog < 0) {
                return;
            }
            if (cmd.timespan() > 1000L) {
                LogUtil.log((String)"weed", (String)"slow_log", (int)0, (String)(cmd.timespan() + "ms"), (String)cmd.text);
            }
        });
    }
}

