/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonjt.dso;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.solon.core.XContext;
import org.noear.solonjt.dso.AFileUtil;
import org.noear.solonjt.dso.AImageUtil;
import org.noear.solonjt.dso.DbUtil;
import org.noear.solonjt.dso.JtBridge;
import org.noear.solonjt.executor.ExecutorFactory;
import org.noear.solonjt.model.AConfigM;
import org.noear.solonjt.model.AFileModel;
import org.noear.solonjt.model.AImageModel;
import org.noear.solonjt.utils.Datetime;
import org.noear.solonjt.utils.EventPipeline;
import org.noear.solonjt.utils.TextUtils;
import org.noear.weed.DataItem;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;
import org.noear.weed.IQuery;
import org.noear.weed.cache.ICacheService;

public class DbApi {
    private static final EventPipeline<DataItem> logPipeline = new EventPipeline(list -> DbApi.logAll(list));

    private static DbContext db() {
        return DbUtil.db();
    }

    public static boolean fileNew(int fid, XContext ctx) throws Exception {
        DbTableQuery qr = DbApi.db().table("a_file").set("path", (Object)ctx.param("path", "")).set("tag", (Object)ctx.param("tag", "")).set("is_staticize", (Object)ctx.paramAsInt("is_staticize", 0)).set("is_editable", (Object)ctx.paramAsInt("is_editable", 0)).set("link_to", (Object)ctx.param("link_to", "")).set("edit_mode", (Object)ctx.param("edit_mode", "")).set("content_type", (Object)ctx.param("content_type", ""));
        if (fid > 0) {
            return ((DbTableQuery)qr.where("file_id=?", new Object[]{fid})).update() > 0;
        }
        return qr.insert() > 0L;
    }

    public static AFileModel fileGet(String path) throws Exception {
        return (AFileModel)((DbTableQuery)DbApi.db().table("a_file").where("path=?", new Object[]{path})).select("*").getItem(AFileModel.class);
    }

    public static List<AFileModel> fileGetPaths(String tag, String label, boolean isCache) throws Exception {
        if (TextUtils.isEmpty((String)tag) && TextUtils.isEmpty((String)label)) {
            return new ArrayList<AFileModel>();
        }
        return ((IQuery)((IQuery)((DbTableQuery)((DbTableQuery)DbApi.db().table("a_file").where("1=1", new Object[0])).build(tb -> {
            if (!TextUtils.isEmpty((String)tag)) {
                tb.and("tag=?", new Object[]{tag});
            }
            if (!TextUtils.isEmpty((String)label)) {
                tb.and("label=?", new Object[]{label});
            }
        })).select("path, note").caching((ICacheService)DbUtil.cache)).usingCache(isCache)).getList(AFileModel.class);
    }

    public static List<String> fileGetPathAll() throws Exception {
        return DbApi.db().table("a_file").select("path").getDataList().toArray(0);
    }

    public static boolean fileSet(int fid, String fcontent) throws Exception {
        if (fid < 1) {
            return false;
        }
        if (fcontent == null) {
            return false;
        }
        AFileModel fm = (AFileModel)((DbTableQuery)DbUtil.db().table("a_file").where("file_id=?", new Object[]{fid})).select("*").getItem(AFileModel.class);
        if (!fm.is_editable) {
            return false;
        }
        ((DbTableQuery)DbUtil.db().table("a_file").set("content", (Object)fcontent).set("update_fulltime", (Object)"$NOW()").where("file_id=?", new Object[]{fid})).update();
        String path2 = fm.path;
        String name = path2.replace("/", "__");
        AFileUtil.remove(path2);
        ExecutorFactory.del((String)name);
        return true;
    }

    public static List<AFileModel> fileFilters() throws Exception {
        return ((DbTableQuery)DbUtil.db().table("a_file").where("`label` = ?", new Object[]{"filter.file"})).select("path,note").getList(AFileModel.class);
    }

    public static List<AFileModel> pathFilters() throws Exception {
        return ((DbTableQuery)DbUtil.db().table("a_file").where("`label` = ?", new Object[]{"filter.path"})).select("path,note").getList(AFileModel.class);
    }

    public static AConfigM cfgGetMod(String name) throws Exception {
        if (name == null) {
            return null;
        }
        return (AConfigM)((IQuery)((IQuery)((DbTableQuery)DbApi.db().table("a_config").whereEq("name", (Object)name)).select("*").caching((ICacheService)DbUtil.cache)).cacheTag("cfg_" + name)).getItem(AConfigM.class);
    }

    public static Object cfgGetMap(Map<String, Object> map) throws Exception {
        Object name = map.get("name");
        if (name == null) {
            return null;
        }
        return ((IQuery)((IQuery)((DbTableQuery)DbApi.db().table("a_config").where("`name`=?", new Object[]{name})).select("*").caching((ICacheService)DbUtil.cache)).cacheTag("cfg_" + name)).getMap();
    }

    public static String cfgGet(String name) {
        return DbApi.cfgGet(name, "");
    }

    public static String cfgGet(String name, String def) {
        try {
            return (String)((IQuery)((IQuery)((DbTableQuery)DbApi.db().table("a_config").where("`name`=?", new Object[]{name})).select("value").caching((ICacheService)DbUtil.cache)).cacheTag("cfg_" + name)).getValue((Object)def);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static boolean cfgSet(String name, String value, String label) throws Exception {
        boolean is_ok = false;
        is_ok = ((DbTableQuery)DbApi.db().table("a_config").where("`name`=?", new Object[]{name})).exists() ? ((DbTableQuery)((DbTableQuery)DbApi.db().table("a_config").set("value", (Object)value).build(tb -> {
            if (label != null) {
                tb.set("label", (Object)label);
            }
        })).set("update_fulltime", (Object)"$NOW()").where("`name`=?", new Object[]{name})).update() > 0 : ((DbTableQuery)DbApi.db().table("a_config").set("name", (Object)name).set("value", (Object)value).build(tb -> {
            if (label != null) {
                tb.set("label", (Object)label);
            }
        })).insert() > 0L;
        DbUtil.cache.clear("cfg_" + name);
        return is_ok;
    }

    public static boolean cfgSetNote(String name, String note, String label) throws Exception {
        boolean is_ok = false;
        is_ok = ((DbTableQuery)DbApi.db().table("a_config").where("`name`=?", new Object[]{name})).exists() ? ((DbTableQuery)((DbTableQuery)DbApi.db().table("a_config").set("note", (Object)note).build(tb -> {
            if (label != null) {
                tb.set("label", (Object)label);
            }
        })).set("update_fulltime", (Object)"$NOW()").where("`name`=?", new Object[]{name})).update() > 0 : ((DbTableQuery)DbApi.db().table("a_config").set("name", (Object)name).set("note", (Object)note).set("create_fulltime", (Object)"$NOW()").set("update_fulltime", (Object)"$NOW()").build(tb -> {
            if (label != null) {
                tb.set("label", (Object)label);
            }
        })).insert() > 0L;
        DbUtil.cache.clear("cfg_" + name);
        return is_ok;
    }

    public static List<Map<String, Object>> menuGet(String label, int pid) throws SQLException {
        if (label.indexOf("%") >= 0) {
            return ((IQuery)((IQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)DbApi.db().table("a_menu").where("is_disabled=0", new Object[0])).andLk("label", label)).andIf(pid >= 0, "pid=?", new Object[]{pid})).orderBy("label ASC, order_number ASC")).select("*").caching((ICacheService)DbUtil.cache)).cacheTag("menu_" + label)).getMapList();
        }
        return ((IQuery)((IQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)((DbTableQuery)DbApi.db().table("a_menu").where("is_disabled=0", new Object[0])).andEq("label", (Object)label)).andIf(pid >= 0, "pid=?", new Object[]{pid})).orderBy("order_number ASC")).select("*").caching((ICacheService)DbUtil.cache)).cacheTag("menu_" + label)).getMapList();
    }

    public static AImageModel imgGet(String path) throws Exception {
        return (AImageModel)((IQuery)((IQuery)((DbTableQuery)DbApi.db().table("a_image").where("`path`=?", new Object[]{path})).select("*").caching((ICacheService)DbUtil.cache)).cacheTag("image_path_" + path)).getItem(AImageModel.class);
    }

    public static boolean imgSet(String tag, String path, String content_type, String data, String label) throws Exception {
        boolean is_ok = false;
        DbTableQuery qr = DbApi.db().table("a_image").set("`content_type`", (Object)content_type).set("`data`", (Object)data).set("`data_size`", (Object)data.length()).set("`label`", (Object)label).set("update_fulltime", (Object)"$NOW()");
        if (tag != null) {
            qr.set("`tag`", (Object)tag);
        }
        if (((DbTableQuery)DbApi.db().table("a_image").where("`path`=?", new Object[]{path})).exists()) {
            is_ok = ((DbTableQuery)qr.where("`path`=?", new Object[]{path})).update() > 0;
            AImageUtil.remove(path);
        } else {
            is_ok = qr.set("`path`", (Object)path).insert() > 0L;
        }
        return is_ok;
    }

    public static boolean imgUpd(String path, String data) throws Exception {
        boolean is_ok = ((DbTableQuery)DbApi.db().table("a_image").set("`data`", (Object)data).set("`data_size`", (Object)data.length()).set("update_fulltime", (Object)"$NOW()").where("`path`=?", new Object[]{path})).update() > 0;
        DbUtil.cache.clear("image_path_" + path);
        AImageUtil.remove(path);
        return is_ok;
    }

    public static boolean log(Map<String, Object> data) {
        Datetime datetime = Datetime.Now();
        DataItem dm = new DataItem();
        dm.setDf("tag", data.get("tag"), (Object)"");
        dm.setDf("tag1", data.get("tag1"), (Object)"");
        dm.setDf("tag2", data.get("tag2"), (Object)"");
        dm.setDf("tag3", data.get("tag3"), (Object)"");
        dm.setDf("tag4", data.get("tag4"), (Object)"");
        dm.setDf("summary", data.get("summary"), (Object)"");
        dm.setDf("content", data.get("content"), (Object)"");
        if (data.containsKey("from")) {
            dm.setDf("from", data.get("from"), (Object)"");
        } else {
            dm.setDf("from", (Object)JtBridge.nodeId(), (Object)"");
        }
        dm.setDf("level", data.get("level"), (Object)3);
        dm.set("log_date", (Object)datetime.getDate());
        dm.set("log_fulltime", (Object)datetime.getFulltime());
        logPipeline.add((Object)dm);
        return true;
    }

    public static void logAll(List<DataItem> list) {
        try {
            DbApi.db().table("a_log").insertList(list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

