/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonx.licence;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class LicenceHelper {
    private static final String ALGORITHM = "RSA";
    private static final String SIGN_ALGORITHM = "MD5withRSA";
    private static final String PUBLICK_KEY = "PUBLICK_KEY";
    private static final String PRIVATE_KEY = "PRIVATE_KEY";
    private static String CODE_SPLIT = "#";
    private static String CODE_SK = "3xv11BQB5hY%*X!V";
    private static final int KEY_SIZE = 512;

    public static Map<String, Object> genKeyPair() throws NoSuchAlgorithmException {
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        keyPairGenerator.initialize(512);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        keyMap.put(PUBLICK_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static String getPublicKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PUBLICK_KEY);
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static String getPrivateKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static String signToBase64(String data, String base64PrivateKey) throws Exception {
        byte[] tmp = LicenceHelper.sign(data.getBytes(StandardCharsets.UTF_8), base64PrivateKey);
        return Base64.getEncoder().encodeToString(tmp);
    }

    public static byte[] sign(byte[] data, String base64PrivateKey) throws Exception {
        PrivateKey privateKey = LicenceHelper.getPrivateKey(base64PrivateKey);
        Signature signature = Signature.getInstance(SIGN_ALGORITHM);
        signature.initSign(privateKey);
        signature.update(data);
        return signature.sign();
    }

    public static boolean signVerifyFromBase64(String data, String base64SignedData, String base64PublicKey) throws Exception {
        return LicenceHelper.signVerify(data.getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(base64SignedData), base64PublicKey);
    }

    public static boolean signVerify(byte[] data, byte[] signedData, String base64PublicKey) throws Exception {
        PublicKey publicKey = LicenceHelper.getPublicKey(base64PublicKey);
        Signature signature = Signature.getInstance(SIGN_ALGORITHM);
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(signedData);
    }

    public static PublicKey getPublicKey(String base64PublicKey) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(base64PublicKey.getBytes());
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyBytes));
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String base64PrivateKey) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(base64PrivateKey.getBytes());
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
        return privateKey;
    }

    public static String encode(String data, String key) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "AES");
        cipher.init(1, keySpec);
        byte[] encrypted = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public static String decode(String base64EncryptedData, String key) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "AES");
        cipher.init(2, keySpec);
        byte[] encrypted = Base64.getDecoder().decode(base64EncryptedData);
        byte[] decrypted = cipher.doFinal(encrypted);
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    public static String licenceEncode(String source, String base64PrivateKey) throws Exception {
        String signedSource = LicenceHelper.signToBase64(source, base64PrivateKey);
        return LicenceHelper.encode(source + CODE_SPLIT + signedSource, CODE_SK);
    }

    public static String licenceDecode(String encodedSource, String base64PublicKey) throws Exception {
        String licenceSource = LicenceHelper.decode(encodedSource, CODE_SK);
        String[] tmp = licenceSource.split(CODE_SPLIT);
        if (tmp.length == 2) {
            String source = tmp[0];
            String signedSource = tmp[1];
            if (LicenceHelper.signVerifyFromBase64(source, signedSource, base64PublicKey)) {
                return source;
            }
            throw new IllegalStateException("Invalid license signature");
        }
        throw new IllegalStateException("Invalid license");
    }
}

