/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solonx.licence;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solonx.licence.LicenceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenceInfo {
    private static final Logger log = LoggerFactory.getLogger(LicenceInfo.class);
    private static final String publicKey = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBALd9OL+RrIctvtzLdrLlHheSq4YwVRDNkDw0LPi9AFAD4V85Ruq92MfAdCyqiku8FHxhvxFa+pKRZoRl5ZJvJScCAwEAAQ==";
    private static LicenceInfo instance;
    private final String sn;
    private final String version;
    private final int edition;
    private final String editionName;
    private final boolean isValid;
    private final String description;

    public static LicenceInfo getInstance() {
        if (instance == null) {
            instance = new LicenceInfo();
        }
        return instance;
    }

    private LicenceInfo() {
        String snTmp = null;
        String versionTmp = null;
        int editionTmp = 0;
        String editionNameTmp = null;
        boolean isValidTmp = false;
        String descriptionTmp = null;
        try {
            String licenceStr;
            String[] licence;
            String appLicence = Solon.cfg().appLicence();
            if (Utils.isNotEmpty((String)appLicence) && (licence = (licenceStr = LicenceHelper.licenceDecode(appLicence, publicKey)).split(",")).length >= 7) {
                snTmp = licence[0];
                editionTmp = Integer.parseInt(licence[1]);
                versionTmp = licence[2];
                String start = licence[3];
                String month = licence[4];
                String consumer = licence[5];
                String project = licence[6];
                editionNameTmp = editionTmp == 23 ? "Enterprise Ultimate Edition" : (editionTmp == 22 ? "Enterprise Premium Edition" : (editionTmp == 21 ? "Enterprise Standard edition" : (editionTmp > 0 ? "Unknown Edition" : "Community Edition")));
                if (editionTmp > 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Noear Licence (for Solon-EE): \n");
                    buf.append("SN= ").append(snTmp).append("\n");
                    buf.append("E = ").append(editionNameTmp).append("\n");
                    buf.append("T = ").append(start).append(" (+").append(month).append("M)\n");
                    buf.append("C = ").append(consumer).append("\n");
                    buf.append("P = ").append(project).append("");
                    isValidTmp = true;
                    descriptionTmp = buf.toString();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (editionNameTmp == null) {
            editionNameTmp = "Community Edition";
        }
        if (descriptionTmp == null) {
            descriptionTmp = "\nLicence (for Solon-EE): Unauthorized (with legal risks)\n";
        }
        this.sn = snTmp;
        this.version = versionTmp;
        this.isValid = isValidTmp;
        this.description = descriptionTmp;
        this.edition = editionTmp;
        this.editionName = editionNameTmp;
    }

    public String getSn() {
        return this.sn;
    }

    public String getVersion() {
        return this.version;
    }

    public int getEdition() {
        return this.edition;
    }

    public String getEditionName() {
        return this.editionName;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getDescription() {
        return this.description;
    }

    public static void check() {
    }

    public static void print() {
        if (LicenceInfo.getInstance().isValid()) {
            log.info(LicenceInfo.getInstance().getDescription());
        } else {
            log.error(LicenceInfo.getInstance().getDescription());
        }
    }
}

