/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sqltoy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.VarHolder;
import org.noear.solon.extend.sqltoy.DbManager;
import org.noear.solon.extend.sqltoy.annotation.Db;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.dao.SqlToyLazyDao;
import org.sagacity.sqltoy.service.SqlToyCRUDService;

class DbInjector
implements BeanInjector<Db> {
    private static Map<DataSource, SqlToyLazyDao> daoMap = new ConcurrentHashMap<DataSource, SqlToyLazyDao>();
    private static Map<DataSource, SqlToyCRUDService> serviceMap = new ConcurrentHashMap<DataSource, SqlToyCRUDService>();

    DbInjector() {
    }

    public void doInject(VarHolder varH, Db anno) {
        String v = anno.value();
        if (v.equals("")) {
            varH.context().getWrapAsync(DataSource.class, bw -> this.inject((DataSource)bw.get(), varH));
        } else {
            varH.context().getWrapAsync((Object)v, bw -> this.inject((DataSource)bw.get(), varH));
        }
    }

    private void inject(DataSource dataSource, VarHolder varH) {
        Class type = varH.getType();
        if (type.equals(DataSource.class)) {
            varH.setValue((Object)dataSource);
            return;
        }
        varH.context().getWrapAsync(SqlToyContext.class, bw -> {
            if (type.equals(SqlToyLazyDao.class)) {
                varH.setValue((Object)DbManager.getDao(dataSource));
                return;
            }
            if (type.equals(SqlToyCRUDService.class)) {
                varH.setValue((Object)DbManager.getService(bw.context(), dataSource));
                return;
            }
            if (type.isInterface()) {
                varH.setValue(DbManager.getMapper(dataSource, type));
                return;
            }
        });
    }
}

