/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sqltoy;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.core.AopContext;
import org.noear.solon.extend.sqltoy.SqlToyCRUDServiceForSolon;
import org.noear.solon.extend.sqltoy.mapper.AbstractMapper;
import org.noear.solon.extend.sqltoy.mapper.ProxyClassBuilder;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.dao.SqlToyLazyDao;
import org.sagacity.sqltoy.dao.impl.SqlToyLazyDaoImpl;
import org.sagacity.sqltoy.service.SqlToyCRUDService;

public class DbManager {
    private static Map<DataSource, SqlToyLazyDao> daoMap = new HashMap<DataSource, SqlToyLazyDao>();
    private static Map<DataSource, SqlToyCRUDService> serviceMap = new HashMap<DataSource, SqlToyCRUDService>();
    private static Map<DataSource, Map<Class, Object>> mapperMap = new HashMap<DataSource, Map<Class, Object>>();
    private static Map<Class, Class> proxyClassMap = new HashMap<Class, Class>();
    private static SqlToyContext context;

    public static void setContext(SqlToyContext context) {
        DbManager.context = context;
    }

    public static synchronized SqlToyLazyDao getDao(DataSource dataSource) {
        SqlToyLazyDao dao = daoMap.get(dataSource);
        if (dao == null) {
            SqlToyLazyDaoImpl sqlToyLazyDao = new SqlToyLazyDaoImpl();
            sqlToyLazyDao.setDataSource(dataSource);
            sqlToyLazyDao.setSqlToyContext(context);
            daoMap.put(dataSource, (SqlToyLazyDao)sqlToyLazyDao);
            dao = sqlToyLazyDao;
        }
        return dao;
    }

    public static synchronized SqlToyCRUDService getService(AopContext context, DataSource dataSource) {
        Object service = serviceMap.get(dataSource);
        if (service == null) {
            SqlToyCRUDServiceForSolon crudService = (SqlToyCRUDServiceForSolon)((Object)context.beanMake(SqlToyCRUDServiceForSolon.class).get());
            crudService.setSqlToyLazyDao(DbManager.getDao(dataSource));
            serviceMap.put(dataSource, (SqlToyCRUDService)crudService);
            service = crudService;
        }
        return service;
    }

    public static synchronized <T> T getMapper(DataSource dataSource, Class<T> type) {
        Object mapper = null;
        Map<Class, Object> mapSubMap = mapperMap.get(dataSource);
        if (mapSubMap == null) {
            mapSubMap = new HashMap<Class, Object>();
            mapperMap.put(dataSource, mapSubMap);
        }
        if ((mapper = mapSubMap.get(type)) == null) {
            Class targetType = proxyClassMap.get(type);
            if (targetType == null) {
                ProxyClassBuilder cb = new ProxyClassBuilder(context, type);
                targetType = cb.compile();
                proxyClassMap.put(type, targetType);
            }
            try {
                AbstractMapper m = (AbstractMapper)targetType.newInstance();
                m.setDao(DbManager.getDao(dataSource));
                mapper = m;
                mapSubMap.put(type, mapper);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return (T)mapper;
    }

    public static Map<DataSource, SqlToyCRUDService> getServiceMap() {
        return serviceMap;
    }
}

