/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sqltoy;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.util.Arrays;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Props;

class SqlToyMongoInit {
    SqlToyMongoInit() {
    }

    public static void tryBuildMongoDbClient(AopContext context) {
        Class mongoClz = Utils.loadClass((ClassLoader)context.getClassLoader(), (String)"com.mongodb.client.MongoDatabase");
        if (mongoClz == null) {
            return;
        }
        MongoDatabase mongodb = (MongoDatabase)context.getBean(MongoDatabase.class);
        if (mongodb == null) {
            Props props = context.getProps().getProp("data.mongodb");
            if (props == null) {
                return;
            }
            MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
            builder.connectionsPerHost(props.getInt("connectionsPerHost", 10));
            builder.connectTimeout(props.getInt("connectTimeout", 5000));
            builder.socketTimeout(props.getInt("socketTimeout", 5000));
            ServerAddress address = new ServerAddress(props.get("host", "127.0.0.1"), props.getInt("port", 27017));
            String databaseName = props.get("database", "test");
            MongoClient client = null;
            if (props.contains((Object)"username")) {
                MongoCredential credential = MongoCredential.createCredential((String)props.get("username"), (String)databaseName, (char[])props.get("password", "").toCharArray());
                client = new MongoClient(address, Arrays.asList(credential), builder.build());
            } else {
                client = new MongoClient(address, builder.build());
            }
            MongoDatabase database = client.getDatabase(databaseName);
            context.wrapAndPut(MongoDatabase.class, (Object)database);
        }
    }
}

