/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sqltoy;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.noear.solon.extend.sqltoy.annotation.Sql;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dao.SqlToyLazyDao;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.QueryExecutor;

public class MapperUtil {
    private static Map<Class<?>, Object> _proxy_cache = new HashMap();
    private static Object _proxy_lock = new Object();
    private static final Set<Class> primitiveTypes = new HashSet<Class>(Arrays.asList(String.class, java.util.Date.class, Date.class, BigDecimal.class, BigInteger.class, Long.class, Integer.class, Byte.class, Double.class, Float.class, Character.class));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> T proxy(Class<T> mapperInf, SqlToyLazyDao dao) {
        Object tmp = _proxy_cache.get(mapperInf);
        if (tmp == null) {
            Object object = _proxy_lock;
            synchronized (object) {
                tmp = _proxy_cache.get(mapperInf);
                if (tmp == null) {
                    tmp = MapperUtil.buildProxy(mapperInf, dao);
                    _proxy_cache.put(mapperInf, tmp);
                }
            }
        }
        return (T)tmp;
    }

    private static <T> T buildProxy(Class<?> mapperInf, SqlToyLazyDao dao) {
        return (T)Proxy.newProxyInstance(mapperInf.getClassLoader(), new Class[]{mapperInf}, (InvocationHandler)new MapperHandler(dao, mapperInf));
    }

    private static Class getGenericType(Method method) {
        Type t = method.getGenericReturnType();
        if (t instanceof ParameterizedType) {
            ParameterizedType t1 = (ParameterizedType)method.getGenericReturnType();
            return (Class)t1.getActualTypeArguments()[0];
        }
        return null;
    }

    private static boolean isPrimitive(Class retType) {
        if (retType == null) {
            return false;
        }
        return retType.isPrimitive() || primitiveTypes.contains(retType);
    }

    static class MapperHandler
    implements InvocationHandler {
        protected MethodHandles.Lookup lookup;
        protected SqlToyLazyDao dao;
        protected Class<?> mapperClz;
        protected Map<Method, Invoker> invokers = new ConcurrentHashMap<Method, Invoker>();

        protected MapperHandler(SqlToyLazyDao dao, Class<?> mapperClz) {
            this.dao = dao;
            this.mapperClz = mapperClz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Invoker invoker = null;
            MapperHandler mapperHandler = this;
            synchronized (mapperHandler) {
                invoker = this.invokers.get(method);
                if (invoker == null) {
                    Class<?> caller = method.getDeclaringClass();
                    if (method.isDefault()) {
                        if (this.lookup == null) {
                            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                            constructor.setAccessible(true);
                            this.lookup = (MethodHandles.Lookup)constructor.newInstance(caller, 2);
                        }
                        invoker = this.lookup.unreflectSpecial(method, caller).bindTo(proxy)::invokeWithArguments;
                        this.invokers.put(method, invoker);
                    } else {
                        Sql sql = method.getAnnotation(Sql.class);
                        String sqlIdOrSql = method.getName();
                        if (sql != null) {
                            sqlIdOrSql = sql.value().trim();
                        }
                        SqlType sqlType = SqlType.search;
                        int spaceIndex = sqlIdOrSql.indexOf(" ");
                        if (spaceIndex == -1) {
                            SqlToyConfig cfg = this.dao.getSqlToyContext().getScriptLoader().getSqlConfig(sqlIdOrSql, null, "");
                            if (cfg == null) {
                                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5 sqlId \"" + sqlIdOrSql + "\" \u662f\u5426\u5b58\u5728!");
                            }
                            String rawSql = cfg.getSql();
                            spaceIndex = rawSql.indexOf(" ");
                            sqlType = SqlType.getSqlType((String)rawSql.substring(0, spaceIndex));
                        } else {
                            sqlType = SqlType.getSqlType((String)sqlIdOrSql.substring(0, spaceIndex));
                        }
                        Class<?> retType = method.getReturnType();
                        Class<?>[] paramTypes = method.getParameterTypes();
                        String sqlStr = sqlIdOrSql;
                        int _pageIdx = -1;
                        int _mapParamIdx = -1;
                        int _objIdx = -1;
                        int _listIdx = -1;
                        for (int i = 0; i < paramTypes.length; ++i) {
                            if (Page.class.isAssignableFrom(paramTypes[i])) {
                                _pageIdx = i;
                                continue;
                            }
                            if (Map.class.isAssignableFrom(paramTypes[i])) {
                                _mapParamIdx = i;
                                continue;
                            }
                            if (List.class.isAssignableFrom(paramTypes[i])) {
                                _listIdx = i;
                                continue;
                            }
                            _objIdx = i;
                        }
                        switch (sqlType) {
                            case search: {
                                int objIdx;
                                int mapParamIdx;
                                if (Page.class.isAssignableFrom(retType)) {
                                    int pageIdx = _pageIdx;
                                    int mapParamIdx2 = _mapParamIdx;
                                    int objIdx2 = _objIdx;
                                    Class<Map> entityType = MapperUtil.getGenericType(method);
                                    boolean primitive = MapperUtil.isPrimitive(entityType);
                                    if (entityType == null || primitive) {
                                        entityType = Map.class;
                                    }
                                    Class<Map> resultType = entityType;
                                    if (_objIdx > -1) {
                                        invoker = arg -> {
                                            Object queryEntity = arg[objIdx2];
                                            Page page = pageIdx > -1 ? (Page)arg[pageIdx] : new Page();
                                            QueryExecutor queryExecutor = queryEntity == null ? new QueryExecutor(sqlStr) : new QueryExecutor(sqlStr, (Serializable)queryEntity);
                                            queryExecutor.resultType((Type)((Object)resultType));
                                            Page result = this.dao.findPageByQuery(page, queryExecutor).getPageResult();
                                            if (primitive) {
                                                List rows = result.getRows();
                                                List distRows = rows.stream().map(it -> it.values().stream().findFirst().get()).collect(Collectors.toList());
                                                result.setRows(distRows);
                                            }
                                            return result;
                                        };
                                        break;
                                    }
                                    invoker = arg -> {
                                        Map queryMap;
                                        Map map = queryMap = mapParamIdx2 > -1 ? (Map)arg[mapParamIdx2] : new HashMap();
                                        if (queryMap == null) {
                                            queryMap = new HashMap();
                                        }
                                        Page page = pageIdx > -1 ? (Page)arg[pageIdx] : new Page();
                                        QueryExecutor queryExecutor = new QueryExecutor(sqlStr, queryMap);
                                        queryExecutor.resultType((Type)((Object)resultType));
                                        Page result = this.dao.findPageByQuery(page, queryExecutor).getPageResult();
                                        if (primitive) {
                                            List rows = result.getRows();
                                            List distRows = rows.stream().map(it -> it.values().stream().findFirst().get()).collect(Collectors.toList());
                                            result.setRows(distRows);
                                        }
                                        return result;
                                    };
                                    break;
                                }
                                if (List.class.isAssignableFrom(retType)) {
                                    mapParamIdx = _mapParamIdx;
                                    int objIdx3 = _objIdx;
                                    Class<Map> entityType = MapperUtil.getGenericType(method);
                                    boolean primitive = MapperUtil.isPrimitive(entityType);
                                    if (entityType == null || primitive) {
                                        entityType = Map.class;
                                    }
                                    Class<Map> resultType = entityType;
                                    if (_objIdx > -1) {
                                        invoker = arg -> {
                                            Object queryEntity = arg[objIdx3];
                                            QueryExecutor queryExecutor = queryEntity == null ? new QueryExecutor(sqlStr) : new QueryExecutor(sqlStr, (Serializable)queryEntity);
                                            queryExecutor.resultType((Type)((Object)resultType));
                                            if (primitive) {
                                                List result = this.dao.findByQuery(queryExecutor).getRows();
                                                return result.stream().map(it -> it.values().stream().findFirst().get()).collect(Collectors.toList());
                                            }
                                            return this.dao.findByQuery(queryExecutor).getRows();
                                        };
                                        break;
                                    }
                                    invoker = arg -> {
                                        Map queryMap;
                                        Map map = queryMap = mapParamIdx > -1 ? (Map)arg[mapParamIdx] : new HashMap();
                                        if (queryMap == null) {
                                            queryMap = new HashMap();
                                        }
                                        QueryExecutor queryExecutor = new QueryExecutor(sqlStr, queryMap).resultType((Type)((Object)resultType));
                                        if (primitive) {
                                            List result = this.dao.findByQuery(queryExecutor).getRows();
                                            return result.stream().map(it -> it.values().stream().findFirst().get()).collect(Collectors.toList());
                                        }
                                        return this.dao.findByQuery(queryExecutor).getRows();
                                    };
                                    break;
                                }
                                if (_objIdx > -1) {
                                    objIdx = _objIdx;
                                    invoker = arg -> {
                                        Object queryEntity = arg[objIdx];
                                        QueryExecutor queryExecutor = queryEntity == null ? new QueryExecutor(sqlStr) : new QueryExecutor(sqlStr, (Serializable)queryEntity);
                                        boolean isPrimitive = false;
                                        if (retType.isPrimitive() || String.class == retType || retType == java.util.Date.class) {
                                            isPrimitive = true;
                                            queryExecutor.resultType(Map.class);
                                        } else {
                                            queryExecutor.resultType((Type)retType);
                                        }
                                        List result = this.dao.findTopByQuery(queryExecutor, 1.0).getRows();
                                        if (result == null || result.size() == 0) {
                                            return null;
                                        }
                                        Object target = result.get(0);
                                        return isPrimitive ? ((Map)target).values().stream().findFirst().get() : target;
                                    };
                                    break;
                                }
                                mapParamIdx = _mapParamIdx;
                                invoker = arg -> {
                                    Map queryMap;
                                    Map map = queryMap = mapParamIdx > -1 ? (Map)arg[mapParamIdx] : new HashMap();
                                    if (queryMap == null) {
                                        queryMap = new HashMap();
                                    }
                                    QueryExecutor queryExecutor = new QueryExecutor(sqlStr, queryMap);
                                    boolean isPrimitive = false;
                                    if (retType.isPrimitive() || String.class == retType || retType == java.util.Date.class) {
                                        isPrimitive = true;
                                        queryExecutor.resultType(Map.class);
                                    } else {
                                        queryExecutor.resultType((Type)retType);
                                    }
                                    List result = this.dao.findTopByQuery(queryExecutor, 1.0).getRows();
                                    if (result == null || result.size() == 0) {
                                        return null;
                                    }
                                    Object target = result.get(0);
                                    return isPrimitive ? ((Map)target).values().stream().findFirst().get() : target;
                                };
                                break;
                            }
                            case insert: 
                            case delete: {
                                int objIdx;
                                if (_objIdx > -1) {
                                    objIdx = _objIdx;
                                    invoker = arg -> {
                                        Object entity = arg[objIdx];
                                        if (entity == null) {
                                            HashMap empty = new HashMap();
                                            return this.dao.executeSql(sqlStr, empty);
                                        }
                                        return this.dao.executeSql(sqlStr, (Serializable)entity);
                                    };
                                    break;
                                }
                                int mapParamIdx = _mapParamIdx;
                                invoker = arg -> {
                                    Map queryMap;
                                    Map map = queryMap = mapParamIdx > -1 ? (Map)arg[mapParamIdx] : new HashMap();
                                    if (queryMap == null) {
                                        queryMap = new HashMap();
                                    }
                                    return this.dao.executeSql(sqlStr, queryMap);
                                };
                                break;
                            }
                            case update: {
                                int objIdx;
                                if (_listIdx > -1) {
                                    int listIdx = _listIdx;
                                    invoker = arg -> {
                                        ArrayList params = (ArrayList)arg[listIdx];
                                        if (params == null) {
                                            params = new ArrayList();
                                        }
                                        return this.dao.batchUpdate(sqlStr, params);
                                    };
                                    break;
                                }
                                if (_objIdx > -1) {
                                    objIdx = _objIdx;
                                    invoker = arg -> {
                                        Object entity = arg[objIdx];
                                        if (entity == null) {
                                            HashMap empty = new HashMap();
                                            return this.dao.executeSql(sqlStr, empty);
                                        }
                                        return this.dao.executeSql(sqlStr, (Serializable)entity);
                                    };
                                    break;
                                }
                                int mapParamIdx = _mapParamIdx;
                                invoker = arg -> {
                                    Map queryMap;
                                    Map map = queryMap = mapParamIdx > -1 ? (Map)arg[mapParamIdx] : new HashMap();
                                    if (queryMap == null) {
                                        queryMap = new HashMap();
                                    }
                                    return this.dao.executeSql(sqlStr, queryMap);
                                };
                                break;
                            }
                            default: {
                                invoker = arg -> null;
                            }
                        }
                    }
                }
            }
            return invoker == null ? null : invoker.invoke(args);
        }
    }

    static interface Invoker {
        public Object invoke(Object[] var1) throws Throwable;
    }
}

