/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sqltoy;

import java.util.ArrayList;
import org.noear.solon.SolonApp;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.Plugin;
import org.noear.solon.extend.sqltoy.MapperCreator;
import org.noear.solon.extend.sqltoy.SqlToyCRUDServiceForSolon;
import org.noear.solon.extend.sqltoy.annotation.Mapper;
import org.noear.solon.extend.sqltoy.configure.Elastic;
import org.noear.solon.extend.sqltoy.configure.ElasticConfig;
import org.noear.solon.extend.sqltoy.configure.SqlToyContextProperties;
import org.noear.solon.extend.sqltoy.configure.SqltoyConfiguration;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.dao.SqlToyLazyDao;
import org.sagacity.sqltoy.dao.impl.SqlToyLazyDaoImpl;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.plugins.TypeHandler;
import org.sagacity.sqltoy.plugins.datasource.ConnectionFactory;
import org.sagacity.sqltoy.plugins.datasource.DataSourceSelector;
import org.sagacity.sqltoy.service.SqlToyCRUDService;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;
import org.sagacity.sqltoy.utils.StringUtil;
import org.springframework.context.ApplicationContext;

public class XPluginImp
implements Plugin {
    public void start(SolonApp app) {
        app.beanScan(SqltoyConfiguration.class);
        ApplicationContext applicationContext = new ApplicationContext(){};
        SqlToyContextProperties properties = (SqlToyContextProperties)app.cfg().getBean("sqltoy", SqlToyContextProperties.class);
        if (app.cfg().isDebugMode()) {
            properties.setDebug(true);
        }
        try {
            SqlToyContext sqlToyContext = this.sqlToyContext(properties);
            sqlToyContext.setApplicationContext(applicationContext);
            sqlToyContext.initialize();
            Aop.wrapAndPut(SqlToyContext.class, (Object)sqlToyContext);
            SqlToyLazyDaoImpl sqlToyLazyDao = new SqlToyLazyDaoImpl();
            sqlToyLazyDao.setSqlToyContext(sqlToyContext);
            Aop.wrapAndPut(SqlToyLazyDao.class, (Object)sqlToyLazyDao);
            SqlToyCRUDService service = (SqlToyCRUDService)Aop.getOrNew(SqlToyCRUDServiceForSolon.class);
            Aop.wrapAndPut(SqlToyCRUDService.class, (Object)service);
            Aop.context().beanBuilderAdd(Mapper.class, (BeanBuilder)new MapperCreator());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void prestop() throws Throwable {
        SqlToyContext sqlToyContext = (SqlToyContext)Aop.get(SqlToyContext.class);
        sqlToyContext.destroy();
    }

    public SqlToyContext sqlToyContext(SqlToyContextProperties properties) throws Exception {
        String connectionFactory;
        String dataSourceSelector;
        String typeHandler;
        String translateCacheManager;
        Elastic es;
        if (StringUtil.isBlank((Object)properties.getSqlResourcesDir())) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5sqltoy\u914d\u7f6e!\n\u8303\u4f8b: sqltoy.sqlResourcesDir=classpath:com/sagframe/modules");
        }
        SqlToyContext sqlToyContext = new SqlToyContext();
        sqlToyContext.setBreakWhenSqlRepeat(properties.isBreakWhenSqlRepeat());
        sqlToyContext.setSqlResourcesDir(properties.getSqlResourcesDir());
        if (properties.getSqlResources() != null && properties.getSqlResources().length > 0) {
            ArrayList<String> resList = new ArrayList<String>();
            for (String prop : properties.getSqlResources()) {
                resList.add(prop);
            }
            sqlToyContext.setSqlResources(resList);
        }
        if (properties.getEncoding() != null) {
            sqlToyContext.setEncoding(properties.getEncoding());
        }
        if (properties.getPackagesToScan() != null) {
            sqlToyContext.setPackagesToScan(properties.getPackagesToScan());
        }
        if (properties.getAnnotatedClasses() != null) {
            sqlToyContext.setAnnotatedClasses(properties.getAnnotatedClasses());
        }
        if (properties.getBatchSize() != null) {
            sqlToyContext.setBatchSize(properties.getBatchSize().intValue());
        }
        if (properties.getFetchSize() > 0) {
            sqlToyContext.setFetchSize(properties.getFetchSize());
        }
        if (properties.getPageFetchSizeLimit() != null) {
            sqlToyContext.setPageFetchSizeLimit(properties.getPageFetchSizeLimit().intValue());
        }
        if (properties.getScriptCheckIntervalSeconds() != null) {
            sqlToyContext.setScriptCheckIntervalSeconds(properties.getScriptCheckIntervalSeconds().intValue());
        }
        if (properties.getDelayCheckSeconds() != null) {
            sqlToyContext.setDelayCheckSeconds(properties.getDelayCheckSeconds().intValue());
        }
        if (properties.getDebug() != null) {
            sqlToyContext.setDebug(properties.getDebug().booleanValue());
        }
        if (properties.getPrintSqlTimeoutMillis() != null) {
            sqlToyContext.setPrintSqlTimeoutMillis(properties.getPrintSqlTimeoutMillis().intValue());
        }
        if (properties.getFunctionConverts() != null) {
            sqlToyContext.setFunctionConverts(properties.getFunctionConverts());
        }
        if (properties.getTranslateConfig() != null) {
            sqlToyContext.setTranslateConfig(properties.getTranslateConfig());
        }
        if (properties.getReservedWords() != null) {
            sqlToyContext.setReservedWords(properties.getReservedWords());
        }
        sqlToyContext.setPageOverToFirst(properties.isPageOverToFirst());
        sqlToyContext.setDialect(properties.getDialect());
        sqlToyContext.setDialectConfig(properties.getDialectConfig());
        sqlToyContext.setCacheType(properties.getCacheType());
        String unfiyHandler = properties.getUnifyFieldsHandler();
        if (StringUtil.isNotBlank((Object)unfiyHandler)) {
            try {
                IUnifyFieldsHandler handler = null;
                if (unfiyHandler.contains(".")) {
                    handler = (IUnifyFieldsHandler)Class.forName(unfiyHandler).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else if (Aop.has((Object)unfiyHandler) && (handler = (IUnifyFieldsHandler)Aop.get((String)unfiyHandler)) == null) {
                    throw new ClassNotFoundException("\u9879\u76ee\u4e2d\u672a\u5b9a\u4e49unifyFieldsHandler=" + unfiyHandler + " \u5bf9\u5e94\u7684bean!");
                }
                if (handler != null) {
                    sqlToyContext.setUnifyFieldsHandler(handler);
                }
            }
            catch (ClassNotFoundException cne) {
                System.err.println("------------------- \u9519\u8bef\u63d0\u793a ------------------------------------------- ");
                System.err.println("spring.sqltoy.unifyFieldsHandler=" + unfiyHandler + " \u5bf9\u5e94\u7c7b\u4e0d\u5b58\u5728,\u9519\u8bef\u539f\u56e0:");
                System.err.println("--1.\u60a8\u53ef\u80fd\u76f4\u63a5copy\u4e86\u53c2\u7167\u9879\u76ee\u7684\u914d\u7f6e\u6587\u4ef6,\u4f46\u6ca1\u6709\u5c06\u5177\u4f53\u7684\u7c7b\u4e5f\u540c\u6b65copy\u8fc7\u6765!");
                System.err.println("--2.\u5982\u60a8\u5e76\u4e0d\u9700\u8981\u6b64\u529f\u80fd\uff0c\u8bf7\u5c06\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ce8\u91ca\u6389spring.sqltoy.unifyFieldsHandler");
                System.err.println("------------------------------------------------");
                cne.printStackTrace();
                throw cne;
            }
        }
        if ((es = properties.getElastic()) != null && es.getEndpoints() != null && !es.getEndpoints().isEmpty()) {
            sqlToyContext.setDefaultElastic(es.getDefaultId());
            ArrayList<ElasticEndpoint> endpoints = new ArrayList<ElasticEndpoint>();
            for (ElasticConfig esconfig : es.getEndpoints()) {
                ElasticEndpoint ep = new ElasticEndpoint(esconfig.getUrl(), esconfig.getSqlPath());
                ep.setId(esconfig.getId());
                if (esconfig.getCharset() != null) {
                    ep.setCharset(esconfig.getCharset());
                }
                if (esconfig.getRequestTimeout() != null) {
                    ep.setRequestTimeout(esconfig.getRequestTimeout().intValue());
                }
                if (esconfig.getConnectTimeout() != null) {
                    ep.setConnectTimeout(esconfig.getConnectTimeout().intValue());
                }
                if (esconfig.getSocketTimeout() != null) {
                    ep.setSocketTimeout(esconfig.getSocketTimeout().intValue());
                }
                ep.setAuthCaching(esconfig.isAuthCaching());
                ep.setUsername(esconfig.getUsername());
                ep.setPassword(esconfig.getPassword());
                ep.setKeyStore(esconfig.getKeyStore());
                ep.setKeyStorePass(esconfig.getKeyStorePass());
                ep.setKeyStoreSelfSign(esconfig.isKeyStoreSelfSign());
                ep.setKeyStoreType(esconfig.getKeyStoreType());
                endpoints.add(ep);
            }
            sqlToyContext.setElasticEndpoints(endpoints);
        }
        if (properties.getDefaultDataSource() != null) {
            sqlToyContext.setDefaultDataSourceName(properties.getDefaultDataSource());
        }
        if (StringUtil.isNotBlank((Object)(translateCacheManager = properties.getTranslateCacheManager()))) {
            if (Aop.has((Object)translateCacheManager)) {
                sqlToyContext.setTranslateCacheManager((TranslateCacheManager)Aop.get((String)translateCacheManager));
            } else if (translateCacheManager.contains(".")) {
                sqlToyContext.setTranslateCacheManager((TranslateCacheManager)Class.forName(translateCacheManager).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(typeHandler = properties.getTypeHandler()))) {
            if (Aop.has((Object)typeHandler)) {
                sqlToyContext.setTypeHandler((TypeHandler)Aop.get((String)typeHandler));
            } else if (typeHandler.contains(".")) {
                sqlToyContext.setTypeHandler((TypeHandler)Class.forName(typeHandler).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(dataSourceSelector = properties.getDataSourceSelector()))) {
            if (Aop.has((Object)dataSourceSelector)) {
                sqlToyContext.setDataSourceSelector((DataSourceSelector)Aop.get((String)dataSourceSelector));
            } else if (dataSourceSelector.contains(".")) {
                sqlToyContext.setDataSourceSelector((DataSourceSelector)Class.forName(dataSourceSelector).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(connectionFactory = properties.getConnectionFactory()))) {
            if (Aop.has((Object)connectionFactory)) {
                sqlToyContext.setConnectionFactory((ConnectionFactory)Aop.get((String)connectionFactory));
            } else if (connectionFactory.contains(".")) {
                sqlToyContext.setConnectionFactory((ConnectionFactory)Class.forName(connectionFactory).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        return sqlToyContext;
    }
}

