/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sqltoy;

import java.util.ArrayList;
import org.noear.solon.SolonApp;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Plugin;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.extend.sqltoy.DbInjector;
import org.noear.solon.extend.sqltoy.DbManager;
import org.noear.solon.extend.sqltoy.annotation.Db;
import org.noear.solon.extend.sqltoy.configure.Elastic;
import org.noear.solon.extend.sqltoy.configure.ElasticConfig;
import org.noear.solon.extend.sqltoy.configure.SqlToyContextProperties;
import org.noear.solon.extend.sqltoy.translate.SolonTranslateCacheManager;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.plugins.TypeHandler;
import org.sagacity.sqltoy.plugins.datasource.ConnectionFactory;
import org.sagacity.sqltoy.plugins.datasource.DataSourceSelector;
import org.sagacity.sqltoy.plugins.secure.DesensitizeProvider;
import org.sagacity.sqltoy.plugins.secure.FieldsSecureProvider;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;
import org.sagacity.sqltoy.utils.StringUtil;
import org.springframework.context.ApplicationContext;

public class XPluginImp
implements Plugin {
    public void start(SolonApp app) {
        ApplicationContext applicationContext = new ApplicationContext(){};
        SqlToyContextProperties properties = (SqlToyContextProperties)app.cfg().getBean("sqltoy", SqlToyContextProperties.class);
        if (properties == null) {
            properties = new SqlToyContextProperties();
        }
        if (app.cfg().isDebugMode()) {
            properties.setDebug(true);
        }
        try {
            SqlToyContext sqlToyContext = this.sqlToyContext(properties, applicationContext);
            if ("solon".equals(properties.getCacheType()) || properties.getCacheType() == null) {
                Aop.getAsyn(CacheService.class, bw -> {
                    sqlToyContext.setTranslateCacheManager((TranslateCacheManager)new SolonTranslateCacheManager((CacheService)bw.get()));
                    try {
                        DbManager.setContext(sqlToyContext);
                        this.initSqlToy(sqlToyContext);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            } else {
                DbManager.setContext(sqlToyContext);
                this.initSqlToy(sqlToyContext);
            }
            Aop.context().beanInjectorAdd(Db.class, (BeanInjector)new DbInjector());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initSqlToy(SqlToyContext sqlToyContext) throws Exception {
        sqlToyContext.initialize();
        Aop.wrapAndPut(SqlToyContext.class, (Object)sqlToyContext);
    }

    public void prestop() throws Throwable {
        SqlToyContext sqlToyContext = (SqlToyContext)Aop.get(SqlToyContext.class);
        sqlToyContext.destroy();
    }

    public SqlToyContext sqlToyContext(SqlToyContextProperties properties, ApplicationContext applicationContext) throws Exception {
        String desensitizeProvider;
        String fieldsSecureProvider;
        String connectionFactory;
        String dataSourceSelector;
        String typeHandler;
        String translateCacheManager;
        Elastic es;
        if (StringUtil.isBlank((Object)properties.getSqlResourcesDir())) {
            properties.setSqlResourcesDir("classpath:sqltoy");
        }
        SqlToyContext sqlToyContext = new SqlToyContext();
        sqlToyContext.setBreakWhenSqlRepeat(properties.isBreakWhenSqlRepeat());
        sqlToyContext.setSqlResourcesDir(properties.getSqlResourcesDir());
        if (properties.getSqlResources() != null && properties.getSqlResources().length > 0) {
            ArrayList<String> resList = new ArrayList<String>();
            for (String prop : properties.getSqlResources()) {
                resList.add(prop);
            }
            sqlToyContext.setSqlResources(resList);
        }
        if (properties.getEncoding() != null) {
            sqlToyContext.setEncoding(properties.getEncoding());
        }
        if (properties.getPackagesToScan() != null) {
            sqlToyContext.setPackagesToScan(properties.getPackagesToScan());
        }
        if (properties.getAnnotatedClasses() != null) {
            sqlToyContext.setAnnotatedClasses(properties.getAnnotatedClasses());
        }
        if (properties.getBatchSize() != null) {
            sqlToyContext.setBatchSize(properties.getBatchSize().intValue());
        }
        if (properties.getFetchSize() > 0) {
            sqlToyContext.setFetchSize(properties.getFetchSize());
        }
        if (properties.getPageFetchSizeLimit() != null) {
            sqlToyContext.setPageFetchSizeLimit(properties.getPageFetchSizeLimit().intValue());
        }
        if (properties.getScriptCheckIntervalSeconds() != null) {
            sqlToyContext.setScriptCheckIntervalSeconds(properties.getScriptCheckIntervalSeconds().intValue());
        }
        if (properties.getDelayCheckSeconds() != null) {
            sqlToyContext.setDelayCheckSeconds(properties.getDelayCheckSeconds().intValue());
        }
        if (properties.getDebug() != null) {
            sqlToyContext.setDebug(properties.getDebug().booleanValue());
        }
        if (properties.getPrintSqlTimeoutMillis() != null) {
            sqlToyContext.setPrintSqlTimeoutMillis(properties.getPrintSqlTimeoutMillis().intValue());
        }
        if (properties.getFunctionConverts() != null) {
            sqlToyContext.setFunctionConverts(properties.getFunctionConverts());
        }
        if (properties.getTranslateConfig() != null) {
            sqlToyContext.setTranslateConfig(properties.getTranslateConfig());
        }
        if (properties.getReservedWords() != null) {
            sqlToyContext.setReservedWords(properties.getReservedWords());
        }
        sqlToyContext.setPageOverToFirst(properties.isPageOverToFirst());
        sqlToyContext.setDialect(properties.getDialect());
        sqlToyContext.setDialectConfig(properties.getDialectConfig());
        sqlToyContext.setCacheType(properties.getCacheType());
        sqlToyContext.setSecurePrivateKey(properties.getSecurePrivateKey());
        sqlToyContext.setSecurePublicKey(properties.getSecurePublicKey());
        String unfiyHandler = properties.getUnifyFieldsHandler();
        if (StringUtil.isNotBlank((Object)unfiyHandler)) {
            try {
                IUnifyFieldsHandler handler = null;
                if (unfiyHandler.contains(".")) {
                    handler = (IUnifyFieldsHandler)Class.forName(unfiyHandler).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else if (Aop.has((Object)unfiyHandler) && (handler = (IUnifyFieldsHandler)Aop.get((String)unfiyHandler)) == null) {
                    throw new ClassNotFoundException("\u9879\u76ee\u4e2d\u672a\u5b9a\u4e49unifyFieldsHandler=" + unfiyHandler + " \u5bf9\u5e94\u7684bean!");
                }
                if (handler != null) {
                    sqlToyContext.setUnifyFieldsHandler(handler);
                }
            }
            catch (ClassNotFoundException cne) {
                System.err.println("------------------- \u9519\u8bef\u63d0\u793a ------------------------------------------- ");
                System.err.println("sqltoy.unifyFieldsHandler=" + unfiyHandler + " \u5bf9\u5e94\u7c7b\u4e0d\u5b58\u5728,\u9519\u8bef\u539f\u56e0:");
                System.err.println("--1.\u60a8\u53ef\u80fd\u76f4\u63a5copy\u4e86\u53c2\u7167\u9879\u76ee\u7684\u914d\u7f6e\u6587\u4ef6,\u4f46\u6ca1\u6709\u5c06\u5177\u4f53\u7684\u7c7b\u4e5f\u540c\u6b65copy\u8fc7\u6765!");
                System.err.println("--2.\u5982\u60a8\u5e76\u4e0d\u9700\u8981\u6b64\u529f\u80fd\uff0c\u8bf7\u5c06\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ce8\u91ca\u6389sqltoy.unifyFieldsHandler");
                System.err.println("------------------------------------------------");
                cne.printStackTrace();
                throw cne;
            }
        }
        if ((es = properties.getElastic()) != null && es.getEndpoints() != null && !es.getEndpoints().isEmpty()) {
            sqlToyContext.setDefaultElastic(es.getDefaultId());
            ArrayList<ElasticEndpoint> endpoints = new ArrayList<ElasticEndpoint>();
            for (ElasticConfig esconfig : es.getEndpoints()) {
                ElasticEndpoint ep = new ElasticEndpoint(esconfig.getUrl(), esconfig.getSqlPath());
                ep.setId(esconfig.getId());
                if (esconfig.getCharset() != null) {
                    ep.setCharset(esconfig.getCharset());
                }
                if (esconfig.getRequestTimeout() != null) {
                    ep.setRequestTimeout(esconfig.getRequestTimeout().intValue());
                }
                if (esconfig.getConnectTimeout() != null) {
                    ep.setConnectTimeout(esconfig.getConnectTimeout().intValue());
                }
                if (esconfig.getSocketTimeout() != null) {
                    ep.setSocketTimeout(esconfig.getSocketTimeout().intValue());
                }
                ep.setAuthCaching(esconfig.isAuthCaching());
                ep.setUsername(esconfig.getUsername());
                ep.setPassword(esconfig.getPassword());
                ep.setKeyStore(esconfig.getKeyStore());
                ep.setKeyStorePass(esconfig.getKeyStorePass());
                ep.setKeyStoreSelfSign(esconfig.isKeyStoreSelfSign());
                ep.setKeyStoreType(esconfig.getKeyStoreType());
                endpoints.add(ep);
            }
            sqlToyContext.setElasticEndpoints(endpoints);
        }
        if (properties.getDefaultDataSource() != null) {
            sqlToyContext.setDefaultDataSourceName(properties.getDefaultDataSource());
        }
        if (StringUtil.isNotBlank((Object)(translateCacheManager = properties.getTranslateCacheManager()))) {
            if (Aop.has((Object)translateCacheManager)) {
                sqlToyContext.setTranslateCacheManager((TranslateCacheManager)Aop.get((String)translateCacheManager));
            } else if (translateCacheManager.contains(".")) {
                sqlToyContext.setTranslateCacheManager((TranslateCacheManager)Class.forName(translateCacheManager).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(typeHandler = properties.getTypeHandler()))) {
            if (Aop.has((Object)typeHandler)) {
                sqlToyContext.setTypeHandler((TypeHandler)Aop.get((String)typeHandler));
            } else if (typeHandler.contains(".")) {
                sqlToyContext.setTypeHandler((TypeHandler)Class.forName(typeHandler).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(dataSourceSelector = properties.getDataSourceSelector()))) {
            if (Aop.has((Object)dataSourceSelector)) {
                sqlToyContext.setDataSourceSelector((DataSourceSelector)Aop.get((String)dataSourceSelector));
            } else if (dataSourceSelector.contains(".")) {
                sqlToyContext.setDataSourceSelector((DataSourceSelector)Class.forName(dataSourceSelector).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(connectionFactory = properties.getConnectionFactory()))) {
            if (Aop.has((Object)connectionFactory)) {
                sqlToyContext.setConnectionFactory((ConnectionFactory)Aop.get((String)connectionFactory));
            } else if (connectionFactory.contains(".")) {
                sqlToyContext.setConnectionFactory((ConnectionFactory)Class.forName(connectionFactory).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(fieldsSecureProvider = properties.getFieldsSecureProvider()))) {
            if (applicationContext.containsBean(fieldsSecureProvider)) {
                sqlToyContext.setFieldsSecureProvider((FieldsSecureProvider)applicationContext.getBean(fieldsSecureProvider));
            } else if (fieldsSecureProvider.contains(".")) {
                sqlToyContext.setFieldsSecureProvider((FieldsSecureProvider)Class.forName(fieldsSecureProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(desensitizeProvider = properties.getDesensitizeProvider()))) {
            if (applicationContext.containsBean(desensitizeProvider)) {
                sqlToyContext.setDesensitizeProvider((DesensitizeProvider)applicationContext.getBean(desensitizeProvider));
            } else if (desensitizeProvider.contains(".")) {
                sqlToyContext.setDesensitizeProvider((DesensitizeProvider)Class.forName(desensitizeProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        sqlToyContext.setApplicationContext(applicationContext);
        return sqlToyContext;
    }
}

