/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sqltoy.mapper;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.liquor.DynamicCompiler;
import org.noear.solon.extend.sqltoy.annotation.Param;
import org.noear.solon.extend.sqltoy.annotation.Sql;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.utils.StringUtil;

public class ProxyClassBuilder {
    private String packageName = "org.sagacity.sqltoy.solon.impl";
    private String className;
    private StringBuilder source = new StringBuilder();
    private Class type;
    private SqlToyContext context;
    private static final Set<Class> primitiveTypes = new HashSet<Class>(Arrays.asList(String.class, java.util.Date.class, Date.class, BigDecimal.class, BigInteger.class, Long.class, Long.TYPE, Integer.class, Integer.TYPE, Byte.class, Byte.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Character.class, Character.TYPE, Boolean.class, Boolean.TYPE));

    public ProxyClassBuilder(SqlToyContext context, Class type) {
        this.type = type;
        String name = type.getName().replaceAll("\\.", "_") + "Impl";
        this.className = StringUtil.toHumpStr((String)name, (boolean)true, (boolean)true);
        this.context = context;
        this.buildSource();
    }

    private void buildSource() {
        String prefix = String.format("package %s;", this.packageName);
        this.source.append(prefix);
        this.source.append("import org.sagacity.sqltoy.model.*;");
        this.source.append("import java.util.*;");
        this.source.append("import java.util.stream.Collectors;");
        this.source.append("@SuppressWarnings(\"unchecked\")");
        this.source.append("public class " + this.className);
        this.source.append(" extends org.noear.solon.extend.sqltoy.mapper.AbstractMapper");
        this.source.append(" implements " + this.type.getName() + "{");
        for (Method method : this.type.getDeclaredMethods()) {
            if (method.isDefault()) continue;
            this.buildMethod(method);
        }
        this.source.append("}");
    }

    public String getSource() {
        return this.source.toString();
    }

    private void buildMethod(Method method) {
        boolean hasNamedParams;
        this.source.append("public ");
        Class<?> retType = method.getReturnType();
        boolean retVoid = false;
        if (Void.TYPE.equals(retType)) {
            this.source.append("void");
            retVoid = true;
        } else {
            this.source.append(method.getReturnType().getName());
        }
        this.source.append(" ");
        this.source.append(method.getName());
        this.source.append("(");
        boolean first = true;
        for (Parameter p : method.getParameters()) {
            if (first) {
                first = false;
            } else {
                this.source.append(",");
            }
            this.source.append(p.toString());
        }
        this.source.append("){");
        Sql sql = method.getAnnotation(Sql.class);
        String sqlIdOrSql = method.getName();
        if (sql != null) {
            sqlIdOrSql = sql.value().trim();
        }
        SqlType sqlType = SqlType.search;
        int spaceIndex = sqlIdOrSql.indexOf(" ");
        if (spaceIndex == -1) {
            try {
                SqlToyConfig cfg = this.context.getScriptLoader().getSqlConfig(sqlIdOrSql, null, "");
                if (cfg == null) {
                    throw new IllegalArgumentException("\u8bf7\u68c0\u67e5 sqlId \"" + sqlIdOrSql + "\" \u662f\u5426\u5b58\u5728!");
                }
                String rawSql = cfg.getSql();
                spaceIndex = rawSql.indexOf(" ");
                sqlType = SqlType.getSqlType((String)rawSql.substring(0, spaceIndex));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5 sqlId \"" + sqlIdOrSql + "\" \u662f\u5426\u5b58\u5728!");
            }
        } else {
            sqlType = SqlType.getSqlType((String)sqlIdOrSql.substring(0, spaceIndex));
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        Parameter[] methodParameters = method.getParameters();
        int _pageIdx = -1;
        int _mapParamIdx = -1;
        int _objIdx = -1;
        int _listIdx = -1;
        HashMap<String, Integer> namedParamIdxMap = new HashMap<String, Integer>();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (Page.class.isAssignableFrom(paramType)) {
                _pageIdx = i;
            } else if (Map.class.isAssignableFrom(paramType)) {
                _mapParamIdx = i;
            } else if (List.class.isAssignableFrom(paramType)) {
                _listIdx = i;
            } else {
                _objIdx = i;
            }
            Param param = methodParameters[i].getAnnotation(Param.class);
            if (param == null) continue;
            String paramName = param.value();
            if (StringUtil.isBlank((Object)paramName)) {
                paramName = methodParameters[i].getName();
            }
            namedParamIdxMap.put(paramName, i);
        }
        boolean bl = hasNamedParams = namedParamIdxMap.size() > 0;
        if (hasNamedParams) {
            _objIdx = -1;
            _mapParamIdx = -1;
        }
        if (_objIdx > -1 && !Serializable.class.isAssignableFrom(paramTypes[_objIdx])) {
            throw new IllegalArgumentException(this.type.getName() + "#" + method.getName() + "\u4e2d\u53c2\u6570:" + methodParameters[_objIdx].getName() + "\u5e94\u4e3aSerializable\uff01");
        }
        this.source.append("String _sql=\"" + sqlIdOrSql + "\";");
        switch (sqlType) {
            case search: {
                String qeName;
                if (Page.class.isAssignableFrom(retType)) {
                    String pageParam;
                    int pageIdx = _pageIdx;
                    int mapParamIdx = _mapParamIdx;
                    int objIdx = _objIdx;
                    Class<Map> entityType = ProxyClassBuilder.getGenericType(method);
                    boolean primitive = ProxyClassBuilder.isPrimitive(entityType);
                    if (entityType == null || primitive) {
                        entityType = Map.class;
                    }
                    Class<Map> resultType = entityType;
                    String string = pageParam = pageIdx > -1 ? methodParameters[pageIdx].getName() : "new Page()";
                    if (_objIdx > -1) {
                        String qeName2 = methodParameters[objIdx].getName();
                        this.source.append("QueryExecutor queryExecutor=" + qeName2 + "==null?new QueryExecutor(_sql):new QueryExecutor(_sql," + qeName2 + ");");
                        this.source.append("queryExecutor.resultType(" + resultType.getName() + ".class);");
                        this.source.append("Page _result = dao.findPageByQuery(" + pageParam + ",queryExecutor).getPageResult();");
                        if (primitive) {
                            this.appendPagePrimitive(entityType);
                        }
                        this.source.append("return _result;");
                        break;
                    }
                    String mp = mapParamIdx > -1 ? methodParameters[mapParamIdx].getName() : "new HashMap<>();";
                    this.source.append(" Map<String, Object> _queryMap = " + mp);
                    if (hasNamedParams) {
                        for (String k : namedParamIdxMap.keySet()) {
                            this.source.append("_queryMap.put(\"" + k + "\"," + k + ");");
                        }
                    }
                    this.source.append(" QueryExecutor queryExecutor = new QueryExecutor(_sql, _queryMap);");
                    this.source.append(" queryExecutor.resultType(" + resultType.getName() + ".class);");
                    this.source.append(" Page _result = dao.findPageByQuery(" + pageParam + ", queryExecutor).getPageResult();");
                    if (primitive) {
                        this.appendPagePrimitive(entityType);
                    }
                    this.source.append("return _result;");
                    break;
                }
                if (List.class.isAssignableFrom(retType)) {
                    int mapParamIdx = _mapParamIdx;
                    int objIdx = _objIdx;
                    Class<Map> entityType = ProxyClassBuilder.getGenericType(method);
                    boolean primitive = ProxyClassBuilder.isPrimitive(entityType);
                    if (entityType == null || primitive) {
                        entityType = Map.class;
                    }
                    Class<Map> resultType = entityType;
                    if (_objIdx > -1) {
                        String qeName3 = methodParameters[objIdx].getName();
                        this.source.append("QueryExecutor queryExecutor=" + qeName3 + "==null?new QueryExecutor(_sql):new QueryExecutor(_sql," + qeName3 + ");");
                        this.source.append("queryExecutor.resultType(" + resultType.getName() + ".class);");
                        if (primitive) {
                            this.source.append("List<Map> _result = dao.findByQuery(queryExecutor).getRows();");
                            this.source.append("return _result.stream().map(it ->_cast(it.values().stream().findFirst().get()," + entityType.getName() + ".class)).collect(Collectors.toList());");
                            break;
                        }
                        this.source.append("return dao.findByQuery(queryExecutor).getRows();");
                        break;
                    }
                    String mp = mapParamIdx > -1 ? methodParameters[mapParamIdx].getName() : "new HashMap<>();";
                    this.source.append(" Map<String, Object> _queryMap = " + mp);
                    if (hasNamedParams) {
                        for (String k : namedParamIdxMap.keySet()) {
                            this.source.append("_queryMap.put(\"" + k + "\"," + k + ");");
                        }
                    }
                    this.source.append("QueryExecutor queryExecutor = new QueryExecutor(_sql, _queryMap).resultType(" + resultType.getName() + ".class);");
                    if (primitive) {
                        this.source.append("List<Map> _result = dao.findByQuery(queryExecutor).getRows();");
                        this.source.append("return _result.stream().map(it -> it.values().stream().findFirst().get()).collect(Collectors.toList());");
                        break;
                    }
                    this.source.append("return dao.findByQuery(queryExecutor).getRows();");
                    break;
                }
                if (_objIdx > -1) {
                    int objIdx = _objIdx;
                    qeName = methodParameters[objIdx].getName();
                    this.source.append("QueryExecutor queryExecutor=" + qeName + "==null?new QueryExecutor(_sql):new QueryExecutor(_sql," + qeName + ");");
                    boolean isPrimitive = ProxyClassBuilder.isPrimitive(retType);
                    if (isPrimitive) {
                        this.source.append(" queryExecutor.resultType(Map.class);");
                    } else {
                        this.source.append("queryExecutor.resultType(" + retType.getName() + ".class);");
                    }
                    this.source.append(" List _result = dao.findByQuery(queryExecutor).getRows();");
                    this.source.append(" if (_result == null || _result.size() == 0){return _cast(null," + retType.getName() + ".class);}");
                    this.source.append("Object _target = _result.get(0);");
                    if (isPrimitive) {
                        this.source.append("return _cast(((Map) _target).values().stream().findFirst().get()," + retType.getName() + ".class);");
                        break;
                    }
                    this.source.append("return (" + retType.getName() + ")_target;");
                    break;
                }
                int mapParamIdx = _mapParamIdx;
                String mp = mapParamIdx > -1 ? methodParameters[mapParamIdx].getName() : "new HashMap<>();";
                this.source.append(" Map<String, Object> _queryMap = " + mp);
                if (hasNamedParams) {
                    for (String k : namedParamIdxMap.keySet()) {
                        this.source.append("_queryMap.put(\"" + k + "\"," + k + ");");
                    }
                }
                this.source.append("QueryExecutor queryExecutor = new QueryExecutor(_sql,_queryMap);");
                boolean isPrimitive = ProxyClassBuilder.isPrimitive(retType);
                if (isPrimitive) {
                    this.source.append("queryExecutor.resultType(Map.class);");
                } else {
                    this.source.append(" queryExecutor.resultType(" + retType.getName() + ".class);");
                }
                this.source.append("List _result = dao.findByQuery(queryExecutor).getRows();");
                this.source.append(" if (_result == null || _result.size() == 0){return _cast(null," + retType.getName() + ".class);}");
                this.source.append("Object _target = _result.get(0);");
                if (isPrimitive) {
                    this.source.append("return _cast(((Map) _target).values().stream().findFirst().get()," + retType.getName() + ".class);");
                    break;
                }
                this.source.append("return (" + retType.getName() + ")_target;");
                break;
            }
            case insert: 
            case delete: {
                String qeName;
                if (_objIdx > -1) {
                    int objIdx = _objIdx;
                    qeName = methodParameters[objIdx].getName();
                    this.source.append(this.convertLongReturnType("dao.executeSql(_sql," + qeName + ")", retType));
                    break;
                }
                int mapParamIdx = _mapParamIdx;
                String mp = mapParamIdx > -1 ? methodParameters[mapParamIdx].getName() : "new HashMap<>();";
                this.source.append(" Map<String, Object> _queryMap = " + mp);
                if (hasNamedParams) {
                    for (String k : namedParamIdxMap.keySet()) {
                        this.source.append("_queryMap.put(\"" + k + "\"," + k + ");");
                    }
                }
                this.source.append(this.convertLongReturnType("dao.executeSql(_sql,_queryMap)", retType));
                break;
            }
            case update: {
                String lName;
                if (_listIdx > -1 && sql.batch()) {
                    int listIdx = _listIdx;
                    lName = methodParameters[listIdx].getName();
                    this.source.append(this.convertLongReturnType("dao.batchUpdate(_sql," + lName + ")", retType));
                    break;
                }
                if (_objIdx > -1) {
                    int objIdx = _objIdx;
                    lName = methodParameters[objIdx].getName();
                    this.source.append(this.convertLongReturnType("dao.executeSql(_sql," + lName + ")", retType));
                    break;
                }
                int mapParamIdx = _mapParamIdx;
                String mp = mapParamIdx > -1 ? methodParameters[mapParamIdx].getName() : "new HashMap<>();";
                this.source.append(" Map<String, Object> _queryMap = " + mp);
                if (hasNamedParams) {
                    for (String k : namedParamIdxMap.keySet()) {
                        this.source.append("_queryMap.put(\"" + k + "\"," + k + ");");
                    }
                }
                this.source.append(this.convertLongReturnType("dao.executeSql(_sql,_queryMap)", retType));
                break;
            }
            default: {
                this.source.append("return null;");
            }
        }
        this.source.append("}");
    }

    private String convertLongReturnType(String ret, Class toType) {
        if (Boolean.class == toType || Boolean.TYPE == toType) {
            return "return " + ret + ">=1;";
        }
        if (Integer.class == toType || Integer.TYPE == toType) {
            return "return " + ret + ".intValue();";
        }
        if (Void.class == toType || Void.TYPE == toType) {
            return ret + ";";
        }
        return "return " + ret + ";";
    }

    private void appendPagePrimitive(Class entityType) {
        this.source.append("List<Map> _rows = _result.getRows();");
        this.source.append("List _distRows = _rows.stream().map(it -> _cast(it.values().stream().findFirst().get()," + entityType.getName() + ".class).collect(Collectors.toList());");
        this.source.append("_result.setRows(_distRows);");
    }

    public Class compile() {
        String fullName = String.format("%s.%s", this.packageName, this.className);
        DynamicCompiler compiler = new DynamicCompiler();
        compiler.addSource(fullName, this.source.toString());
        Map classMap = compiler.build();
        return (Class)classMap.get(fullName);
    }

    private static Class getGenericType(Method method) {
        Type t = method.getGenericReturnType();
        if (t instanceof ParameterizedType) {
            ParameterizedType t1 = (ParameterizedType)method.getGenericReturnType();
            return (Class)t1.getActualTypeArguments()[0];
        }
        return null;
    }

    protected static boolean isPrimitive(Class retType) {
        if (retType == null) {
            return false;
        }
        return retType.isPrimitive() || primitiveTypes.contains(retType);
    }
}

