/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sqltoy;

import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.extend.sqltoy.DbInjector;
import org.noear.solon.extend.sqltoy.DbManager;
import org.noear.solon.extend.sqltoy.SqlToyContextBuilder;
import org.noear.solon.extend.sqltoy.annotation.Db;
import org.noear.solon.extend.sqltoy.configure.SqlToyContextProperties;
import org.noear.solon.extend.sqltoy.translate.SolonTranslateCacheManager;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;

public class XPluginImp
implements Plugin {
    AopContext context;

    public void start(AopContext context) {
        this.context = context;
        SqlToyContextProperties properties = (SqlToyContextProperties)context.cfg().getBean("sqltoy", SqlToyContextProperties.class);
        if (properties == null) {
            properties = new SqlToyContextProperties();
        }
        if (Solon.cfg().isDebugMode()) {
            properties.setDebug(true);
        }
        try {
            SqlToyContext sqlToyContext = new SqlToyContextBuilder(properties, context).build();
            if ("solon".equals(properties.getCacheType()) || properties.getCacheType() == null) {
                context.getWrapAsync(CacheService.class, bw -> {
                    sqlToyContext.setTranslateCacheManager((TranslateCacheManager)new SolonTranslateCacheManager((CacheService)bw.get()));
                    try {
                        DbManager.setContext(sqlToyContext);
                        this.initSqlToy(sqlToyContext);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            } else {
                DbManager.setContext(sqlToyContext);
                this.initSqlToy(sqlToyContext);
            }
            context.beanInjectorAdd(Db.class, (BeanInjector)new DbInjector());
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
        }
    }

    private void initSqlToy(SqlToyContext sqlToyContext) throws Exception {
        sqlToyContext.initialize();
        this.context.wrapAndPut(SqlToyContext.class, (Object)sqlToyContext);
    }

    public void stop() throws Throwable {
        SqlToyContext sqlToyContext = (SqlToyContext)this.context.getBean(SqlToyContext.class);
        sqlToyContext.destroy();
    }
}

