/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.solon.integration;

import java.util.Date;
import org.noear.redisx.RedisClient;
import org.noear.redisx.plus.RedisAtomic;
import org.sagacity.sqltoy.integration.AppContext;
import org.sagacity.sqltoy.integration.DistributeIdGenerator;

public class SolonRedisIdGenerator
implements DistributeIdGenerator {
    private static final String GLOBAL_ID_PREFIX = "SQLTOY_GL_ID:";
    private RedisClient client;

    public long generateId(String key, int increment, Date expireTime) {
        String realKey = GLOBAL_ID_PREFIX.concat(key);
        RedisAtomic atomic = this.client.getAtomic(GLOBAL_ID_PREFIX.concat(key));
        if (expireTime != null) {
            this.client.open(s -> s.jedis().pexpireAt(realKey, expireTime.getTime()));
        }
        if (increment < 1) {
            return atomic.increment();
        }
        return atomic.incrementBy((long)increment);
    }

    public void initialize(AppContext appContext) {
        this.client = (RedisClient)appContext.getBean(RedisClient.class);
    }
}

