/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.solon.integration;

import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Plugin;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.extend.sqltoy.annotation.DbInjectorOld;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.solon.DbManager;
import org.sagacity.sqltoy.solon.annotation.Db;
import org.sagacity.sqltoy.solon.configure.SqlToyContextProperties;
import org.sagacity.sqltoy.solon.integration.SolonAppContext;
import org.sagacity.sqltoy.solon.integration.SqlToyContextBuilder;
import org.sagacity.sqltoy.solon.integration.SqlToyDbInjector;
import org.sagacity.sqltoy.solon.translate.cache.impl.SolonTranslateCacheManager;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;

public class SqlToyPluginImpl
implements Plugin {
    AppContext context;

    public void start(AppContext context) throws Throwable {
        this.context = context;
        SqlToyContextProperties properties = (SqlToyContextProperties)context.cfg().getBean("solon.sqltoy", SqlToyContextProperties.class);
        if (properties == null) {
            properties = (SqlToyContextProperties)context.cfg().getBean("sqltoy", SqlToyContextProperties.class);
        }
        if (properties == null) {
            properties = new SqlToyContextProperties();
        }
        if (Solon.cfg().isDebugMode()) {
            properties.setDebug(true);
        }
        SolonAppContext solonAppContext = new SolonAppContext(context);
        SqlToyContext sqlToyContext = new SqlToyContextBuilder(properties, solonAppContext).build();
        if ("solon".equals(properties.getCacheType()) || properties.getCacheType() == null) {
            context.getWrapAsync(CacheService.class, bw -> {
                sqlToyContext.setTranslateCacheManager((TranslateCacheManager)new SolonTranslateCacheManager((CacheService)bw.get()));
                try {
                    DbManager.setContext(sqlToyContext);
                    this.initSqlToy(sqlToyContext);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else {
            DbManager.setContext(sqlToyContext);
            this.initSqlToy(sqlToyContext);
        }
        context.beanInjectorAdd(Db.class, (BeanInjector)new SqlToyDbInjector());
        context.beanInjectorAdd(org.noear.solon.extend.sqltoy.annotation.Db.class, (BeanInjector)new DbInjectorOld());
    }

    private void initSqlToy(SqlToyContext sqlToyContext) throws Exception {
        sqlToyContext.initialize();
        this.context.wrapAndPut(SqlToyContext.class, (Object)sqlToyContext);
    }

    public void stop() throws Throwable {
        SqlToyContext sqlToyContext = (SqlToyContext)this.context.getBean(SqlToyContext.class);
        sqlToyContext.destroy();
    }
}

