/*
 * Decompiled with CFR 0.152.
 */
package org.noear.srww.base;

import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Context;
import org.noear.solon.extend.validation.ValidatorManager;
import org.noear.solon.extend.validation.annotation.NoRepeatLock;
import org.noear.solon.extend.validation.annotation.WhitelistChecker;
import org.noear.solon.logging.utils.TagsMDC;
import org.noear.srww.base.validation.NoRepeatLockNew;
import org.noear.srww.base.validation.WhitelistCheckerNew;
import org.noear.water.WaterClient;
import org.noear.water.utils.TextUtils;
import org.noear.weed.WeedConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPluginImp
implements Plugin {
    static Logger log = LoggerFactory.getLogger(XPluginImp.class);
    boolean isDebugMode;
    boolean isWeedStyle2;
    boolean isTrackEnable;
    boolean isErrorLogEnable;

    public void start(SolonApp app) {
        ValidatorManager.setNoRepeatLock((NoRepeatLock)new NoRepeatLockNew());
        ValidatorManager.setWhitelistChecker((WhitelistChecker)new WhitelistCheckerNew());
        Utils.loadClass((String)"com.mysql.jdbc.Driver");
        Utils.loadClass((String)"com.mysql.cj.jdbc.Driver");
        this.isDebugMode = Solon.cfg().isDebugMode() || Solon.cfg().isFilesMode();
        String style = Solon.cfg().get("srww.weed.print.style");
        this.isWeedStyle2 = "sql".equals(style);
        this.isTrackEnable = Solon.cfg().getBool("srww.weed.track.enable", true);
        this.isErrorLogEnable = Solon.cfg().getBool("srww.weed.error.log.enable", true);
        this.initWeed();
    }

    protected void initWeed() {
        Class bcfClz = Utils.loadClass((String)"org.noear.bcf.BcfClient");
        if (bcfClz == null) {
            this.initWeedForApi();
        } else {
            this.initWeedForAdmin();
        }
        WeedConfig.onException((cmd, err) -> {
            TagsMDC.tag0((String)"weed");
            if (this.isErrorLogEnable) {
                if (cmd == null) {
                    log.error("::Error= {}", err);
                } else {
                    log.error("::Sql= {}\n::Args= {}\n\n::Error= {}", new Object[]{cmd.text, ONode.stringify((Object)cmd.paramMap()), err});
                }
            } else if (cmd == null) {
                log.debug("::Error= {}", err);
            } else {
                log.debug("::Sql= {}\n::Args= {}\n\n::Error= {}", new Object[]{cmd.text, ONode.stringify((Object)cmd.paramMap()), err});
            }
        });
    }

    private void initWeedForApi() {
        WeedConfig.onExecuteAft(cmd -> {
            if (this.isDebugMode) {
                if (this.isWeedStyle2) {
                    log.debug(cmd.toSqlString());
                } else {
                    log.debug(cmd.text + "\r\n" + ONode.stringify((Object)cmd.paramMap()));
                }
            }
            WaterClient.Track.track(this.service_name(), cmd, 1000L);
            if (this.isTrackEnable) {
                String tag = cmd.context.schema();
                if (TextUtils.isEmpty((CharSequence)tag)) {
                    tag = "sql";
                }
                CloudClient.metric().addMeter(this.service_name() + "_sql", tag, cmd.text, cmd.timespan(), true);
            }
        });
    }

    private void initWeedForAdmin() {
        WeedConfig.onExecuteAft(cmd -> {
            if (this.isDebugMode) {
                if (this.isWeedStyle2) {
                    log.debug(cmd.toSqlString());
                } else {
                    log.debug(cmd.text + "\r\n" + ONode.stringify((Object)cmd.paramMap()));
                }
            }
            if (cmd.isLog < 0) {
                return;
            }
            Context ctx = Context.current();
            String user_name = this.user_name(ctx);
            int user_puid = this.user_puid(ctx);
            String sqlUp = cmd.text.toUpperCase();
            String chkUp = "User_Id=? AND Pass_Wd=? AND Is_Disabled=0".toUpperCase();
            if (cmd.timespan() > 2000L || cmd.isLog > 0 || sqlUp.indexOf("INSERT INTO ") >= 0 || sqlUp.indexOf("UPDATE ") >= 0 || sqlUp.indexOf("DELETE ") >= 0 || sqlUp.indexOf(chkUp) >= 0) {
                WaterClient.Track.track(this.service_name(), cmd, ctx.userAgent(), ctx.pathNew(), user_puid + "." + user_name, ctx.realIp());
            }
            if (this.isTrackEnable) {
                String tag = cmd.context.schema();
                if (TextUtils.isEmpty((CharSequence)tag)) {
                    tag = "sql";
                }
                CloudClient.metric().addMeter(this.service_name() + "_sql", tag, cmd.text, cmd.timespan(), true);
            }
        });
    }

    public String service_name() {
        return Solon.cfg().appName();
    }

    public int user_puid(Context ctx) {
        if (ctx != null) {
            String tmp = (String)ctx.attr("user_puid", (Object)"0");
            return Integer.parseInt(tmp);
        }
        return 0;
    }

    public String user_name(Context ctx) {
        if (ctx != null) {
            return (String)ctx.attr("user_name", null);
        }
        return null;
    }
}

