/*
 * Decompiled with CFR 0.152.
 */
package org.noear.srww.base;

import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Context;
import org.noear.water.WaterClient;
import org.noear.water.utils.IPUtils;
import org.noear.weed.WeedConfig;

public class XPluginImp
implements Plugin {
    boolean isDebugMode;
    boolean isWeedStyle2;

    public void start(SolonApp app) {
        this.isDebugMode = Solon.cfg().isDebugMode() || Solon.cfg().isFilesMode();
        String style = Solon.cfg().get("srww.weed.print.style");
        this.isWeedStyle2 = "sql".equals(style);
        this.initWeed();
    }

    protected void initWeed() {
        Class bcfClz = Utils.loadClass((String)"org.noear.bcf.BcfClient");
        if (bcfClz == null) {
            this.initWeedForApi();
        } else {
            this.initWeedForAdmin();
        }
    }

    private void initWeedForApi() {
        WeedConfig.onExecuteAft(cmd -> {
            if (this.isDebugMode) {
                if (this.isWeedStyle2) {
                    System.out.println(cmd.toSqlString());
                } else {
                    System.out.println(cmd.text + "\n" + ONode.stringify((Object)cmd.paramMap()));
                }
            }
            WaterClient.Track.track(Solon.cfg().appName(), cmd, 1000L);
        });
    }

    private void initWeedForAdmin() {
        WeedConfig.onExecuteAft(cmd -> {
            if (this.isDebugMode) {
                if (this.isWeedStyle2) {
                    System.out.println(cmd.toSqlString());
                } else {
                    System.out.println(cmd.text + "\n" + ONode.stringify((Object)cmd.paramMap()));
                }
            }
            if (cmd.isLog < 0) {
                return;
            }
            Context ctx = Context.current();
            String user_name = this.user_name(ctx);
            int user_puid = this.user_puid(ctx);
            if (user_name == null) {
                return;
            }
            String sqlUp = cmd.text.toUpperCase();
            String chkUp = "User_Id=? AND Pass_Wd=? AND Is_Disabled=0".toUpperCase();
            if (cmd.timespan() > 2000L || cmd.isLog > 0 || sqlUp.indexOf("INSERT INTO ") >= 0 || sqlUp.indexOf("UPDATE ") >= 0 || sqlUp.indexOf("DELETE ") >= 0 || sqlUp.indexOf(chkUp) >= 0) {
                WaterClient.Track.track(this.service_name(), cmd, ctx.userAgent(), ctx.path(), user_puid + "." + user_name, IPUtils.getIP((Context)ctx));
            }
        });
    }

    public String service_name() {
        return Solon.cfg().appName();
    }

    public int user_puid(Context ctx) {
        if (ctx != null) {
            String tmp = (String)ctx.attr("user_puid", (Object)"0");
            return Integer.parseInt(tmp);
        }
        return 0;
    }

    public String user_name(Context ctx) {
        if (ctx != null) {
            return (String)ctx.attr("user_name", null);
        }
        return null;
    }
}

