/*
 * Decompiled with CFR 0.152.
 */
package org.noear.srww.base.interceptor;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudEventInterceptor;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.logging.utils.TagsMDC;
import org.noear.water.utils.Timecount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEventInterceptor
implements CloudEventInterceptor {
    static Logger log = LoggerFactory.getLogger(BaseEventInterceptor.class);

    public boolean doIntercept(Event event, CloudEventHandler handler) throws Throwable {
        TagsMDC.tag0((String)"event");
        TagsMDC.tag1((String)event.topic());
        if (Utils.isNotEmpty((String)event.tags())) {
            TagsMDC.tag2((String)event.tags());
        }
        TagsMDC.tag3((String)event.key());
        Timecount timecount = new Timecount().start();
        long timespan = 0L;
        try {
            boolean succeeded = handler.handle(event);
            timespan = timecount.stop().milliseconds();
            if (succeeded) {
                log.info("Event execution succeeded @{}ms", (Object)timespan);
                boolean bl = true;
                return bl;
            }
            log.warn("Event execution failed @{}ms", (Object)timespan);
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            timespan = timecount.stop().milliseconds();
            log.error("Event execution error @{}ms: {}", (Object)timespan, (Object)e);
            throw e;
        }
        finally {
            if (timespan > 0L) {
                CloudClient.metric().addMeter(Solon.cfg().appName(), "event", event.topic(), timespan);
            }
        }
    }
}

