/*
 * Decompiled with CFR 0.152.
 */
package org.noear.srww.base;

import org.noear.nami.NamiAttachment;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Context;
import org.noear.solon.logging.utils.TagsMDC;
import org.noear.solon.validation.ValidatorManager;
import org.noear.solon.validation.annotation.NoRepeatSubmitChecker;
import org.noear.solon.validation.annotation.WhitelistChecker;
import org.noear.srww.base.SrwwConfig;
import org.noear.srww.base.validation.NoRepeatSubmitCheckerNew;
import org.noear.srww.base.validation.WhitelistCheckerNew;
import org.noear.water.WaterClient;
import org.noear.water.utils.TextUtils;
import org.noear.weed.WeedConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class XPluginImp
implements Plugin {
    static final String clzGritClient = "org.noear.grit.client.GritClient";
    static Logger log = LoggerFactory.getLogger(XPluginImp.class);
    boolean isDebugMode;
    boolean isWeedStyle2;
    boolean isTrackEnable;
    boolean isErrorLogEnable;

    public void start(AopContext context) {
        ValidatorManager.setNoRepeatSubmitChecker((NoRepeatSubmitChecker)new NoRepeatSubmitCheckerNew());
        ValidatorManager.setWhitelistChecker((WhitelistChecker)new WhitelistCheckerNew());
        Utils.loadClass((String)"com.mysql.jdbc.Driver");
        Utils.loadClass((String)"com.mysql.cj.jdbc.Driver");
        this.isDebugMode = Solon.cfg().isDebugMode() || Solon.cfg().isFilesMode();
        this.isWeedStyle2 = "sql".equals(SrwwConfig.weedPrintStyle());
        this.isTrackEnable = SrwwConfig.weedTrackEnable(this.isDebugMode);
        this.isErrorLogEnable = SrwwConfig.weedErrorLogEnable();
        this.initWeed();
        Solon.global().filter(Integer.MIN_VALUE, (ctx, chain) -> {
            try {
                chain.doFilter(ctx);
            }
            finally {
                MDC.clear();
                NamiAttachment.clear();
            }
        });
    }

    protected void initWeed() {
        Class bcfClz = Utils.loadClass((String)clzGritClient);
        if (bcfClz == null) {
            this.initWeedForApi();
        } else {
            this.initWeedForAdmin();
        }
        WeedConfig.onException((cmd, err) -> {
            TagsMDC.tag0((String)"weed");
            if (this.isErrorLogEnable) {
                if (cmd == null) {
                    log.error("::Error= {}", err);
                } else {
                    log.error("::Sql= {}\n::Args= {}\n\n::Error= {}", new Object[]{cmd.text, ONode.stringify((Object)cmd.paramMap()), err});
                }
            } else if (cmd == null) {
                log.debug("::Error= {}", err);
            } else {
                log.debug("::Sql= {}\n::Args= {}\n\n::Error= {}", new Object[]{cmd.text, ONode.stringify((Object)cmd.paramMap()), err});
            }
        });
    }

    private void initWeedForApi() {
        WeedConfig.onExecuteAft(cmd -> {
            if (this.isDebugMode) {
                if (this.isWeedStyle2) {
                    log.debug(cmd.toSqlString());
                } else {
                    log.debug(cmd.text + "\r\n" + ONode.stringify((Object)cmd.paramMap()));
                }
            }
            WaterClient.Track.trackOfPerformance(Solon.cfg().appName(), cmd, 1000L);
            if (this.isTrackEnable) {
                String tag = cmd.context.schema();
                if (TextUtils.isEmpty((CharSequence)tag)) {
                    tag = "sql";
                }
                CloudClient.metric().addMeter(Solon.cfg().appName() + "_sql", tag, cmd.text, cmd.timespan());
            }
        });
    }

    private void initWeedForAdmin() {
        WeedConfig.onExecuteAft(cmd -> {
            if (this.isDebugMode) {
                if (this.isWeedStyle2) {
                    log.debug(cmd.toSqlString());
                } else {
                    log.debug(cmd.text + "\r\n" + ONode.stringify((Object)cmd.paramMap()));
                }
            }
            if (cmd.isLog < 0) {
                return;
            }
            Context ctx = Context.current();
            if (ctx == null) {
                return;
            }
            String sqlUp = cmd.text.toUpperCase();
            if (cmd.timespan() > 2000L || cmd.isLog > 0 || sqlUp.contains("INSERT INTO ") || sqlUp.contains("UPDATE ") || sqlUp.contains("DELETE ")) {
                String userDisplayName = this.getUserDisplayName(ctx);
                String userId = this.getUserId(ctx);
                WaterClient.Track.trackOfBehavior(Solon.cfg().appName(), cmd, ctx.userAgent(), ctx.pathNew(), userId + "." + userDisplayName, ctx.realIp());
            }
            if (this.isTrackEnable) {
                String tag = cmd.context.schema();
                if (TextUtils.isEmpty((CharSequence)tag)) {
                    tag = "sql";
                }
                CloudClient.metric().addMeter(Solon.cfg().appName() + "_sql", tag, cmd.text, cmd.timespan());
            }
        });
    }

    public String getUserId(Context ctx) {
        return (String)ctx.attr("user_id", (Object)"0");
    }

    public String getUserDisplayName(Context ctx) {
        if (ctx != null) {
            return (String)ctx.attr("user_display_name", null);
        }
        return null;
    }
}

