/*
 * Decompiled with CFR 0.152.
 */
package org.noear.srww.uadmin.controller;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.noear.bcf.BcfClient;
import org.noear.bcf.BcfUtil;
import org.noear.bcf.models.BcfResourceModel;
import org.noear.bcf.models.BcfUserModel;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.srww.uadmin.controller.BaseController;
import org.noear.srww.uadmin.dso.Session;
import org.noear.water.utils.ImageUtils;
import org.noear.water.utils.RandomUtils;
import org.noear.water.utils.TextUtils;

@Controller
public class LoginController
extends BaseController {
    @Mapping(value="login")
    public ModelAndView login() {
        return this.view("login");
    }

    @Mapping(value="/")
    public void index() {
        this.redirect("/login");
    }

    @Mapping(value="/login/auto")
    public void login_auto() throws Exception {
        String def_url;
        int puid = Session.current().getPUID();
        if (puid > 0 && !Utils.isEmpty((String)(def_url = BcfClient.getUserFirstResource((int)puid).uri_path))) {
            this.redirect(def_url);
            return;
        }
        this.redirect("/login");
    }

    @Mapping(value="/login/ajax/check")
    public ModelAndView login_ajax_check(String userName, String passWord, String captcha) throws Exception {
        if (!captcha.toLowerCase().equals(Session.current().getValidation())) {
            return this.viewModel.set("code", 0).set("msg", "\u63d0\u793a\uff1a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        if (TextUtils.isEmpty((CharSequence)userName) || TextUtils.isEmpty((CharSequence)passWord)) {
            return this.viewModel.set("code", 0).set("msg", "\u63d0\u793a\uff1a\u8bf7\u8f93\u5165\u8d26\u53f7\u548c\u5bc6\u7801\uff01");
        }
        BcfUserModel user = BcfClient.login((String)userName, (String)passWord);
        if (user.puid == 0) {
            return this.viewModel.set("code", 0).set("msg", "\u63d0\u793a\uff1a\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u5bf9\uff01");
        }
        Session.current().loadModel(user);
        BcfResourceModel res = BcfClient.getUserFirstResource((int)user.puid);
        String def_url = null;
        if (TextUtils.isEmpty((CharSequence)res.uri_path)) {
            return this.viewModel.set("code", 0).set("msg", "\u63d0\u793a\uff1a\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5f00\u901a\u6743\u9650");
        }
        def_url = BcfUtil.buildBcfUnipath((BcfResourceModel)res);
        return this.viewModel.set("code", 1).set("msg", "ok").set("url", def_url);
    }

    @Mapping(value="/login/validation/img", method={MethodType.GET}, produces="image/jpeg")
    public void getValidationImg(Context ctx) throws IOException {
        String validation = RandomUtils.code((int)4);
        Session.current().setValidation(validation);
        BufferedImage bufferedImage = ImageUtils.getValidationImage((String)validation);
        ctx.headerSet("Pragma", "no-cache");
        ctx.headerSet("Cache-Control", "no-cache");
        ctx.headerSet("Expires", "0");
        ImageIO.setUseCache(false);
        ImageIO.write((RenderedImage)bufferedImage, "jpeg", ctx.outputStream());
    }
}

