/*
 * Decompiled with CFR 0.152.
 */
package org.noear.srww.uadmin.widget;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.noear.bcf.BcfClient;
import org.noear.bcf.BcfUtil;
import org.noear.bcf.models.BcfGroupModel;
import org.noear.bcf.models.BcfResourceModel;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Component;
import org.noear.solon.core.handle.Context;
import org.noear.srww.uadmin.dso.Session;

@Component(value="view:header")
public class HeaderTag
implements TemplateDirectiveModel {
    public void execute(Environment env, Map map, TemplateModel[] templateModels, TemplateDirectiveBody body) throws TemplateException, IOException {
        try {
            this.build(env);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void build(Environment env) throws Exception {
        Context context = Context.current();
        String cPath = context.path();
        if (Session.current().getPUID() == 0) {
            context.redirect("/login");
            return;
        }
        List list = BcfClient.getUserPacks((int)Session.current().getPUID());
        if (list.size() == 0) {
            context.redirect("/login");
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<header>");
        sb.append("<label>");
        sb.append(Solon.cfg().appTitle());
        sb.append("</label>\n");
        sb.append("<nav>");
        for (BcfGroupModel g : list) {
            BcfResourceModel res = BcfClient.getUserFirstResourceByPack((int)Session.current().getPUID(), (int)g.pgid);
            if (Utils.isEmpty((String)res.uri_path)) continue;
            this.buildItem(sb, g.cn_name, res, cPath, g.uri_path);
        }
        sb.append("</nav>\n");
        sb.append("<aside>");
        String temp = Session.current().getUserName();
        if (temp != null) {
            sb.append("<i class='fa fa-user'></i> ");
            sb.append(temp);
        }
        sb.append("<a class='logout' href='/'><i class='fa fa-fw fa-circle-o-notch'></i>\u9000\u51fa</a>");
        sb.append("</aside>");
        sb.append("</header>\n");
        env.getOut().write(sb.toString());
    }

    private void buildItem(StringBuffer sb, String title, BcfResourceModel res, String cPath, String pack) {
        String newUrl = BcfUtil.buildBcfUnipath((BcfResourceModel)res);
        if (cPath.indexOf(pack) == 0) {
            sb.append("<a class='sel' href='" + newUrl + "'>");
            sb.append(title);
            sb.append("</a>");
        } else {
            sb.append("<a href='" + newUrl + "'>");
            sb.append(title);
            sb.append("</a>");
        }
    }
}

