/*
 * Decompiled with CFR 0.152.
 */
package org.noear.srww.uadmin.widget;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.noear.grit.client.GritClient;
import org.noear.grit.client.GritUtil;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceEntity;
import org.noear.grit.model.domain.ResourceGroup;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Component;
import org.noear.solon.core.handle.Context;
import org.noear.srww.uadmin.dso.Session;

@Component(value="view:header")
public class HeaderTag
implements TemplateDirectiveModel {
    public void execute(Environment env, Map map, TemplateModel[] templateModels, TemplateDirectiveBody body) throws TemplateException, IOException {
        try {
            this.build(env);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void build(Environment env) throws Exception {
        Context ctx = Context.current();
        long subjectId = Session.current().getSubjectId();
        String path = ctx.pathNew();
        if (subjectId == 0L) {
            ctx.redirect("/login");
            return;
        }
        List groupList = GritClient.global().auth().getUriGroupList(subjectId);
        if (groupList.size() == 0) {
            ctx.redirect("/login");
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<header>");
        buf.append("<label title='").append("v2.5.3").append("'>");
        buf.append(Solon.cfg().appTitle());
        buf.append("</label>\n");
        buf.append("<nav>");
        for (ResourceGroup group : groupList) {
            ResourceEntity res = GritClient.global().auth().getUriFristByGroup(subjectId, group.resource_id.longValue());
            if (Utils.isEmpty((String)res.link_uri)) continue;
            this.buildGroupItem(buf, group, (Resource)res, path);
        }
        buf.append("</nav>\n");
        buf.append("<aside>");
        String userDisplayName = Session.current().getDisplayName();
        if (Utils.isNotEmpty((String)userDisplayName)) {
            buf.append("<a>");
            buf.append("<i class='fa fa-user'></i> ");
            buf.append(userDisplayName);
            buf.append("</a>");
        }
        buf.append("<a class='split' href='/'><i class='fa fa-fw fa-circle-o-notch'></i>\u9000\u51fa</a>");
        buf.append("</aside>");
        buf.append("</header>\n");
        env.getOut().write(buf.toString());
    }

    private void buildGroupItem(StringBuilder buf, ResourceGroup resourceGroup, Resource res, String path) {
        String newUrl = GritUtil.buildDockUri((Resource)res);
        if (path.indexOf(resourceGroup.link_uri) == 0) {
            buf.append("<a class='sel' href='" + newUrl + "'>");
            buf.append(resourceGroup.display_name);
            buf.append("</a>");
        } else {
            buf.append("<a href='" + newUrl + "'>");
            buf.append(resourceGroup.display_name);
            buf.append("</a>");
        }
    }
}

