/*
 * Decompiled with CFR 0.152.
 */
package org.noear.srww.uadmin.widget;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Component;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Context;

@Component(value="view:stateselector")
public class StateSelectorTag
implements TemplateDirectiveModel {
    private String clientID = "";
    private boolean forPage = true;
    private String onSelect = "";
    private String stateKey = "_state";
    private int state = -1;
    private String items;

    public void execute(Environment env, Map map, TemplateModel[] templateModels, TemplateDirectiveBody body) throws TemplateException, IOException {
        try {
            this.build(env, map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void build(Environment env, Map map) throws Exception {
        NvMap mapExt = new NvMap(map);
        this.clientID = (String)mapExt.getOrDefault((Object)"clientID", (Object)"");
        this.forPage = mapExt.getBool("forPage", true);
        this.onSelect = (String)mapExt.getOrDefault((Object)"onSelect", (Object)"");
        this.state = mapExt.getInt("state", 0);
        this.items = (String)mapExt.getOrDefault((Object)"items", (Object)"");
        this.stateKey = (String)mapExt.getOrDefault((Object)"stateKey", (Object)"_state");
        StringBuilder sb = new StringBuilder();
        String clinetStateKey = this.clientID + this.stateKey;
        sb.append("<script>").append("function " + this.clientID + "_onStateSelect(val,e) { ");
        if (this.forPage && Utils.isEmpty((String)this.onSelect)) {
            sb.append("    urlQueryBy('" + this.stateKey + "',val,'page');");
        } else {
            sb.append("    $('#" + clinetStateKey + "').val(val);").append("    var m = $('#" + this.clientID + "');").append("    m.find('.selected').removeClass('selected');").append("    $(e).addClass('selected');");
            if (!Utils.isEmpty((String)this.onSelect)) {
                sb.append(this.onSelect).append("(val,e);");
            }
        }
        sb.append("} </script>");
        sb.append("<input id='" + clinetStateKey + "' name='" + clinetStateKey + "' value='" + this.getState() + "' type='hidden' />");
        sb.append("<span class='selector' id='" + this.clientID + "'>");
        sb.append(this.buildHtml());
        sb.append("</span>");
        env.getOut().write(sb.toString());
    }

    public int getState() {
        String key = this.clientID + this.stateKey;
        int s1 = this.getInt(key);
        if (s1 > -1) {
            return s1;
        }
        if (this.state > -1) {
            return this.state;
        }
        return 0;
    }

    private int getInt(String key) {
        return Context.current().paramAsInt(key, -1);
    }

    protected String buildHtml() {
        if (this.items == null || this.items.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        for (String item : this.items.split(",")) {
            if (idx == this.getState()) {
                sb.append("<span class='stateItem selected' onclick='" + this.clientID + "_onStateSelect(" + idx + ",this)'>" + item + "</span>");
            } else {
                sb.append("<span class='stateItem' onclick='" + this.clientID + "_onStateSelect(" + idx + ",this)'>" + item + "</span>");
            }
            ++idx;
        }
        return sb.toString();
    }
}

