/*
 * Decompiled with CFR 0.152.
 */
package org.noear.srww.uadmin.controller;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.noear.grit.client.GritClient;
import org.noear.grit.client.GritUtil;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceEntity;
import org.noear.grit.model.domain.Subject;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;
import org.noear.srww.uadmin.controller.BaseController;
import org.noear.srww.uadmin.dso.Session;
import org.noear.water.utils.ImageUtils;
import org.noear.water.utils.RandomUtils;

@Controller
public class LoginController
extends BaseController {
    @Mapping(value="login")
    public ModelAndView login() {
        Session.current().clear();
        return this.view("login");
    }

    @Mapping(value="/")
    public void index() {
        this.redirect("/login");
    }

    @Mapping(value="/login/auto")
    public void login_auto() throws Exception {
        String link_uri;
        long subjectId = Session.current().getSubjectId();
        if (subjectId > 0L && !Utils.isEmpty((String)(link_uri = GritClient.global().auth().getUriFrist((long)subjectId).link_uri))) {
            this.redirect(link_uri);
            return;
        }
        this.redirect("/login");
    }

    @Mapping(value="/login/ajax/check")
    public Result login_ajax_check(String userName, String passWord, String captcha) throws Exception {
        if (!captcha.toLowerCase().equals(Session.current().getValidation())) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        if (Utils.isEmpty((String)userName) || Utils.isEmpty((String)passWord)) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u8bf7\u8f93\u5165\u8d26\u53f7\u548c\u5bc6\u7801\uff01");
        }
        Subject subject = GritClient.global().auth().login(userName, passWord);
        if (Subject.isEmpty((Subject)subject)) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u5bf9\uff01");
        }
        Session.current().loadSubject(subject);
        ResourceEntity res = GritClient.global().auth().getUriFrist(subject.subject_id.longValue());
        if (Utils.isEmpty((String)res.link_uri)) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5f00\u901a\u6743\u9650\uff01");
        }
        String resUrl = GritUtil.buildDockUri((Resource)res);
        return Result.succeed((Object)resUrl);
    }

    @Mapping(value="/login/validation/img", method={MethodType.GET}, produces="image/jpeg")
    public void getValidationImg(Context ctx) throws IOException {
        String validation = RandomUtils.code((int)4);
        Session.current().setValidation(validation);
        BufferedImage bufferedImage = ImageUtils.getValidationImage((String)validation);
        ctx.headerSet("Pragma", "no-cache");
        ctx.headerSet("Cache-Control", "no-cache");
        ctx.headerSet("Expires", "0");
        ImageIO.setUseCache(false);
        ImageIO.write((RenderedImage)bufferedImage, "jpeg", ctx.outputStream());
    }
}

