/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sureness.integration;

import com.usthe.sureness.mgt.SurenessSecurityManager;
import com.usthe.sureness.processor.exception.DisabledAccountException;
import com.usthe.sureness.processor.exception.ExcessiveAttemptsException;
import com.usthe.sureness.processor.exception.ExpiredCredentialsException;
import com.usthe.sureness.processor.exception.IncorrectCredentialsException;
import com.usthe.sureness.processor.exception.NeedDigestInfoException;
import com.usthe.sureness.processor.exception.UnauthorizedException;
import com.usthe.sureness.processor.exception.UnknownAccountException;
import com.usthe.sureness.subject.SubjectSum;
import com.usthe.sureness.util.SurenessContextHolder;
import java.util.Collections;
import java.util.Map;
import org.noear.solon.annotation.Component;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class SurenessFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SurenessFilter.class);

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        try {
            SubjectSum subject = SurenessSecurityManager.getInstance().checkIn((Object)ctx);
            if (subject != null) {
                SurenessContextHolder.bindSubject((SubjectSum)subject);
            }
        }
        catch (ExpiredCredentialsException | IncorrectCredentialsException | UnknownAccountException e1) {
            logger.debug("this request is illegal");
            this.responseWrite(ctx, 401, e1.getMessage(), null);
            return;
        }
        catch (DisabledAccountException | ExcessiveAttemptsException e2) {
            logger.debug("the account is disabled");
            this.responseWrite(ctx, 401, e2.getMessage(), null);
            return;
        }
        catch (NeedDigestInfoException e5) {
            logger.debug("you should try once again with digest auth information");
            this.responseWrite(ctx, 401, "try once again with digest auth information", Collections.singletonMap("WWW-Authenticate", e5.getAuthenticate()));
            return;
        }
        catch (UnauthorizedException e5) {
            logger.debug("this account can not access this resource");
            this.responseWrite(ctx, 403, e5.getMessage(), null);
            return;
        }
        catch (RuntimeException e) {
            logger.error("other exception happen: ", (Throwable)e);
            this.responseWrite(ctx, 409, e.getMessage(), null);
            return;
        }
        chain.doFilter(ctx);
    }

    private void responseWrite(Context ctx, int statusCode, String message, Map<String, String> headers) throws Throwable {
        ctx.statusSet(statusCode);
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((Context)ctx).headerAdd(arg_0, arg_1));
        }
        ctx.render((Object)Result.failure((String)message));
    }
}

