/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.sureness.support;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.support.JwtSubject;
import com.usthe.sureness.util.JsonWebTokenUtil;
import org.noear.solon.core.handle.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtSubjectSolonCreator
implements SubjectCreate {
    private static final Logger logger = LoggerFactory.getLogger(JwtSubjectSolonCreator.class);
    private static final String BEARER = "Bearer";
    private static final String AUTHORIZATION = "Authorization";

    public boolean canSupportSubject(Object context) {
        String authorization;
        if (context instanceof Context && (authorization = ((Context)context).header(AUTHORIZATION)) != null && authorization.startsWith(BEARER)) {
            String jwtValue = authorization.replace(BEARER, "").trim();
            return !JsonWebTokenUtil.isNotJsonWebToken((String)jwtValue);
        }
        return false;
    }

    public Subject createSubject(Object context) {
        String authorization = ((Context)context).header(AUTHORIZATION);
        if (authorization != null && authorization.startsWith(BEARER)) {
            String jwtValue = authorization.replace(BEARER, "").trim();
            if (JsonWebTokenUtil.isNotJsonWebToken((String)jwtValue)) {
                if (logger.isInfoEnabled()) {
                    logger.info("can not create JwtSubject by this request message, is not jwt");
                }
                return null;
            }
            String remoteHost = ((Context)context).ip();
            String requestUri = ((Context)context).pathNew();
            String requestType = ((Context)context).method();
            String targetUri = requestUri.concat("===").concat(requestType.toLowerCase());
            return JwtSubject.builder((String)jwtValue).setRemoteHost(remoteHost).setTargetResource(targetUri).build();
        }
        return null;
    }
}

