/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.util.TreeMap;

public class SimplifiedToHongKongChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    public static String convertToTraditionalHongKongChinese(String simplifiedChineseString) {
        return SimplifiedToHongKongChineseDictionary.segLongest(simplifiedChineseString.toCharArray(), trie);
    }

    public static String convertToTraditionalHongKongChinese(char[] simplifiedChinese) {
        return SimplifiedToHongKongChineseDictionary.segLongest(simplifiedChinese, trie);
    }

    static {
        long start = System.currentTimeMillis();
        String datPath = HanLP.Config.tcDictionaryRoot + "s2hk";
        if (!SimplifiedToHongKongChineseDictionary.loadDat(datPath, trie)) {
            TreeMap<String, String> s2t = new TreeMap<String, String>();
            TreeMap<String, String> t2hk = new TreeMap<String, String>();
            if (!SimplifiedToHongKongChineseDictionary.load(s2t, false, HanLP.Config.tcDictionaryRoot + "s2t.txt") || !SimplifiedToHongKongChineseDictionary.load(t2hk, false, HanLP.Config.tcDictionaryRoot + "t2hk.txt")) {
                throw new IllegalArgumentException("\u7b80\u4f53\u8f6c\u9999\u6e2f\u7e41\u4f53\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25");
            }
            SimplifiedToHongKongChineseDictionary.combineChain(s2t, t2hk);
            trie.build(s2t);
            SimplifiedToHongKongChineseDictionary.saveDat(datPath, trie, s2t.entrySet());
        }
        Predefine.logger.info("\u7b80\u4f53\u8f6c\u9999\u6e2f\u7e41\u4f53\u8bcd\u5178\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }
}

