/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.util.TreeMap;

public class TaiwanToTraditionalChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    public static String convertToTraditionalChinese(String traditionalTaiwanChineseString) {
        return TaiwanToTraditionalChineseDictionary.segLongest(traditionalTaiwanChineseString.toCharArray(), trie);
    }

    public static String convertToTraditionalChinese(char[] traditionalTaiwanChineseString) {
        return TaiwanToTraditionalChineseDictionary.segLongest(traditionalTaiwanChineseString, trie);
    }

    static {
        long start = System.currentTimeMillis();
        String datPath = HanLP.Config.tcDictionaryRoot + "tw2t";
        if (!TaiwanToTraditionalChineseDictionary.loadDat(datPath, trie)) {
            TreeMap<String, String> tw2t = new TreeMap<String, String>();
            if (!TaiwanToTraditionalChineseDictionary.load(tw2t, true, HanLP.Config.tcDictionaryRoot + "t2tw.txt")) {
                throw new IllegalArgumentException("\u53f0\u6e7e\u7e41\u4f53\u8f6c\u7e41\u4f53\u52a0\u8f7d\u5931\u8d25");
            }
            trie.build(tw2t);
            TaiwanToTraditionalChineseDictionary.saveDat(datPath, trie, tw2t.entrySet());
        }
        Predefine.logger.info("\u53f0\u6e7e\u7e41\u4f53\u8f6c\u7e41\u4f53\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }
}

