/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.AbstractClosestVectors;
import java.io.IOException;

public class WordAnalogy
extends AbstractClosestVectors {
    protected WordAnalogy(String file) {
        super(file);
    }

    static void usage() {
        System.err.printf("Usage: java %s <FILE>\nwhere FILE contains word projections in the text format\n", WordAnalogy.class.getName());
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            WordAnalogy.usage();
        }
        new WordAnalogy(args[0]).execute();
    }

    @Override
    protected AbstractClosestVectors.Result getTargetVector() {
        int words = this.vectorsReader.getNumWords();
        int size = this.vectorsReader.getSize();
        String[] input = null;
        while ((input = this.nextWords(3, "Enter 3 words")) != null) {
            int[] bi = new int[input.length];
            int found = 0;
            for (int k = 0; k < input.length; ++k) {
                for (int i = 0; i < words; ++i) {
                    if (!input[k].equals(this.vectorsReader.getWord(i))) continue;
                    bi[k] = i;
                    System.out.printf("\nWord: %s  Position in vocabulary: %d\n", input[k], bi[k]);
                    ++found;
                }
                if (found != k) continue;
                System.out.printf("%s : Out of dictionary word!\n", input[k]);
            }
            if (found < input.length) continue;
            float[] vec = new float[size];
            double len = 0.0;
            for (int j = 0; j < size; ++j) {
                vec[j] = this.vectorsReader.getMatrixElement(bi[1], j) - this.vectorsReader.getMatrixElement(bi[0], j) + this.vectorsReader.getMatrixElement(bi[2], j);
                len += (double)(vec[j] * vec[j]);
            }
            len = Math.sqrt(len);
            int i = 0;
            while (i < size) {
                int n = i++;
                vec[n] = (float)((double)vec[n] / len);
            }
            return new AbstractClosestVectors.Result(vec, bi);
        }
        return null;
    }
}

