/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.vaptcha.http.request.validators;

import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.extend.vaptcha.entities.ValidateResult;
import org.noear.solon.extend.vaptcha.entities.iVaptcha;
import org.noear.solon.extend.vaptcha.http.request.validators.Vaptcha;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.ValidatorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaptchaValidator
implements Validator<Vaptcha> {
    static Logger log = LoggerFactory.getLogger(VaptchaValidator.class);
    private String realIp;
    private final OkHttpClient client = new OkHttpClient();
    private final Props props = Solon.cfg().getProp("vaptcha");

    public String message(Vaptcha annotation) {
        return annotation.message();
    }

    public Result validateOfValue(Vaptcha anno, Object val0, StringBuilder tmp) {
        if (val0 instanceof iVaptcha) {
            return this.verify(anno, (iVaptcha)val0) ? Result.succeed() : Result.failure();
        }
        return Result.failure();
    }

    public Result validateOfContext(Context ctx, Vaptcha anno, String name, StringBuilder tmp) {
        String value = ctx.param(name);
        return value == null || this.verify(anno, (iVaptcha)ONode.deserialize((String)value, iVaptcha.class)) ? Result.succeed() : Result.failure((String)name);
    }

    private boolean verify(Vaptcha annotation, iVaptcha vaptcha) {
        Result result0 = ValidatorManager.validateOfEntity((Object)vaptcha);
        if (result0.getCode() == Result.FAILURE_CODE) {
            return false;
        }
        String realIp = vaptcha.getRealIp();
        if (Utils.isEmpty((String)realIp)) {
            realIp = Context.current().realIp();
        }
        FormBody body = new FormBody.Builder().add("id", this.props.get("vid")).add("secretkey", this.props.get("key")).add("scene", "3").add("token", vaptcha.getToken()).add("ip", this.getRealIp(realIp)).build();
        Request request = new Request.Builder().url(vaptcha.getServer()).post((RequestBody)body).build();
        Call call = this.client.newCall(request);
        try {
            Response response = call.execute();
            if (response.body() == null) {
                return false;
            }
            ValidateResult result = (ValidateResult)ONode.deserialize((String)response.body().string(), ValidateResult.class);
            return result.getSuccess();
        }
        catch (Exception exception) {
            log.error("Something went wrong.", (Throwable)exception);
            return false;
        }
    }

    private String getRealIp(String realIp) {
        if (realIp.contains("127.0.0.1") || this.props.getBool("local", false)) {
            if (this.realIp != null) {
                return this.realIp;
            }
            Request request = new Request.Builder().url("https://ip.tool.lu/").get().build();
            Call call = this.client.newCall(request);
            try {
                Response response = call.execute();
                if (response.body() != null) {
                    String[] tmp = response.body().string().split("\\r?\\n");
                    this.realIp = tmp[0].split(" ")[1];
                    return this.realIp;
                }
            }
            catch (Exception exception) {
                log.error("Something went wrong.", (Throwable)exception);
            }
        } else if (realIp.startsWith("/")) {
            realIp = realIp.substring(1);
        }
        return realIp;
    }
}

