/*
 * Decompiled with CFR 0.152.
 */
package org.noear.waad.mapper.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.waad.DbContext;
import org.noear.waad.TableQuery;
import org.noear.waad.linq.IColumn;
import org.noear.waad.linq.IColumnLinq;
import org.noear.waad.mapper.BaseMapper;
import org.noear.waad.mapper.MapperWhere;
import org.noear.waad.mapper.impl.BaseEntityWrap;
import org.noear.waad.model.DataReader;
import org.noear.waad.model.DataReaderForDataRow;
import org.noear.waad.model.DataRow;
import org.noear.waad.model.Page;
import org.noear.waad.model.PageImpl;
import org.noear.waad.util.RunUtils;
import org.noear.waad.util.StrUtils;
import org.noear.waad.util.function.Act1;
import org.noear.waad.util.function.Act2;

public class BaseMapperWrap<T>
implements BaseMapper<T> {
    private DbContext _db;
    private BaseEntityWrap _table;
    private String _tabelName;
    private Class<?> _entityType;

    protected Class<?> entityType() {
        return this._entityType;
    }

    public BaseMapperWrap(DbContext db, Class<?> entityType, String tableName) {
        this._db = db;
        this._entityType = entityType;
        this._table = BaseEntityWrap.get(this);
        this._tabelName = StrUtils.isEmpty((String)tableName) ? this._table.tableName : tableName;
    }

    public BaseMapperWrap(DbContext db, BaseMapper<T> baseMapper) {
        this._db = db;
        this._table = BaseEntityWrap.get(baseMapper);
        this._tabelName = this._table.tableName;
    }

    public DbContext db() {
        return this._db;
    }

    public String tableName() {
        return this._tabelName;
    }

    public String tablePk() {
        return this._table.pkName;
    }

    public Class<?> entityClz() {
        return this._table.entityClz;
    }

    public Long insert(T entity, boolean excludeNull) {
        DataRow data = DataRow.create();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        return (Long)RunUtils.call(() -> this.getQr().insert(data));
    }

    public Long insert(T entity, Act2<T, DataRow> dataBuilder) {
        DataRow data = DataRow.create();
        dataBuilder.run(entity, (Object)data);
        return (Long)RunUtils.call(() -> this.getQr().insert(data));
    }

    public void insertList(List<T> list) {
        ArrayList<DataRow> list2 = new ArrayList<DataRow>();
        for (T d : list) {
            list2.add(DataRow.create().setEntityIf(d, (k, v) -> true));
        }
        RunUtils.call(() -> this.getQr().insertList(list2));
    }

    public void insertList(List<T> list, Act2<T, DataRow> dataBuilder) {
        ArrayList<DataRow> list2 = new ArrayList<DataRow>();
        for (T d : list) {
            DataRow data = DataRow.create();
            dataBuilder.run(d, (Object)data);
            list2.add(data);
        }
        RunUtils.call(() -> this.getQr().insertList(list2));
    }

    public Integer deleteById(Object id) {
        return (Integer)RunUtils.call(() -> ((TableQuery)this.getQr().where(new IColumnLinq(this.tablePk()).eq(id))).delete());
    }

    public Integer deleteByIds(Iterable idList) {
        return (Integer)RunUtils.call(() -> ((TableQuery)this.getQr().where(new IColumnLinq(this.tablePk()).in(idList))).delete());
    }

    public Integer deleteByMap(Map<String, Object> columnMap) {
        return (Integer)RunUtils.call(() -> ((TableQuery)this.getQr().whereMap(columnMap)).delete());
    }

    public Integer delete(Act1<MapperWhere> c) {
        return (Integer)RunUtils.call(() -> this.getQr(c).delete());
    }

    public Integer updateById(T entity, boolean excludeNull) {
        DataRow data = DataRow.create();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        Object id = data.get(this.tablePk());
        return (Integer)RunUtils.call(() -> ((TableQuery)this.getQr().where(new IColumnLinq(this.tablePk()).eq(id))).update(data));
    }

    public Integer updateById(T entity, Act2<T, DataRow> dataBuilder) {
        DataRow data = DataRow.create();
        dataBuilder.run(entity, (Object)data);
        Object id = data.get(this.tablePk());
        return (Integer)RunUtils.call(() -> ((TableQuery)this.getQr().where(new IColumnLinq(this.tablePk()).eq(id))).update(data));
    }

    public Integer update(T entity, boolean excludeNull, Act1<MapperWhere> c) {
        DataRow data = DataRow.create();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        return (Integer)RunUtils.call(() -> this.getQr(c).update(data));
    }

    public Integer update(T entity, Act2<T, DataRow> dataBuilder, Act1<MapperWhere> c) {
        DataRow data = DataRow.create();
        dataBuilder.run(entity, (Object)data);
        return (Integer)RunUtils.call(() -> this.getQr(c).update(data));
    }

    public int[] updateList(List<T> list, Act2<T, DataRow> dataBuilder, IColumn ... conditionColumns) {
        if (conditionColumns.length == 0) {
            throw new RuntimeException("Please enter constraints");
        }
        return this.updateList(list, dataBuilder, IColumn.getNemes((DbContext)this._db, (IColumn[])conditionColumns));
    }

    public int[] updateList(List<T> list, Act2<T, DataRow> dataBuilder, String conditionColumns) {
        if (StrUtils.isEmpty((String)conditionColumns)) {
            throw new RuntimeException("Please enter constraints");
        }
        return (int[])RunUtils.call(() -> this.getQr().updateList((Collection)list, dataBuilder, conditionColumns));
    }

    public Long upsert(T entity, boolean excludeNull) {
        DataRow data = DataRow.create();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        Object id = data.get(this.tablePk());
        if (id == null) {
            return (Long)RunUtils.call(() -> this.getQr().insert(data));
        }
        return (Long)RunUtils.call(() -> this.getQr().upsertBy(data, this.tablePk()));
    }

    public Long upsert(T entity, Act2<T, DataRow> dataBuilder) {
        DataRow data = DataRow.create();
        dataBuilder.run(entity, (Object)data);
        Object id = data.get(this.tablePk());
        if (id == null) {
            return (Long)RunUtils.call(() -> this.getQr().insert(data));
        }
        return (Long)RunUtils.call(() -> this.getQr().upsertBy(data, this.tablePk()));
    }

    public Long upsertBy(T entity, boolean excludeNull, IColumn ... conditionColumns) {
        return this.upsertBy(entity, excludeNull, IColumn.getNemes((DbContext)this._db, (IColumn[])conditionColumns));
    }

    public Long upsertBy(T entity, boolean excludeNull, String conditionColumns) {
        DataRow data = DataRow.create();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        return (Long)RunUtils.call(() -> this.getQr().upsertBy(data, conditionColumns));
    }

    public Long upsertBy(T entity, Act2<T, DataRow> dataBuilder, IColumn ... conditionColumns) {
        return this.upsertBy(entity, dataBuilder, IColumn.getNemes((DbContext)this._db, (IColumn[])conditionColumns));
    }

    public Long upsertBy(T entity, Act2<T, DataRow> dataBuilder, String conditionColumns) {
        DataRow data = DataRow.create();
        dataBuilder.run(entity, (Object)data);
        return (Long)RunUtils.call(() -> this.getQr().upsertBy(data, conditionColumns));
    }

    public boolean existsById(Object id) {
        return (Boolean)RunUtils.call(() -> ((TableQuery)this.getQr().where(new IColumnLinq(this.tablePk()).eq(id))).selectExists());
    }

    public boolean exists(Act1<MapperWhere> c) {
        return (Boolean)RunUtils.call(() -> this.getQr(c).selectExists());
    }

    public T selectById(Object id) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> ((TableQuery)((TableQuery)this.getQr().where(new IColumnLinq(this.tablePk()).eq(id))).limit(1)).selectItem(clz, "*"));
    }

    public List<T> selectByIds(Iterable idList) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> ((TableQuery)this.getQr().where(new IColumnLinq(this.tablePk()).in(idList))).selectList(clz, "*"));
    }

    public List<T> selectByMap(Map<String, Object> columnMap) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> ((TableQuery)this.getQr().whereMap(columnMap)).selectList(clz, "*"));
    }

    public T selectItem(T entity) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> ((TableQuery)((TableQuery)this.getQr().whereEntity(entity)).limit(1)).selectItem(clz, "*"));
    }

    public T selectItem(Act1<MapperWhere> c) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> this.getQr(c).selectItem(clz, "*"));
    }

    public Object selectValue(String column, Act1<MapperWhere> c) {
        return RunUtils.call(() -> this.getQr(c).selectValue(column));
    }

    public Map<String, Object> selectMap(Act1<MapperWhere> c) {
        return (Map)RunUtils.call(() -> this.getQr(c).selectMap("*"));
    }

    public Long selectCount(Act1<MapperWhere> c) {
        return (Long)RunUtils.call(() -> this.getQr(c).selectCount());
    }

    public List<T> selectList(Act1<MapperWhere> c) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> this.getQr(c).selectList(clz, "*"));
    }

    public List<Map<String, Object>> selectMapList(Act1<MapperWhere> c) {
        return (List)RunUtils.call(() -> this.getQr(c).selectMapList("*"));
    }

    public List<Object> selectArray(String column, Act1<MapperWhere> c) {
        return (List)RunUtils.call(() -> this.getQr(c).selectArray(column));
    }

    public List<T> selectList(int start, int size, Act1<MapperWhere> c) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> ((TableQuery)this.getQr(c).limit(start, size)).selectList(clz, "*"));
    }

    public List<Map<String, Object>> selectMapList(int start, int size, Act1<MapperWhere> c) {
        return (List)RunUtils.call(() -> ((TableQuery)this.getQr(c).limit(start, size)).selectMapList("*"));
    }

    public List<Object> selectArray(String column, int start, int size, Act1<MapperWhere> c) {
        return (List)RunUtils.call(() -> ((TableQuery)this.getQr(c).limit(start, size)).selectArray(column));
    }

    public DataReader<T> selectReader(Act1<MapperWhere> c) {
        return this.selectReader(0, c);
    }

    public DataReader<T> selectReader(int fetchSize, Act1<MapperWhere> c) {
        Class<?> clz = this.entityClz();
        DataReaderForDataRow reader = (DataReaderForDataRow)RunUtils.call(() -> ((TableQuery)this.getQr(c).fetchSize(fetchSize)).selectDataReader("*"));
        return reader.toEntityReader(clz);
    }

    public Page<T> selectPage(int start, int size, Act1<MapperWhere> c) {
        Class<?> clz = this.entityClz();
        List list = (List)RunUtils.call(() -> ((TableQuery)this.getQr(c).limit(start, size)).selectList(clz, "*"));
        long total = (Long)RunUtils.call(() -> this.getQr(c).selectCount());
        PageImpl page = new PageImpl(list, total, size);
        return page;
    }

    public Page<Map<String, Object>> selectMapPage(int start, int size, Act1<MapperWhere> c) {
        List list = (List)RunUtils.call(() -> ((TableQuery)this.getQr(c).limit(start, size)).selectMapList("*"));
        long total = (Long)RunUtils.call(() -> this.getQr(c).selectCount());
        PageImpl page = new PageImpl(list, total, size);
        return page;
    }

    public List<T> selectTop(int size, Act1<MapperWhere> c) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> ((TableQuery)this.getQr(c).top(size)).selectList(clz, "*"));
    }

    public List<Map<String, Object>> selectMapTop(int size, Act1<MapperWhere> c) {
        return (List)RunUtils.call(() -> ((TableQuery)this.getQr(c).top(size)).selectMapList("*"));
    }

    protected TableQuery getQr() {
        return this.db().table(this.tableName());
    }

    protected TableQuery getQr(Act1<MapperWhere> c) {
        TableQuery qr = this.db().table(this.tableName());
        if (c != null) {
            c.run((Object)new MapperWhere(qr));
        }
        return qr;
    }
}

