/*
 * Decompiled with CFR 0.152.
 */
package org.noear.waad.mapper.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.noear.waad.DbContext;
import org.noear.waad.annotation.Namespace;
import org.noear.waad.mapper.BaseMapper;
import org.noear.waad.mapper.impl.MapperInvoke;
import org.noear.waad.mapper.impl.MapperInvokeForAnn;
import org.noear.waad.mapper.impl.MapperInvokeForBas;
import org.noear.waad.mapper.impl.MapperInvokeForXml;
import org.noear.waad.util.InvocationHandlerUtils;
import org.noear.waad.util.ThrowableUtils;
import org.noear.waad.wrap.MethodWrap;

public class MapperHandler
implements InvocationHandler {
    private static MapperInvoke annInvoke = new MapperInvokeForAnn();
    private static MapperInvoke xmlInvoke = new MapperInvokeForXml();
    private static MapperInvokeForBas basInvoke = new MapperInvokeForBas();
    protected DbContext db;
    protected Class<?> mapperClz;
    protected static UnsupportedOperationException UOE = new UnsupportedOperationException();

    protected MapperHandler(DbContext db, Class<?> mapperClz) {
        this.db = db;
        this.mapperClz = mapperClz;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.invoke0(proxy, method, args);
        }
        catch (Throwable ex) {
            ex = ThrowableUtils.throwableUnwrap((Throwable)ex);
            if (ex instanceof RuntimeException) {
                throw ex;
            }
            if (ex instanceof SQLException) {
                throw ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public Object invoke0(Object proxy, Method method, Object[] args) throws Throwable {
        MethodWrap mWrap;
        Class<?> caller = method.getDeclaringClass();
        if (method.isDefault()) {
            return InvocationHandlerUtils.invokeDefault((Object)proxy, (Method)method, (Object[])args);
        }
        if (caller == Object.class) {
            return InvocationHandlerUtils.invokeObject(this.mapperClz, (Object)proxy, (Method)method, (Object[])args);
        }
        if (caller == BaseMapper.class) {
            return basInvoke.callDo(proxy, this.db, method, args);
        }
        String sqlid = MapperHandler.getSqlid(caller, method);
        Object tmp = annInvoke.call(proxy, this.db, sqlid, caller, mWrap = MethodWrap.get((Method)method), args);
        if (UOE.equals(tmp) && UOE.equals(tmp = xmlInvoke.call(proxy, this.db, sqlid, caller, mWrap, args)) && UOE.equals(tmp = basInvoke.call(proxy, this.db, sqlid, caller, mWrap, args))) {
            throw new RuntimeException("Mapper is not implemented(or no xmlsql):@" + sqlid);
        }
        return tmp;
    }

    public static String getSqlid(Class<?> mapperClz, Method method) {
        Namespace c_meta = mapperClz.getAnnotation(Namespace.class);
        String fun_name = method.getName();
        if (c_meta == null) {
            return mapperClz.getPackage().getName() + "." + fun_name;
        }
        return c_meta.value() + "." + fun_name;
    }
}

