/*
 * Decompiled with CFR 0.152.
 */
package org.noear.waad.mapper.impl;

import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.waad.DbContext;
import org.noear.waad.WaadConfig;
import org.noear.waad.annotation.Sql;
import org.noear.waad.cache.ICacheService;
import org.noear.waad.core.DataAccess;
import org.noear.waad.mapper.impl.MapperHandler;
import org.noear.waad.mapper.impl.MapperInvoke;
import org.noear.waad.model.DataList;
import org.noear.waad.model.DataRow;
import org.noear.waad.model.Variate;
import org.noear.waad.util.StrUtils;
import org.noear.waad.wrap.MethodWrap;

public class MapperInvokeForAnn
implements MapperInvoke {
    @Override
    public Object call(Object proxy, DbContext db, String sqlid, Class<?> caller, MethodWrap mWrap, Object[] args) throws Throwable {
        Sql ann = mWrap.method.getAnnotation(Sql.class);
        if (ann == null) {
            return MapperHandler.UOE;
        }
        String _sql = ann.value();
        String _caching = ann.caching();
        String _cacheClear = ann.cacheClear();
        ICacheService cache_tmp = null;
        if (!StrUtils.isEmpty((String)_caching) && (cache_tmp = (ICacheService)WaadConfig.libOfCache.get(_caching)) == null) {
            throw new RuntimeException("WaadConfig.libOfCache does not exist:@" + _caching);
        }
        HashMap<String, Object> _map = new HashMap<String, Object>();
        Parameter[] names = mWrap.parameters;
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            if (args[i] == null) continue;
            String key = names[i].getName();
            Object val = args[i];
            if ("_map".equals(key) && val instanceof Map) {
                _map.putAll((Map)val);
                continue;
            }
            _map.put(key, val);
        }
        String sqlUp = "# " + _sql.toUpperCase();
        Object sp = null;
        sp = sqlUp.indexOf("@") > 0 ? db.call(_sql).setMap(_map) : (sqlUp.indexOf("?") > 0 ? db.sql(_sql, args) : db.sql(_sql, new Object[0]));
        ICacheService cache = cache_tmp;
        if (sqlUp.indexOf(" DELETE ") > 0 || sqlUp.indexOf(" UPDATE ") > 0) {
            int rst = sp.execute();
            if (cache != null && !StrUtils.isEmpty((String)_cacheClear)) {
                Arrays.asList(this.formatTag(_cacheClear, _map).split(",")).forEach(k -> cache.clear(k));
            }
            return rst;
        }
        if (sqlUp.indexOf(" INSERT ") > 0) {
            long rst = sp.insert();
            if (cache != null && !StrUtils.isEmpty((String)_cacheClear)) {
                Arrays.asList(this.formatTag(_cacheClear, _map).split(",")).forEach(k -> cache.clear(k));
            }
            return rst;
        }
        if (sqlUp.indexOf(" SELECT ") > 0) {
            return this.forSelect((DataAccess)sp, _map, mWrap, ann, cache);
        }
        return null;
    }

    private Object forSelect(DataAccess sp, Map<String, Object> map, MethodWrap mWrap, Sql ann, ICacheService cache) throws Throwable {
        String _cacheTag = ann.cacheTag();
        int _usingCache = ann.usingCache();
        if (cache != null) {
            sp.caching(cache);
            if (_usingCache > 0) {
                sp.usingCache(_usingCache);
            }
            if (!StrUtils.isEmpty((String)_cacheTag)) {
                if ((_cacheTag = this.formatTag(_cacheTag, map)).indexOf("}") < 0) {
                    Arrays.asList(_cacheTag.split(",")).forEach(k -> sp.cacheTag(k));
                } else {
                    String _cacheTag2 = _cacheTag;
                    sp.cacheUsing().usingCache((cu, rst) -> {
                        if (rst instanceof DataRow) {
                            Arrays.asList(this.formatTag(_cacheTag2, ((DataRow)rst).getMap()).split(",")).forEach(k -> sp.cacheTag(k));
                        }
                    });
                }
            }
        }
        Class rst_type = mWrap.returnType;
        Type rst_type2 = mWrap.returnGenericType;
        String rst_type_str = rst_type.getName();
        String rst_type2_str = null;
        if (DataRow.class.isAssignableFrom(rst_type)) {
            return sp.getDataRow();
        }
        if (DataList.class.isAssignableFrom(rst_type)) {
            return sp.getDataList();
        }
        if (Map.class.isAssignableFrom(rst_type)) {
            return sp.getMap();
        }
        if (Collection.class.isAssignableFrom(rst_type)) {
            rst_type2_str = (rst_type2 = ((ParameterizedType)rst_type2).getActualTypeArguments()[0]).getTypeName();
            if (!rst_type2_str.startsWith("java.")) {
                Class rst_clz2 = (Class)rst_type2;
                return sp.getList(rst_clz2);
            }
            if (rst_type2_str.indexOf("Map") > 0) {
                return sp.getMapList();
            }
            return sp.getDataList().toArray(0);
        }
        if (!rst_type_str.startsWith("java") && rst_type_str.indexOf(".") > 0) {
            return sp.getItem(rst_type);
        }
        Variate val = sp.getVariate();
        if (Long.class == rst_type || rst_type == Long.TYPE) {
            return val.longValue(Long.valueOf(0L));
        }
        if (Integer.class == rst_type || rst_type == Integer.TYPE) {
            return val.intValue(Integer.valueOf(0));
        }
        return val.getValue();
    }

    private String formatTag(String tags, Map map) {
        String tags2 = tags;
        Pattern pattern = Pattern.compile("\\$\\{(\\w+)\\}");
        Matcher m = pattern.matcher(tags);
        while (m.find()) {
            String mark = m.group(0);
            String name = m.group(1);
            if (!map.containsKey(name)) continue;
            String val = String.valueOf(map.get(name));
            tags2 = tags2.replace(mark, val);
        }
        return tags2;
    }
}

