/*
 * Decompiled with CFR 0.152.
 */
package org.noear.waad.mapper.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.waad.DbContext;
import org.noear.waad.DbProcedure;
import org.noear.waad.WaadConfig;
import org.noear.waad.mapper.impl.MapperHandler;
import org.noear.waad.mapper.xml.XmlSqlBlock;
import org.noear.waad.mapper.xml.XmlSqlFactory;
import org.noear.waad.mapper.xml.XmlSqlLoader;
import org.noear.waad.model.Variate;
import org.noear.waad.util.StrUtils;

public class MapperUtil {
    private static final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private static Map<String, Class<?>> _clzMap = new HashMap();

    public static <T> T createProxy(Class<?> mapperInf, DbContext db) {
        XmlSqlLoader.tryLoad();
        return (T)Proxy.newProxyInstance(mapperInf.getClassLoader(), new Class[]{mapperInf}, (InvocationHandler)new MapperHandler(db, mapperInf));
    }

    public static Object exec(DbContext db, String xsqlid, Map<String, Object> paramS, Class<?> rClz, Type rType) throws Exception {
        XmlSqlBlock block = XmlSqlFactory.get(xsqlid.substring(1));
        if (block == null) {
            throw new RuntimeException("Xmlsql does not exist:" + xsqlid);
        }
        return MapperUtil.exec(db, block, xsqlid, paramS, rClz, rType);
    }

    protected static Object exec(DbContext db, XmlSqlBlock block, String xsqlid, Map<String, Object> paramS, Class<?> rClz, Type rType) throws Exception {
        DbProcedure sp = db.call(xsqlid);
        if (paramS != null) {
            sp.setMap(paramS);
        }
        if (block.isSelect()) {
            if (block._return.indexOf(".") > 0) {
                if (block._return_item != null) {
                    if (block._return.indexOf("java.lang.") > 0) {
                        return sp.getArray(0);
                    }
                    Class<?> rst_clz2 = MapperUtil.item_type(rType, block);
                    return sp.getList(rst_clz2);
                }
                Class<Object> rst_type = rClz;
                if (rClz == null) {
                    rst_type = !StrUtils.isEmpty((String)block._return) ? Class.forName(block._return) : Void.TYPE;
                }
                return sp.getItem(rst_type);
            }
            if (block._return.startsWith("List<")) {
                return sp.getDataList().toArray(0);
            }
            if (block._return.startsWith("Set<")) {
                return sp.getDataList().toSet(0);
            }
            switch (block._return) {
                case "Map": {
                    return sp.getMap();
                }
                case "MapList": {
                    return sp.getMapList();
                }
                case "DataRow": {
                    return sp.getDataRow();
                }
                case "DataList": {
                    return sp.getDataList();
                }
            }
            Variate valV = sp.getVariate();
            if (valV.getValue() == null) {
                if (Integer.TYPE == rType) {
                    return WaadConfig.isSelectNullAsDefault ? Integer.valueOf(0) : null;
                }
                if (Long.TYPE == rType) {
                    return WaadConfig.isSelectNullAsDefault ? Long.valueOf(0L) : null;
                }
                if (Float.TYPE == rType) {
                    return WaadConfig.isSelectNullAsDefault ? Float.valueOf(0.0f) : null;
                }
                if (Double.TYPE == rType) {
                    return WaadConfig.isSelectNullAsDefault ? Double.valueOf(0.0) : null;
                }
            } else {
                if (block._return.toLowerCase().startsWith("int")) {
                    return valV.intValue(WaadConfig.isSelectNullAsDefault ? Integer.valueOf(0) : null);
                }
                if (block._return.toLowerCase().startsWith("long")) {
                    return valV.longValue(WaadConfig.isSelectNullAsDefault ? Long.valueOf(0L) : null);
                }
                if (block._return.toLowerCase().startsWith("float")) {
                    return valV.floatValue(WaadConfig.isSelectNullAsDefault ? Float.valueOf(0.0f) : null);
                }
                if (block._return.toLowerCase().startsWith("double")) {
                    return valV.doubleValue(WaadConfig.isSelectNullAsDefault ? Double.valueOf(0.0) : null);
                }
                if (block._return.toLowerCase().startsWith("str")) {
                    return valV.stringValue(null);
                }
            }
            return valV.getValue();
        }
        if (block.isInsert()) {
            long rst = sp.insert();
            if (block._return != null && block._return.indexOf("ool") > 0) {
                return rst > 0L;
            }
            return rst;
        }
        int rst = sp.execute();
        if (block._return != null && block._return.indexOf("ool") > 0) {
            return rst > 0;
        }
        return rst;
    }

    private static Class<?> item_type(Type rType, XmlSqlBlock block) throws Exception {
        if (rType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)rType).getActualTypeArguments()[0];
        }
        if (!StrUtils.isEmpty((String)block._return_item)) {
            return MapperUtil.getClass(block._return_item);
        }
        return null;
    }

    private static Class<?> getClass(String fullname) throws Exception {
        Class<?> tmp = _clzMap.get(fullname);
        if (tmp == null) {
            SYNC_LOCK.lock();
            try {
                tmp = _clzMap.get(fullname);
                if (tmp == null) {
                    tmp = Class.forName(fullname);
                    _clzMap.put(fullname, tmp);
                }
            }
            finally {
                SYNC_LOCK.unlock();
            }
        }
        return tmp;
    }
}

